/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.timing;

import java.util.LinkedList;
import java.util.List;
import org.apache.batik.anim.timing.TimedDocumentRoot;
import org.apache.batik.anim.timing.TimedElement;

public abstract class TimeContainer
extends TimedElement {
    protected List children = new LinkedList();

    public void addChild(TimedElement timedElement) {
        if (timedElement == this) {
            throw new IllegalArgumentException("recursive datastructure not allowed here!");
        }
        this.children.add(timedElement);
        timedElement.parent = this;
        this.setRoot(timedElement, this.root);
        this.root.fireElementAdded(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    protected void setRoot(TimedElement timedElement, TimedDocumentRoot timedDocumentRoot) {
        timedElement.root = timedDocumentRoot;
        if (timedElement instanceof TimeContainer) {
            TimeContainer timeContainer = (TimeContainer)timedElement;
            for (TimedElement timedElement2 : timeContainer.children) {
                this.setRoot(timedElement2, timedDocumentRoot);
            }
        }
    }

    public void removeChild(TimedElement timedElement) {
        this.children.remove(timedElement);
        timedElement.parent = null;
        this.setRoot(timedElement, null);
        this.root.fireElementRemoved(timedElement);
        this.root.currentIntervalWillUpdate();
    }

    public TimedElement[] getChildren() {
        return this.children.toArray(new TimedElement[0]);
    }

    @Override
    protected float sampleAt(float f, boolean bl) {
        super.sampleAt(f, bl);
        return this.sampleChildren(f, bl);
    }

    protected float sampleChildren(float f, boolean bl) {
        float f2 = Float.POSITIVE_INFINITY;
        for (TimedElement timedElement : this.children) {
            float f3 = timedElement.sampleAt(f, bl);
            if (!(f3 < f2)) continue;
            f2 = f3;
        }
        return f2;
    }

    @Override
    protected void reset(boolean bl) {
        super.reset(bl);
        for (TimedElement timedElement : this.children) {
            timedElement.reset(bl);
        }
    }

    @Override
    protected boolean isConstantAnimation() {
        return false;
    }

    public abstract float getDefaultBegin(TimedElement var1);
}

