set(APP_NAME Kodi)
set(APP_NAME_LC kodi)
set(APP_NAME_UC KODI)
set(APP_VERSION_MAJOR 17)
set(APP_VERSION_MINOR 6)
if(NOT KODI_PREFIX)
  set(KODI_PREFIX /usr)
endif()
if(NOT KODI_INCLUDE_DIR)
  set(KODI_INCLUDE_DIR /usr/include/kodi)
endif()
if(NOT KODI_LIB_DIR)
  set(KODI_LIB_DIR /usr/lib/kodi)
endif()
if(NOT KODI_DATA_DIR)
  set(KODI_DATA_DIR /usr/share/kodi)
endif()
if(NOT WIN32)
  set(CMAKE_CXX_FLAGS "$ENV{CXXFLAGS} -std=c++11")
endif()
list(APPEND CMAKE_MODULE_PATH /usr/lib/kodi /usr/share/kodi/cmake)

string(REPLACE ";" " " ARCH_DEFINES "-D_LINUX;-DTARGET_POSIX;-DTARGET_LINUX;-DHAVE_SSE=1;-DHAVE_SSE2=1;-DHAVE_SSE3=1;-DHAVE_SSSE3=1;-DHAVE_SSE4_1=1")
add_definitions(${ARCH_DEFINES} -DBUILD_KODI_ADDON)

if(NOT CORE_SYSTEM_NAME)
  if(CMAKE_SYSTEM_NAME STREQUAL "Darwin")
    set(CORE_SYSTEM_NAME "osx")
  else()
    string(TOLOWER ${CMAKE_SYSTEM_NAME} CORE_SYSTEM_NAME)
  endif()
endif()

include(AddonHelpers)
