/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public abstract class FormatCallout {
    protected static final String foURI = "http://www.w3.org/1999/XSL/Format";
    protected static final String xhURI = "http://www.w3.org/1999/xhtml";
    protected String uri = "";
    protected boolean foStylesheet = false;
    protected boolean xhStylesheet = false;
    protected NamePool namePool = null;

    public FormatCallout(NamePool namePool, boolean bl, boolean bl2) {
        this.namePool = namePool;
        this.foStylesheet = bl;
        this.xhStylesheet = bl2;
    }

    public String areaLabel(Element element) {
        String string = null;
        if (element.hasAttribute("label")) {
            string = element.getAttribute("label");
        } else {
            Element element2 = (Element)element.getParentNode();
            if (element2 != null && element2.getLocalName().equalsIgnoreCase("areaset") && element2.hasAttribute("label")) {
                string = element2.getAttribute("label");
            }
        }
        return string;
    }

    public String areaID(Element element) {
        String string = null;
        string = element.hasAttribute("id") ? element.getAttribute("id") : (element.hasAttribute("xml:id") ? element.getAttribute("xml:id") : "");
        return string;
    }

    public void startSpan(Emitter emitter, String string) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            if (this.xhStylesheet) {
                this.uri = xhURI;
            }
            int n = this.namePool.allocate("", this.uri, "span");
            AttributeCollection attributeCollection = new AttributeCollection(this.namePool);
            int[] nArray = new int[1];
            attributeCollection.addAttribute("", this.uri, "class", "CDATA", "co");
            attributeCollection.addAttribute("", this.uri, "id", "CDATA", string);
            emitter.startElement(n, (Attributes)attributeCollection, nArray, 0);
        }
    }

    public void endSpan(Emitter emitter) throws TransformerException {
        if (!this.foStylesheet && this.namePool != null) {
            if (this.xhStylesheet) {
                this.uri = xhURI;
            }
            int n = this.namePool.allocate("", this.uri, "span");
            emitter.endElement(n);
        }
    }

    public void formatTextCallout(Emitter emitter, Callout callout) {
        Element element = callout.getArea();
        int n = callout.getCallout();
        String string = this.areaLabel(element);
        String string2 = this.areaID(element);
        String string3 = "(" + n + ")";
        if (string != null) {
            string3 = string;
        }
        char[] cArray = string3.toCharArray();
        try {
            int n2;
            this.startSpan(emitter, string2);
            if (this.foStylesheet) {
                n2 = this.namePool.allocate("fo", foURI, "inline");
                AttributeCollection attributeCollection = new AttributeCollection(this.namePool);
                int[] nArray = new int[1];
                attributeCollection.addAttribute("", "", "id", "CDATA", string2);
                emitter.startElement(n2, (Attributes)attributeCollection, nArray, 0);
            }
            emitter.characters(cArray, 0, string3.length());
            this.endSpan(emitter);
            if (this.foStylesheet) {
                n2 = this.namePool.allocate("fo", foURI, "inline");
                emitter.endElement(n2);
            }
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in formatTextCallout");
        }
    }

    public abstract void formatCallout(Emitter var1, Callout var2);
}

