# -*- sh -*-
# Xsession.d script for ck-launch-session.
#
#
# This file is sourced by Xsession(5), not executed.

CK_LAUNCH_SESSION=/usr/bin/ck-launch-session

is_on_console() {
	session=$(dbus-send --system --dest=org.freedesktop.ConsoleKit \
		--type=method_call --print-reply --reply-timeout=2000 \
		/org/freedesktop/ConsoleKit/Manager \
		org.freedesktop.ConsoleKit.Manager.GetCurrentSession \
		| grep path | awk '{print $3}' | sed s/\"//g)
	x11_display=$(dbus-send --system --dest=org.freedesktop.ConsoleKit \
		--type=method_call --print-reply --reply-timeout=2000 \
		$session org.freedesktop.ConsoleKit.Session.GetX11Display \
		| grep string | awk '{print $2}' | sed s/\"//g)

	if [ -z "$x11_display" ] ; then
		return 0
	else
		return 1
	fi
}

# gdm already creates a CK session for us, so do not run the expensive D-Bus
# calls if we have $GDMSESSION
if [ -z "$GDMSESSION" ] && [ -x "$CK_LAUNCH_SESSION" ] && \
 ( [ -z "$XDG_SESSION_COOKIE" ] || is_on_console ) ; then
    STARTUP="$CK_LAUNCH_SESSION $STARTUP"
fi
