/* $Id: RTPathStripTrailingSlash.cpp 109033 2016-07-22 18:27:37Z bird $ */
/** @file
 * IPRT - RTPathSTripTrailingSlash
 */

/*
 * Copyright (C) 2006-2016 Oracle Corporation
 *
 * This file is part of VirtualBox Open Source Edition (OSE), as
 * available from http://www.virtualbox.org. This file is free software;
 * you can redistribute it and/or modify it under the terms of the GNU
 * General Public License (GPL) as published by the Free Software
 * Foundation, in version 2 as it comes in the "COPYING" file of the
 * VirtualBox OSE distribution. VirtualBox OSE is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY of any kind.
 *
 * The contents of this file may alternatively be used under the terms
 * of the Common Development and Distribution License Version 1.0
 * (CDDL) only, as it comes in the "COPYING.CDDL" file of the
 * VirtualBox OSE distribution, in which case the provisions of the
 * CDDL are applicable instead of those of the GPL.
 *
 * You may elect to license modified versions of this file under the
 * terms and conditions of either the GPL or the CDDL or both.
 */


/*********************************************************************************************************************************
*   Header Files                                                                                                                 *
*********************************************************************************************************************************/
#include "internal/iprt.h"
#include <iprt/path.h>
#include <iprt/string.h>
#include <iprt/ctype.h>



RTDECL(size_t) RTPathStripTrailingSlash(char *pszPath)
{
    size_t off = strlen(pszPath);
    while (off > 1)
    {
        off--;
        switch (pszPath[off])
        {
            case '/':
#if defined(RT_OS_WINDOWS) || defined(RT_OS_OS2)
            case '\\':
                if (    off == 2
                    &&  pszPath[1] == ':'
                    &&  RT_C_IS_ALPHA(pszPath[0]))
                    return off + 1;
#endif
                pszPath[off] = '\0';
                break;

            default:
                return off + 1;
        }
    }

    return 1;
}

