/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.EventDispatchThread;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.SentEvent;
import java.awt.Toolkit;
import java.util.LinkedList;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

class SequencedEvent
extends AWTEvent
implements ActiveEvent {
    private static final long serialVersionUID = 547742659238625067L;
    private static final int ID = 1006;
    private static final LinkedList<SequencedEvent> list = new LinkedList();
    private final AWTEvent nested;
    private AppContext appContext;
    private boolean disposed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequencedEvent(AWTEvent aWTEvent) {
        super(aWTEvent.getSource(), 1006);
        this.nested = aWTEvent;
        SunToolkit.setSystemGenerated(aWTEvent);
        Class<SequencedEvent> clazz = SequencedEvent.class;
        synchronized (SequencedEvent.class) {
            list.add(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void dispatch() {
        try {
            this.appContext = AppContext.getAppContext();
            if (SequencedEvent.getFirst() != this) {
                if (EventQueue.isDispatchThread()) {
                    EventDispatchThread eventDispatchThread = (EventDispatchThread)Thread.currentThread();
                    eventDispatchThread.pumpEvents(1007, new Conditional(){

                        @Override
                        public boolean evaluate() {
                            return !SequencedEvent.this.isFirstOrDisposed();
                        }
                    });
                } else {
                    while (!this.isFirstOrDisposed()) {
                        Class<SequencedEvent> clazz = SequencedEvent.class;
                        // MONITORENTER : java.awt.SequencedEvent.class
                        try {
                            SequencedEvent.class.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // MONITOREXIT : clazz
                            break;
                        }
                    }
                }
            }
            if (this.disposed) return;
            KeyboardFocusManager.getCurrentKeyboardFocusManager().setCurrentSequencedEvent(this);
            Toolkit.getEventQueue().dispatchEvent(this.nested);
            return;
        }
        finally {
            this.dispose();
        }
    }

    private static final boolean isOwnerAppContextDisposed(SequencedEvent sequencedEvent) {
        Object object;
        if (sequencedEvent != null && (object = sequencedEvent.nested.getSource()) instanceof Component) {
            return ((Component)object).appContext.isDisposed();
        }
        return false;
    }

    public final boolean isFirstOrDisposed() {
        if (this.disposed) {
            return true;
        }
        return this == SequencedEvent.getFirstWithContext() || this.disposed;
    }

    private static final synchronized SequencedEvent getFirst() {
        return list.getFirst();
    }

    private static final SequencedEvent getFirstWithContext() {
        SequencedEvent sequencedEvent = SequencedEvent.getFirst();
        while (SequencedEvent.isOwnerAppContextDisposed(sequencedEvent)) {
            sequencedEvent.dispose();
            sequencedEvent = SequencedEvent.getFirst();
        }
        return sequencedEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispose() {
        Object object = SequencedEvent.class;
        synchronized (SequencedEvent.class) {
            if (this.disposed) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getCurrentSequencedEvent() == this) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().setCurrentSequencedEvent(null);
            }
            this.disposed = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (this.appContext != null) {
                SunToolkit.postEvent(this.appContext, new SentEvent());
            }
            object = null;
            Class<SequencedEvent> clazz = SequencedEvent.class;
            synchronized (SequencedEvent.class) {
                SequencedEvent.class.notifyAll();
                if (list.getFirst() == this) {
                    list.removeFirst();
                    if (!list.isEmpty()) {
                        object = list.getFirst();
                    }
                } else {
                    list.remove(this);
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                if (object != null && ((SequencedEvent)object).appContext != null) {
                    SunToolkit.postEvent(((SequencedEvent)object).appContext, new SentEvent());
                }
                return;
            }
        }
    }

    static {
        AWTAccessor.setSequencedEventAccessor(new AWTAccessor.SequencedEventAccessor(){

            @Override
            public AWTEvent getNested(AWTEvent aWTEvent) {
                return ((SequencedEvent)aWTEvent).nested;
            }

            @Override
            public boolean isSequencedEvent(AWTEvent aWTEvent) {
                return aWTEvent instanceof SequencedEvent;
            }
        });
    }
}

