/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import net.sf.saxon.Configuration;
import net.sf.saxon.functions.Nilled;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaComponentVisitor;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.UnresolvedReferenceException;

public class ContentTypeTest
extends NodeTest {
    private int kind;
    private SchemaType schemaType;
    private int requiredType;
    private Configuration config;
    private boolean nillable = false;
    private boolean matchDTDTypes = false;

    public ContentTypeTest(int nodeKind, SchemaType schemaType, Configuration config) {
        this.kind = nodeKind;
        this.schemaType = schemaType;
        this.requiredType = schemaType.getFingerprint();
        if (this.requiredType == -1) {
            this.requiredType = 630;
        }
        this.config = config;
    }

    public void setNillable(boolean nillable) {
        this.nillable = nillable;
    }

    public boolean isNillable() {
        return this.nillable;
    }

    public void setMatchDTDTypes(boolean matched) {
        this.matchDTDTypes = matched;
    }

    public boolean matchesDTDTypes() {
        return this.matchDTDTypes;
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public ItemType getSuperType(TypeHierarchy th) {
        return NodeKindTest.makeNodeKindTest(this.kind);
    }

    public boolean matches(int nodeKind, int fingerprint, int annotation) {
        if (this.kind != nodeKind) {
            return false;
        }
        return this.matchesAnnotation(annotation);
    }

    public boolean matches(TinyTree tree, int nodeNr) {
        if (this.kind != tree.getNodeKind(nodeNr)) {
            return false;
        }
        return this.matchesAnnotation(tree.getTypeAnnotation(nodeNr)) && (this.nillable || !tree.isNilled(nodeNr));
    }

    public boolean matches(NodeInfo node) {
        return node.getNodeKind() == this.kind && this.matchesAnnotation(node.getTypeAnnotation()) && (this.nillable || !Nilled.isNilled(node));
    }

    private boolean matchesAnnotation(int annotation) {
        if (this.requiredType == 572) {
            return true;
        }
        if (annotation == -1) {
            int n = annotation = this.kind == 2 ? 631 : 630;
        }
        if (this.matchDTDTypes) {
            annotation &= 0xFFFFF;
        } else if ((annotation & 0x40000000) != 0) {
            return this.requiredType == 631;
        }
        if (annotation == this.requiredType) {
            return true;
        }
        try {
            SchemaType type = this.config.getSchemaType(annotation & 0xFFFFF).getBaseType();
            if (type == null) {
                return false;
            }
            ContentTypeTest actual = new ContentTypeTest(this.kind, type, this.config);
            return this.config.getTypeHierarchy().isSubType(actual, this);
        }
        catch (UnresolvedReferenceException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public final double getDefaultPriority() {
        return 0.0;
    }

    public int getPrimitiveType() {
        return this.kind;
    }

    public int getNodeKindMask() {
        return 1 << this.kind;
    }

    public SchemaType getContentType() {
        return this.schemaType;
    }

    public AtomicType getAtomizedItemType() {
        SchemaType type = this.config.getSchemaType(this.requiredType);
        if (type.isAtomicType()) {
            return (AtomicType)type;
        }
        if (type instanceof ListType) {
            SimpleType mem = ((ListType)type).getItemType();
            if (mem.isAtomicType()) {
                return (AtomicType)mem;
            }
        } else if (type instanceof ComplexType && ((ComplexType)type).isSimpleContent()) {
            SimpleType mem;
            SimpleType ctype = ((ComplexType)type).getSimpleContentType();
            if (ctype.isAtomicType()) {
                return (AtomicType)ctype;
            }
            if (ctype instanceof ListType && (mem = ((ListType)ctype).getItemType()).isAtomicType()) {
                return (AtomicType)mem;
            }
        }
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public boolean isAtomizable() {
        return !this.schemaType.isComplexType() || ((ComplexType)this.schemaType).getVariety() != 2;
    }

    public void visitNamedSchemaComponents(SchemaComponentVisitor visitor) throws XPathException {
        visitor.visitSchemaComponent(this.schemaType);
    }

    public String toString() {
        return (this.kind == 1 ? "element(*, " : "attribute(*, ") + this.schemaType.getDescription() + ')';
    }

    public int hashCode() {
        return this.kind << 20 ^ this.requiredType;
    }

    public boolean equals(Object other) {
        return other instanceof ContentTypeTest && ((ContentTypeTest)other).kind == this.kind && ((ContentTypeTest)other).schemaType == this.schemaType && ((ContentTypeTest)other).requiredType == this.requiredType && ((ContentTypeTest)other).nillable == this.nillable && ((ContentTypeTest)other).matchDTDTypes == this.matchDTDTypes;
    }
}

