/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.utils.PortingUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultFocusManager;
import javax.swing.JLayeredPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PopupWindow {
    protected EventListenerList listenerList = new EventListenerList();
    private JWindow k;
    private Container d;
    private List i = new Vector();
    private List g = new Vector();
    private WindowListener e;
    private ComponentListener j;
    private ContainerListener f;
    private MouseListener c;
    private Component h;
    private KeyEventDispatcher l;
    private Component b;

    public PopupWindow(Container container) {
        this.d = container;
        this.c();
        this.b();
    }

    private void c() {
        Window window = this.g();
        if (window != null) {
            this.k = new JWindow(window);
        }
    }

    public void add(Component component) {
        this.h = component;
        this.h.addPropertyChangeListener("preferredSize", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (PopupWindow.this.k != null) {
                    PopupWindow.this.k.pack();
                }
            }
        });
        if (this.k != null) {
            this.k.getContentPane().add(component);
            this.k.pack();
            this.k.pack();
        }
    }

    public void show(Component component, int n2, int n3) {
        this.b = component;
        if (this.k == null) {
            this.c();
            if (this.k == null) {
                return;
            }
            this.add(this.h);
        }
        Point point = new Point(n2, n3);
        SwingUtilities.convertPointToScreen(point, component);
        Rectangle rectangle = PortingUtils.getScreenBounds(component);
        Dimension dimension = this.h.getPreferredSize();
        int n4 = point.x + dimension.width;
        int n5 = point.y + dimension.height;
        if (point.x < rectangle.x) {
            point.x = rectangle.x;
        }
        if (n4 > rectangle.width) {
            point.x = rectangle.width - dimension.width;
        }
        if (point.y < rectangle.y) {
            point.y = rectangle.y;
        }
        if (n5 > rectangle.height) {
            point.y = rectangle.height - dimension.height;
        }
        this.k.setLocation(point.x, point.y);
        this.k.setSize(this.h.getPreferredSize());
        this.firePopupMenuWillBecomeVisible();
        this.k.setVisible(true);
        this.h();
        this.l = new KeyEventDispatcher(){

            public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    PopupWindow.this.hide();
                    return true;
                }
                return false;
            }
        };
        DefaultFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.l);
    }

    public void hide() {
        if (this.b != null) {
            this.b.requestFocus();
        }
        this.firePopupMenuWillBecomeInvisible();
        if (this.k != null) {
            this.k.setVisible(false);
        }
        if (this.l != null) {
            DefaultFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.l);
            this.l = null;
        }
        this.e();
        this.i();
    }

    private void b() {
        this.e = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }

            public void windowClosed(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }

            public void windowIconified(WindowEvent windowEvent) {
                PopupWindow.this.hide();
            }
        };
        this.j = new ComponentListener(){

            public void componentResized(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            public void componentMoved(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            public void componentShown(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }

            public void componentHidden(ComponentEvent componentEvent) {
                PopupWindow.this.hide();
            }
        };
        this.f = new ContainerListener(){

            public void componentAdded(ContainerEvent containerEvent) {
                PopupWindow.this.hide();
            }

            public void componentRemoved(ContainerEvent containerEvent) {
                PopupWindow.this.hide();
            }
        };
        this.c = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PopupWindow.this.hide();
            }
        };
    }

    private void i() {
        if (this.k != null) {
            this.k.dispose();
            this.k = null;
        }
    }

    private Window g() {
        Container container = this.d;
        if (container == null) {
            return null;
        }
        while (!(container instanceof Window) && container.getParent() != null) {
            container = container.getParent();
        }
        if (container instanceof Window) {
            return (Window)container;
        }
        return null;
    }

    private void h() {
        Container container = this.d;
        while (!(container instanceof Window) && container.getParent() != null) {
            container = container.getParent();
        }
        this.d(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d(Container container) {
        if (container instanceof Window) {
            ((Window)container).addWindowListener(this.e);
            container.addComponentListener(this.j);
            this.i.add(container);
        }
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2 = container.getComponentCount();
            Component[] componentArray = container.getComponents();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = componentArray[i2];
                if (!component.isVisible() || this.isExcludedComponent(component)) continue;
                component.addMouseListener(this.c);
                this.i.add(component);
                if (!(component instanceof Container)) continue;
                Container container2 = (Container)component;
                if (container2 instanceof JLayeredPane) {
                    container2.addContainerListener(this.f);
                }
                this.d(container2);
            }
        }
    }

    void e() {
        for (Object e2 : this.i) {
            Component component = (Component)e2;
            if (component instanceof Window) {
                ((Window)component).removeWindowListener(this.e);
                component.removeComponentListener(this.j);
            } else {
                component.removeMouseListener(this.c);
            }
            if (!(component instanceof Container) || !(component instanceof JLayeredPane)) continue;
            ((Container)component).removeContainerListener(this.f);
        }
        this.i.clear();
    }

    public boolean isVisible() {
        return this.k != null ? this.k.isVisible() : false;
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(PopupMenuListener.class, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(PopupMenuListener.class, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(PopupMenuListener.class);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
        }
    }

    public void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        for (int i2 = objectArray.length - 2; i2 >= 0; i2 -= 2) {
            if (objectArray[i2] != PopupMenuListener.class) continue;
            if (popupMenuEvent == null) {
                popupMenuEvent = new PopupMenuEvent(this);
            }
            ((PopupMenuListener)objectArray[i2 + 1]).popupMenuCanceled(popupMenuEvent);
        }
    }

    public void addAsExcludedComponents(Component component) {
        if (this.g.contains(component)) {
            return;
        }
        this.g.add(component);
    }

    public void removeFromExcludedComponents(Component component) {
        if (!this.g.contains(component)) {
            return;
        }
        this.g.remove(component);
    }

    public boolean isExcludedComponent(Component component) {
        return this.g.contains(component);
    }
}

