/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.plaf.UIDefaultsLookup;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.ImageIcon;

public class JideCursors {
    public static final int FIRST_CUSTOM_CURSOR = 20;
    public static final int HSPLIT_CURSOR = 20;
    public static final int VSPLIT_CURSOR = 21;
    public static final int DRAG_CURSOR = 22;
    public static final int DRAG_STOP_CURSOR = 23;
    public static final int NORTH_CURSOR = 24;
    public static final int SOUTH_CURSOR = 25;
    public static final int EAST_CURSOR = 26;
    public static final int WEST_CURSOR = 27;
    public static final int TAB_CURSOR = 28;
    public static final int FLOAT_CURSOR = 29;
    public static final int VERTICAL_CURSOR = 30;
    public static final int HORIZONTAL_CURSOR = 31;
    public static final int DELETE_CURSOR = 32;
    public static final int DRAG_TEXT_CURSOR = 33;
    public static final int DRAG_TEXT_STOP_CURSOR = 34;
    public static final int PERCENTAGE_CURSOR = 35;
    public static final int MOVE_EAST_CURSOR = 36;
    public static final int MOVE_WEST_CURSOR = 37;
    public static final int LAST_CUSTOM_CURSOR = 38;
    private static final Cursor[] b = new Cursor[19];

    public static Cursor getPredefinedCursor(int n2) {
        if (n2 < 20 || n2 > 38) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        if (b[n2 - 20] == null) {
            JideCursors.b[n2 - 20] = JideCursors.createCursor(n2);
        }
        return b[n2 - 20];
    }

    public static void setPredefinedCursor(int n2, Cursor cursor) {
        if (n2 < 20 || n2 > 38) {
            throw new IllegalArgumentException("illegal cursor type");
        }
        JideCursors.b[n2 - 20] = cursor == null ? JideCursors.createCursor(n2) : cursor;
    }

    protected static Cursor createCursor(int n2) {
        try {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getBestCursorSize(32, 32);
            int n3 = toolkit.getMaximumCursorColors();
            switch (n2) {
                case 20: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.hsplit");
                        if (imageIcon == null) {
                            return Cursor.getPredefinedCursor(11);
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Horizonal Split");
                    }
                    return Cursor.getPredefinedCursor(11);
                }
                case 21: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.vsplit");
                        if (imageIcon == null) {
                            return Cursor.getPredefinedCursor(9);
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Vertical Split");
                    }
                    return Cursor.getPredefinedCursor(9);
                }
                case 22: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.drag");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(17, 12), "Drag");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 23: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragStop");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(17, 12), "Drag Stop");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 33: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragText");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(0, 0), "Drag Text");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 34: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.dragTextStop");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Drag Text Stop");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 24: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.north");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 10), "North");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 25: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.south");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 20), "South");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 26: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.east");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(20, 15), "East");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 27: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.west");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(10, 15), "West");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 28: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.tab");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Tabbed");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 29: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.float");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Floating");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 30: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.vertical");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Vertical");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 31: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.horizontal");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), "Horizontal");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 32: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.delete");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(10, 10), "Delete");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 35: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.percentage");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(20, 15), "Percentage");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 36: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.moveEast");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(11, 15), "Move East");
                    }
                    return Cursor.getDefaultCursor();
                }
                case 37: {
                    if (dimension.width != 0 && n3 > 3) {
                        ImageIcon imageIcon = (ImageIcon)UIDefaultsLookup.getIcon("Cursor.moveWest");
                        if (imageIcon == null) {
                            return Cursor.getDefaultCursor();
                        }
                        return toolkit.createCustomCursor(imageIcon.getImage(), new Point(20, 15), "Move West");
                    }
                    return Cursor.getDefaultCursor();
                }
            }
            return null;
        }
        catch (Exception exception) {
            return Cursor.getDefaultCursor();
        }
    }

    static {
        for (int i2 = 20; i2 < 38; ++i2) {
            JideCursors.getPredefinedCursor(i2);
        }
    }
}

