/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.PortingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class Calculator
extends JPanel
implements ActionListener {
    private double t;
    private StringBuffer d = new StringBuffer();
    private StringBuffer c = new StringBuffer();
    private int j = -1;
    private String b;
    private boolean h = false;
    private boolean w = true;
    private boolean m = false;
    private boolean k = false;
    private boolean cb = false;
    private boolean bb = false;
    private boolean e = false;
    public static final int OPERATOR_NONE = -1;
    public static final int OPERATOR_ADD = 0;
    public static final int OPERATOR_MINUS = 1;
    public static final int OPERATOR_MULTIPLY = 2;
    public static final int OPERATOR_DIVIDE = 3;
    private AbstractButton db;
    private AbstractButton z;
    private AbstractButton s;
    private AbstractButton n;
    private AbstractButton u;
    private AbstractButton i;
    private AbstractButton v;
    private AbstractButton r;
    private AbstractButton g;
    private AbstractButton[] ab;
    private char f;
    private NumberFormat l = NumberFormat.getNumberInstance();
    public static final char CHAR_CLEAR = 'c';
    public static final char CHAR_POINT = '.';
    public static final char CHAR_ADD = '+';
    public static final char CHAR_MINUS = '-';
    public static final char CHAR_MULTIPLY = '*';
    public static final char CHAR_DIVIDE = '/';
    public static final char CHAR_EQUAL = '=';
    public static final char CHAR_NEGATIVE = '!';
    public static final char CHAR_BACKSPACE = '<';
    public static final char CHAR_0 = '0';
    public static final char CHAR_1 = '1';
    public static final char CHAR_2 = '2';
    public static final char CHAR_3 = '3';
    public static final char CHAR_4 = '4';
    public static final char CHAR_5 = '5';
    public static final char CHAR_6 = '6';
    public static final char CHAR_7 = '7';
    public static final char CHAR_8 = '8';
    public static final char CHAR_9 = '9';
    public static final String PROPERTY_DISPLAY_TEXT = "displayText";
    public static final String PROPERTY_OPERATOR = "operator";
    private int q = 24;
    private int o = 24;
    private int p = 2;

    public Calculator() {
        this.configureNumberFormat();
        this.initComponents();
        this.registerKeyboardActions(this, 1);
    }

    public void setLocale(Locale locale) {
        this.unregisterKeyboardActions(this);
        super.setLocale(locale);
        this.d = new StringBuffer();
        this.c = new StringBuffer();
        this.l = NumberFormat.getNumberInstance(this.getLocale());
        this.configureNumberFormat();
        this.f = this.getDisplayFormat().format(2.01).charAt(1);
        this.u.setText("" + this.f);
        this.registerKeyboardActions(this, 1);
    }

    protected void configureNumberFormat() {
        this.l.setMaximumFractionDigits(20);
        this.l.setMinimumFractionDigits(0);
        this.l.setGroupingUsed(false);
    }

    public static boolean isValidKeyEvent(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return (keyEvent.getModifiers() & 0xFFFFFFFE) != 0 || Character.isDigit(c2) || Calculator.isOperator(keyEvent) || Calculator.isEnterOrEqual(keyEvent) || c2 == '.' || c2 == ',' || c2 == 'c' || Character.toLowerCase(c2) == 'c' || c2 == '\u001b' || c2 == '\b';
    }

    public static boolean isOperator(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return c2 == '+' || c2 == '-' || c2 == '*' || c2 == '/';
    }

    public static boolean isEnterOrEqual(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        return c2 == '\n' || c2 == '=';
    }

    public void registerKeyboardActions(JComponent jComponent, int n2) {
        boolean bl = this.isCellEditor();
        jComponent.registerKeyboardAction(this, "+", KeyStroke.getKeyStroke('+'), n2);
        jComponent.registerKeyboardAction(this, "-", KeyStroke.getKeyStroke('-'), n2);
        jComponent.registerKeyboardAction(this, "*", KeyStroke.getKeyStroke('*'), n2);
        jComponent.registerKeyboardAction(this, "/", KeyStroke.getKeyStroke('/'), n2);
        jComponent.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke('='), n2);
        if (!bl) {
            jComponent.registerKeyboardAction(this, "=", KeyStroke.getKeyStroke(10, 0), n2);
        }
        jComponent.registerKeyboardAction(this, "0", KeyStroke.getKeyStroke('0'), n2);
        jComponent.registerKeyboardAction(this, "1", KeyStroke.getKeyStroke('1'), n2);
        jComponent.registerKeyboardAction(this, "2", KeyStroke.getKeyStroke('2'), n2);
        jComponent.registerKeyboardAction(this, "3", KeyStroke.getKeyStroke('3'), n2);
        jComponent.registerKeyboardAction(this, "4", KeyStroke.getKeyStroke('4'), n2);
        jComponent.registerKeyboardAction(this, "5", KeyStroke.getKeyStroke('5'), n2);
        jComponent.registerKeyboardAction(this, "6", KeyStroke.getKeyStroke('6'), n2);
        jComponent.registerKeyboardAction(this, "7", KeyStroke.getKeyStroke('7'), n2);
        jComponent.registerKeyboardAction(this, "8", KeyStroke.getKeyStroke('8'), n2);
        jComponent.registerKeyboardAction(this, "9", KeyStroke.getKeyStroke('9'), n2);
        jComponent.registerKeyboardAction(this, "" + this.f, KeyStroke.getKeyStroke(this.f), n2);
        jComponent.registerKeyboardAction(this, "<", KeyStroke.getKeyStroke(8, 0), n2);
        if (!bl) {
            jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), n2);
        }
        if (!bl) {
            jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(27, 0), 1);
        }
        jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toUpperCase('c')), n2);
        jComponent.registerKeyboardAction(this, "c", KeyStroke.getKeyStroke(Character.toLowerCase('c')), n2);
    }

    public void unregisterKeyboardActions(JComponent jComponent) {
        boolean bl = this.isCellEditor();
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('+'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('-'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('*'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('/'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('='));
        if (!bl) {
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
        }
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('0'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('1'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('2'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('3'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('4'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('5'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('6'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('7'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('8'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke('9'));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(this.f));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(8, 0));
        if (!bl) {
            jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
        }
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toUpperCase('c')));
        jComponent.unregisterKeyboardAction(KeyStroke.getKeyStroke(Character.toLowerCase('c')));
    }

    protected void initComponents() {
        this.setLayout(new _c());
        this.db = this.createButton("+");
        this.add(this.db);
        this.z = this.createButton("-");
        this.add(this.z);
        this.s = this.createButton("*");
        this.add(this.s);
        this.n = this.createButton("/");
        this.add(this.n);
        this.ab = new AbstractButton[10];
        for (int i2 = 0; i2 <= 9; ++i2) {
            this.ab[i2] = this.createButton("" + i2);
            this.add(this.ab[i2]);
        }
        this.f = this.getDisplayFormat().format(2.01).charAt(1);
        this.u = this.createButton("" + this.f);
        this.add(this.u);
        this.i = this.createButton("=");
        this.add(this.i);
        this.v = this.createButton(null, new _d());
        this.add(this.v);
        this.g = this.createButton(null, new _b());
        this.add(this.g);
        this.r = this.createButton("C");
        this.add(this.r);
    }

    public boolean isResultCalculated() {
        return this.e;
    }

    public void setResultCalculated(boolean bl) {
        this.e = bl;
    }

    protected AbstractButton createButton(String string) {
        return this.createButton(string, null);
    }

    protected AbstractButton createButton(String string, Icon icon) {
        JideButton jideButton = new JideButton(string, icon);
        jideButton.setOpaque(true);
        jideButton.setContentAreaFilled(true);
        jideButton.setRequestFocusEnabled(false);
        jideButton.setFocusable(false);
        jideButton.addActionListener(this);
        return jideButton;
    }

    public boolean isOverflow() {
        return this.h;
    }

    public void setOverflow(boolean bl) {
        this.h = bl;
    }

    public void input(char c2) {
        if ('c' == Character.toLowerCase(c2) || 'c' == Character.toUpperCase(c2)) {
            this.clear();
            return;
        }
        if (this.h) {
            this.beep();
            return;
        }
        if (Character.isDigit(c2) || this.f == c2) {
            if (this.cb) {
                this.setOperator(-1);
                this.d.setLength(0);
                this.cb = false;
            }
            if (this.getOperator() == -1) {
                if (this.f != c2 || this.d.indexOf("" + this.f) == -1) {
                    this.d.append(c2);
                    this.m = true;
                    this.k = false;
                    this.setDisplayText(this.d.toString());
                } else {
                    this.beep();
                }
            } else if (this.f != c2 || this.c.indexOf("" + this.f) == -1) {
                this.c.append(c2);
                this.k = true;
                this.m = false;
                this.setDisplayText(this.c.toString());
            } else {
                this.beep();
            }
        } else {
            switch (c2) {
                case '+': {
                    this.m(0);
                    break;
                }
                case '-': {
                    this.m(1);
                    break;
                }
                case '*': {
                    this.m(2);
                    break;
                }
                case '/': {
                    this.m(3);
                    break;
                }
                case '=': {
                    this.p(true);
                    this.cb = true;
                    break;
                }
                case '!': {
                    if (this.w) {
                        this.o(this.d);
                        this.setDisplayText(this.d.toString());
                        break;
                    }
                    this.o(this.c);
                    this.setDisplayText(this.c.toString());
                    break;
                }
                case '<': {
                    if (this.m) {
                        this.c(this.d);
                        this.setDisplayText(this.d.toString());
                        break;
                    }
                    if (this.k) {
                        this.c(this.c);
                        this.setDisplayText(this.c.toString());
                        break;
                    }
                    this.beep();
                }
            }
        }
    }

    private void m(int n2) {
        if (this.d.length() == 0) {
            this.d.append("0");
        } else if (this.getOperator() == -1 || this.cb) {
            this.c.setLength(0);
            this.p(false);
        } else {
            if (this.c.length() == 0) {
                this.beep();
                return;
            }
            this.bb = false;
            this.p(true);
            this.d.setLength(0);
            this.d.append(this.getDisplayFormat().format((Object)this.t));
            this.c.setLength(0);
        }
        this.setOperator(n2);
        this.w = false;
        this.cb = false;
    }

    protected void beep() {
        PortingUtils.notifyUser();
    }

    private void o(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        if (stringBuffer.charAt(0) == '-') {
            stringBuffer.deleteCharAt(0);
        } else {
            stringBuffer.insert(0, '-');
        }
    }

    private void c(StringBuffer stringBuffer) {
        if (stringBuffer.length() == 0) {
            return;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
    }

    public void updateResult() {
        this.bb = false;
        this.p(true);
    }

    private void p(boolean bl) {
        Double d2;
        Double d3;
        if (this.getOperator() == -1) {
            return;
        }
        if (this.d.length() == 0) {
            this.beep();
            return;
        }
        if (bl) {
            if (this.c.length() == 0) {
                this.c.append(this.d);
            }
        } else if (this.c.length() == 0) {
            return;
        }
        try {
            d3 = this.getDisplayFormat().parse(this.d.toString()).doubleValue();
            d2 = this.getDisplayFormat().parse(this.c.toString()).doubleValue();
        }
        catch (ParseException parseException) {
            d3 = 0.0;
            d2 = 0.0;
        }
        if (!this.bb) {
            try {
                switch (this.getOperator()) {
                    case 0: {
                        this.t = d3 + d2;
                        break;
                    }
                    case 1: {
                        this.t = d3 - d2;
                        break;
                    }
                    case 2: {
                        this.t = d3 * d2;
                        break;
                    }
                    case 3: {
                        if (d2 == 0.0) {
                            this.t = Double.NaN;
                            this.h = true;
                            break;
                        }
                        this.t = d3 / d2;
                    }
                }
            }
            catch (Exception exception) {
                this.h = true;
            }
        }
        if (this.h) {
            this.setDisplayText("E");
        } else {
            this.setResultCalculated(true);
            this.d.setLength(0);
            if (this.l != null) {
                String string = this.l.format(this.t);
                this.setDisplayText(string);
            } else {
                this.setDisplayText("" + this.t);
            }
            this.d.append(this.getDisplayText());
            this.w = true;
            this.m = true;
            this.k = false;
        }
    }

    private void q() {
        this.setOperator(-1);
        this.d.setLength(0);
        this.c.setLength(0);
    }

    public void clear() {
        this.q();
        this.h = false;
        this.cb = false;
        this.setDisplayText("0");
    }

    public double getResult() {
        return this.t;
    }

    public String getDisplayText() {
        return this.b;
    }

    public void setDisplayText(String string) {
        String string2 = this.b;
        this.b = string;
        this.firePropertyChange(PROPERTY_DISPLAY_TEXT, string2, this.b);
    }

    public int getOperator() {
        return this.j;
    }

    public void setOperator(int n2) {
        int n3 = this.j;
        if (n3 != n2) {
            this.j = n2;
            this.firePropertyChange(PROPERTY_OPERATOR, new Integer(n3), new Integer(n2));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.db == object) {
            this.input('+');
        } else if (this.z == object) {
            this.input('-');
        } else if (this.s == object) {
            this.input('*');
        } else if (this.n == object) {
            this.input('/');
        } else if (this.i == object) {
            this.bb = actionEvent.getActionCommand() != null && actionEvent.getActionCommand().equals("Faked");
            this.input('=');
        } else if (this.u == object) {
            this.input(this.f);
        } else if (this.g == object) {
            this.input('!');
        } else if (this.v == object) {
            this.input('<');
        } else if (this.r == object) {
            this.input('c');
        } else {
            boolean bl = false;
            for (int i2 = 0; i2 <= 9; ++i2) {
                if (this.ab[i2] != object) continue;
                this.input(("" + i2).charAt(0));
                bl = true;
                break;
            }
            if (!bl) {
                if (actionEvent.getActionCommand() != null && actionEvent.getActionCommand().length() > 0) {
                    this.f(actionEvent.getActionCommand().charAt(0));
                } else {
                    this.f('=');
                }
            }
        }
    }

    protected void fakePressButton(AbstractButton abstractButton) {
        this.actionPerformed(new ActionEvent(abstractButton, 0, null));
    }

    private void f(char c2) {
        if (c2 == this.f) {
            this.fakePressButton(this.u);
            return;
        }
        switch (c2) {
            case 'c': {
                this.fakePressButton(this.r);
                break;
            }
            case '<': {
                this.fakePressButton(this.v);
                break;
            }
            case '=': {
                this.fakePressButton(this.i);
                break;
            }
            case '!': {
                this.fakePressButton(this.g);
                break;
            }
            case '+': {
                this.fakePressButton(this.db);
                break;
            }
            case '-': {
                this.fakePressButton(this.z);
                break;
            }
            case '*': {
                this.fakePressButton(this.s);
                break;
            }
            case '/': {
                this.fakePressButton(this.n);
                break;
            }
            case '0': {
                this.fakePressButton(this.ab[0]);
                break;
            }
            case '1': {
                this.fakePressButton(this.ab[1]);
                break;
            }
            case '2': {
                this.fakePressButton(this.ab[2]);
                break;
            }
            case '3': {
                this.fakePressButton(this.ab[3]);
                break;
            }
            case '4': {
                this.fakePressButton(this.ab[4]);
                break;
            }
            case '5': {
                this.fakePressButton(this.ab[5]);
                break;
            }
            case '6': {
                this.fakePressButton(this.ab[6]);
                break;
            }
            case '7': {
                this.fakePressButton(this.ab[7]);
                break;
            }
            case '8': {
                this.fakePressButton(this.ab[8]);
                break;
            }
            case '9': {
                this.fakePressButton(this.ab[9]);
            }
        }
    }

    public NumberFormat getDisplayFormat() {
        return this.l;
    }

    public void setDisplayFormat(NumberFormat numberFormat) {
        this.l = numberFormat;
    }

    public void commit() {
        if (!this.cb) {
            this.actionPerformed(new ActionEvent(this.i, 0, "Faked"));
        }
    }

    public int getButtonWidth() {
        return this.q;
    }

    public void setButtonWidth(int n2) {
        this.q = n2;
    }

    public int getButtonHeight() {
        return this.o;
    }

    public void setButtonHeight(int n2) {
        this.o = n2;
    }

    public int getButtonGap() {
        return this.p;
    }

    public void setButtonGap(int n2) {
        this.p = n2;
    }

    protected boolean isCellEditor() {
        return false;
    }

    public void setInitialValue(String string) {
        this.d.setLength(0);
        this.d.append(string);
        this.m = true;
        this.k = false;
        this.setDisplayText(this.d.toString());
    }

    public static void main(String[] stringArray) {
        Calculator calculator = new Calculator();
        calculator.input('1');
        calculator.input('0');
        calculator.input('*');
        calculator.input('2');
        calculator.input('4');
        calculator.input('=');
    }

    private class _c
    implements LayoutManager {
        public void addLayoutComponent(String string, Component component) {
        }

        public void removeLayoutComponent(Component component) {
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public Dimension minimumLayoutSize(Container container) {
            return new Dimension(Calculator.this.getButtonWidth() * 4 + Calculator.this.getButtonGap() * 3, Calculator.this.getButtonHeight() * 5 + Calculator.this.getButtonGap() * 4);
        }

        public void layoutContainer(Container container) {
            int n2 = 0;
            int n3 = 0;
            int n4 = Calculator.this.getButtonWidth();
            int n5 = Calculator.this.getButtonHeight();
            int n6 = Calculator.this.getButtonGap();
            Calculator.this.ab[7].setBounds(n2, n3, n4, n5);
            Calculator.this.ab[8].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.ab[9].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.n.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.ab[4].setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.ab[5].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.ab[6].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.s.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.ab[1].setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.ab[2].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.ab[3].setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.z.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.ab[0].setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.u.setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.g.setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.db.setBounds(n2 += n4 + n6, n3, n4, n5);
            n2 = 0;
            Calculator.this.r.setBounds(n2, n3 += n5 + n6, n4, n5);
            Calculator.this.v.setBounds(n2 += n4 + n6, n3, n4, n5);
            Calculator.this.i.setBounds(n2 += n4 + n6, n3, n4 * 2 + n6, n5);
        }
    }

    class _b
    implements Icon {
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Color color = graphics.getColor();
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            graphics.setColor(component.getForeground());
            graphics.drawLine(n2, n3 + 2, n2 + 6, n3 + 2);
            graphics.drawLine(n2, n3 + 7, n2 + 6, n3 + 7);
            graphics.drawLine(n2 + 3, n3, n2 + 3, n3 + 5);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }

    class _d
    implements Icon {
        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            Object object = JideSwingUtilities.setupShapeAntialiasing(graphics);
            Color color = graphics.getColor();
            graphics.setColor(component.getForeground());
            graphics.drawLine(n2, n3 + 3, n2 + 3, n3);
            graphics.drawLine(n2, n3 + 3, n2 + 3, n3 + 6);
            graphics.drawLine(n2 + 3, n3 + 3, n2 + 7, n3 + 3);
            graphics.setColor(color);
            JideSwingUtilities.restoreShapeAntialiasing(graphics, object);
        }

        public int getIconWidth() {
            return 7;
        }

        public int getIconHeight() {
            return 7;
        }
    }
}

