/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractNumericRange;
import com.jidesoft.range.NumericRange;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedNumericRange
extends AbstractNumericRange<Double> {
    private final Object q = new Object();
    private List<Range<Double>> t = new ArrayList<Range<Double>>();
    private Double r = null;
    private Double s = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CombinedNumericRange add(Range<Double> range) {
        if (range == null) {
            return this;
        }
        Object object = this.q;
        synchronized (object) {
            this.t.add(range);
            this.s = null;
            this.r = null;
        }
        return this;
    }

    @Override
    public Double lower() {
        return this.minimum();
    }

    @Override
    public Double upper() {
        return this.maximum();
    }

    public int rangeCount() {
        return this.t == null ? 0 : this.t.size();
    }

    @Override
    public void adjust(Double d2, Double d3) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double maximum() {
        Object object = this.q;
        synchronized (object) {
            if (this.r != null) {
                return this.r;
            }
            if (this.t == null || this.t.size() == 0) {
                return Double.MAX_VALUE;
            }
            this.r = -1.7976931348623157E308;
            for (Range<Double> range : this.t) {
                if (range == null || !(range.maximum() > this.r)) continue;
                this.r = range.maximum();
            }
            return this.r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double minimum() {
        Object object = this.q;
        synchronized (object) {
            if (this.s != null) {
                return this.s;
            }
            if (this.t == null || this.t.size() == 0) {
                return -1.7976931348623157E308;
            }
            this.s = Double.MAX_VALUE;
            for (Range<Double> range : this.t) {
                if (range == null || !(range.minimum() < this.s)) continue;
                this.s = range.minimum();
            }
            return this.s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Double d2) {
        Object object = this.q;
        synchronized (object) {
            if (d2 == null || this.t.size() == 0) {
                return false;
            }
            for (Range<Double> range : this.t) {
                if (!range.contains(d2)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double size() {
        Object object = this.q;
        synchronized (object) {
            return this.maximum() - this.minimum();
        }
    }

    public NumericRange getRange(double d2, double d3) {
        double d4 = this.maximum();
        double d5 = this.minimum();
        double d6 = Math.abs(d4 - d5);
        double d7 = d2 * d6;
        double d8 = d3 * d6;
        return new NumericRange(d5 - d7, d4 + d8);
    }

    public String toString() {
        return String.format("#<CombinedNumericRange min=%s max=%s>", this.minimum(), this.maximum());
    }
}

