/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.range;

import com.jidesoft.range.AbstractRange;
import com.jidesoft.range.Category;
import com.jidesoft.range.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategoryRange<T>
extends AbstractRange<T>
implements Iterable<Category<T>> {
    public static final String PROPERTY_VALUES = "values";
    public static final String PROPERTY_COMPARATOR = "comparator";
    public static final String PROPERTY_SORTED = "sorted";
    private List<T> k = null;
    private List<Category<T>> i = null;
    private Double m;
    private Double j;
    private Comparator<T> h = null;
    private boolean l = false;
    private boolean n = false;

    public CategoryRange() {
        this.k = new ArrayList<T>();
        this.i = new ArrayList<Category<T>>();
        this.n = false;
    }

    public CategoryRange(T ... TArray) {
        this.k = new ArrayList<T>();
        this.k.addAll(Arrays.asList(TArray));
        this.n = false;
    }

    public CategoryRange(Set<T> set) {
        this.k = new ArrayList<T>(set);
        this.n = false;
    }

    public CategoryRange(CategoryRange<T> categoryRange) {
        this.i = new ArrayList<Category<T>>(categoryRange.getCategoryValues());
        this.k = new ArrayList<T>(categoryRange.getPossibleValues());
        this.h = categoryRange.getComparator();
        this.setMinimum(categoryRange.minimum());
        this.setMaximum(categoryRange.maximum());
        this.n = false;
    }

    public List<T> getPossibleValues() {
        if (this.l && !this.n) {
            if (this.h == null) {
                Comparator comparator = new Comparator<T>(){

                    @Override
                    public int compare(T t, T t2) {
                        if (t == null && t2 == null) {
                            return 0;
                        }
                        if (t == null) {
                            return -1;
                        }
                        if (t2 == null) {
                            return 1;
                        }
                        if (t instanceof Comparable) {
                            Comparable comparable = (Comparable)t;
                            return comparable.compareTo(t2);
                        }
                        String string = t.toString();
                        String string2 = t2.toString();
                        return string.compareTo(string2);
                    }
                };
                Collections.sort(this.k, comparator);
            } else {
                Collections.sort(this.k, this.h);
            }
        }
        return this.k;
    }

    public Category<T> getCategory(int n2) {
        if (n2 < 1) {
            throw new IllegalArgumentException("Supplied category index was " + n2 + " but it should be >= 1");
        }
        return this.getCategoryValues().get(n2 - 1);
    }

    public CategoryRange<T> add(Category<T> category) {
        if (!this.contains(category)) {
            if (this.h == null) {
                this.k.add(category.getValue());
                this.i.add(category);
            } else {
                this.k.add(category.getValue());
                this.n = false;
                this.i = null;
            }
            category.setRange(this);
            this.firePropertyChange(PROPERTY_VALUES, null, this.k);
        }
        return this;
    }

    public void setSorted(boolean bl) {
        boolean bl2 = this.l;
        this.l = bl;
        if (bl) {
            this.i = null;
        }
        this.firePropertyChange(PROPERTY_SORTED, bl2, bl);
    }

    public boolean isSorted() {
        return this.l;
    }

    public Comparator<T> getComparator() {
        return this.h;
    }

    public void setComparator(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.h;
        this.h = comparator;
        this.setSorted(comparator != null);
        this.firePropertyChange(PROPERTY_COMPARATOR, comparator2, comparator);
    }

    @Override
    public Range<T> copy() {
        return new CategoryRange<T>(this);
    }

    @Override
    public T lower() {
        if (this.k == null || this.k.size() == 0) {
            return null;
        }
        return this.k.get(0);
    }

    @Override
    public T upper() {
        if (this.k == null || this.k.size() == 0) {
            return null;
        }
        int n2 = this.k.size();
        return this.k.get(n2 - 1);
    }

    @Override
    public void adjust(T t, T t2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double maximum() {
        if (this.j == null) {
            T t = this.upper();
            if (t == null) {
                return 1.0;
            }
            this.j = (double)this.position(t) + 1.0;
        }
        return this.j;
    }

    @Override
    public double minimum() {
        if (this.m == null) {
            T t = this.lower();
            if (t == null) {
                return 0.0;
            }
            this.m = (double)this.position(t) - 1.0;
        }
        return this.m;
    }

    public void reset() {
        this.j = null;
        this.m = null;
    }

    public void setMinimum(double d2) {
        Double d3 = this.m;
        this.m = d2;
        this.firePropertyChange("min", d3, d2);
    }

    public void setMaximum(double d2) {
        Double d3 = this.j;
        this.j = d2;
        this.firePropertyChange("max", d3, d2);
    }

    @Override
    public double size() {
        if (this.k == null) {
            return 0.0;
        }
        int n2 = this.k.size();
        if (n2 == 0) {
            return 0.0;
        }
        return this.maximum() - this.minimum();
    }

    public int position(T t) {
        int n2 = this.k.indexOf(t);
        if (n2 < 0) {
            throw new IllegalArgumentException("Value " + t + " not known");
        }
        return 1 + n2;
    }

    @Override
    public boolean contains(T t) {
        if (t == null) {
            return false;
        }
        for (T t2 : this.k) {
            if (!t.equals(t2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Category<T> category) {
        if (category == null) {
            return false;
        }
        for (Category<T> category2 : this.getCategoryValues()) {
            if (!category.equals(category2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<Category<T>> iterator() {
        return this.getCategoryValues().iterator();
    }

    public List<Category<T>> getCategoryValues() {
        if (this.i == null) {
            this.i = new ArrayList<Category<T>>();
            for (T t : this.getPossibleValues()) {
                this.i.add(new Category<T>(t, this));
            }
        }
        return this.i;
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + (this.i == null ? 0 : ((Object)this.i).hashCode());
        n2 = 31 * n2 + (this.k == null ? 0 : ((Object)this.k).hashCode());
        n2 = 31 * n2 + (this.j == null ? 0 : this.j.hashCode());
        n2 = 31 * n2 + (this.m == null ? 0 : this.m.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CategoryRange categoryRange = (CategoryRange)object;
        if (this.i == null ? categoryRange.i != null : !((Object)this.i).equals(categoryRange.i)) {
            return false;
        }
        if (this.k == null ? categoryRange.k != null : !((Object)this.k).equals(categoryRange.k)) {
            return false;
        }
        if (this.j == null ? categoryRange.j != null : !this.j.equals(categoryRange.j)) {
            return false;
        }
        return !(this.m == null ? categoryRange.m != null : !this.m.equals(categoryRange.m));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("#<CategoryRange ");
        stringBuilder.append("minimum=");
        stringBuilder.append(this.m);
        stringBuilder.append(" maximum=");
        stringBuilder.append(this.j);
        stringBuilder.append(">");
        return stringBuilder.toString();
    }
}

