/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SlidingOverFrameContainer
extends JPanel {
    protected static boolean DEBUG = false;
    protected HashMap<Component, SlidingFrameConstraint> _constraints;
    protected Rectangle rectDebug = new Rectangle();
    protected Container _contentPane = null;
    protected static final Dimension MIN_DIM = new Dimension(0, 0);
    protected static final Dimension MAX_DIM = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);

    public SlidingOverFrameContainer(Container container) {
        super(null);
        this.setLayout(new SlidingFrameLayout());
        this.setOpaque(false);
        this._contentPane = container;
        this._constraints = new HashMap();
    }

    protected void addImpl(Component component, Object object, int n2) {
        if (!(object instanceof SlidingFrameConstraint)) {
            throw new IllegalArgumentException("constraint must be of type " + SlidingFrameConstraint.class.getName());
        }
        this._constraints.put(component, (SlidingFrameConstraint)object);
        super.addImpl(component, object, n2);
    }

    public void remove(int n2) {
        Component component = this.getComponent(n2);
        super.remove(n2);
        this.b(component);
    }

    private void b(Component component) {
        this._constraints.remove(component);
    }

    protected void paintComponent(Graphics graphics) {
        if (DEBUG) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.paintRect(graphics2D);
        }
    }

    protected void paintRect(Graphics2D graphics2D) {
        if (this.getComponentCount() < 1) {
            return;
        }
        Composite composite = graphics2D.getComposite();
        Color color = graphics2D.getColor();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.15f));
        graphics2D.setColor(Color.BLUE);
        graphics2D.fillRect(this.rectDebug.x, this.rectDebug.y, this.rectDebug.width, this.rectDebug.height);
        graphics2D.setColor(Color.RED);
        graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
        Rectangle rectangle = new Rectangle();
        for (int i2 = 0; i2 < this.getComponents().length; ++i2) {
            Component component = this.getComponent(i2);
            rectangle = component.getBounds(rectangle);
            graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 4, 4);
        }
        graphics2D.setColor(color);
        graphics2D.setComposite(composite);
    }

    public Rectangle computeLayoutBounds(Component component, DockableFrame dockableFrame, int n2, boolean bl) {
        Container container = component.getParent();
        Rectangle rectangle = SwingUtilities.convertRectangle(container, container.getBounds(), container);
        if (DEBUG) {
            this.rectDebug = rectangle;
            this.repaint();
        }
        switch (n2) {
            case 4: {
                if (bl) {
                    rectangle.width = Math.min(container.getWidth(), dockableFrame.getAutohideWidth());
                    rectangle.x += container.getWidth() - rectangle.width;
                    break;
                }
                rectangle.width = Math.min(container.getWidth(), dockableFrame.getAutohideWidth());
                break;
            }
            case 8: {
                if (bl) {
                    rectangle.width = Math.min(container.getWidth(), dockableFrame.getAutohideWidth());
                    break;
                }
                rectangle.width = Math.min(container.getWidth(), dockableFrame.getAutohideWidth());
                rectangle.x += container.getWidth() - rectangle.width;
                break;
            }
            case 2: {
                rectangle.height = Math.min(container.getHeight(), dockableFrame.getAutohideHeight());
                rectangle.y += container.getHeight() - rectangle.height;
                break;
            }
            case 1: {
                rectangle.height = Math.min(container.getHeight(), dockableFrame.getAutohideHeight());
            }
        }
        return rectangle;
    }

    public boolean contains(int n2, int n3) {
        Component[] componentArray;
        for (Component component : componentArray = this.getComponents()) {
            Point point = SwingUtilities.convertPoint(this, n2, n3, component);
            if (!component.contains(point.x, point.y)) continue;
            return true;
        }
        return false;
    }

    protected class SlidingFrameLayout
    implements LayoutManager2 {
        protected Rectangle _stepBounds = new Rectangle();

        protected SlidingFrameLayout() {
        }

        public void addLayoutComponent(Component component, Object object) {
        }

        public float getLayoutAlignmentX(Container container) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container container) {
            return 0.0f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void invalidateLayout(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Component[] componentArray;
                for (Component component : componentArray = SlidingOverFrameContainer.this.getComponents()) {
                    this.setupContainer(container, component, SlidingOverFrameContainer.this._constraints.get(component));
                }
            }
        }

        public Dimension maximumLayoutSize(Container container) {
            return MAX_DIM;
        }

        public Dimension minimumLayoutSize(Container container) {
            return MIN_DIM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Dimension preferredLayoutSize(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                return SlidingOverFrameContainer.this.getSize();
            }
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void layoutContainer(Container container) {
            Object object = container.getTreeLock();
            synchronized (object) {
                Component[] componentArray;
                for (Component component : componentArray = SlidingOverFrameContainer.this.getComponents()) {
                    this.setupContainer(container, component, SlidingOverFrameContainer.this._constraints.get(component));
                }
            }
        }

        public void setupContainer(Container container, Component component, SlidingFrameConstraint slidingFrameConstraint) {
            if (slidingFrameConstraint == null) {
                return;
            }
            Rectangle rectangle = SlidingOverFrameContainer.this.computeLayoutBounds(slidingFrameConstraint.dockingComponent, slidingFrameConstraint.frame, slidingFrameConstraint.side, slidingFrameConstraint.isLeftToRight);
            this._stepBounds.setBounds(rectangle);
            switch (slidingFrameConstraint.side) {
                case 4: {
                    if (slidingFrameConstraint.isLeftToRight) {
                        this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                        this._stepBounds.x = rectangle.x + rectangle.width - this._stepBounds.width;
                        break;
                    }
                    this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                    break;
                }
                case 8: {
                    if (slidingFrameConstraint.isLeftToRight) {
                        this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                        break;
                    }
                    this._stepBounds.width = slidingFrameConstraint.currentStep * rectangle.width / slidingFrameConstraint.steps;
                    this._stepBounds.x = rectangle.x + rectangle.width - this._stepBounds.width;
                    break;
                }
                case 2: {
                    this._stepBounds.height = slidingFrameConstraint.currentStep * rectangle.height / slidingFrameConstraint.steps;
                    this._stepBounds.y = rectangle.y + rectangle.height - this._stepBounds.height;
                    break;
                }
                case 1: {
                    this._stepBounds.height = slidingFrameConstraint.currentStep * rectangle.height / slidingFrameConstraint.steps;
                }
            }
            if (SystemInfo.isJdk6u14Above()) {
                Rectangle rectangle2 = this._stepBounds;
                Point point = rectangle2.getLocation();
                try {
                    Window window = SwingUtilities.getWindowAncestor(SlidingOverFrameContainer.this);
                    point = SwingUtilities.convertPoint(SlidingOverFrameContainer.this, point, window);
                    Rectangle2D rectangle2D = new Rectangle();
                    if (slidingFrameConstraint.frame.isAutohideShowing()) {
                        rectangle2D = new Rectangle2D.Float(point.x, point.y, rectangle2.width, rectangle2.height);
                    }
                    Class<?> clazz = Class.forName("com.sun.awt.AWTUtilities");
                    Method method = clazz.getMethod("setComponentMixingCutoutShape", Component.class, Shape.class);
                    method.invoke(null, SlidingOverFrameContainer.this, rectangle2D);
                }
                catch (Exception exception) {
                }
                catch (Error error) {
                    // empty catch block
                }
            }
            component.setBounds(this._stepBounds);
        }
    }

    public class SlidingFrameConstraint {
        public DockableFrame frame;
        public Component dockingComponent;
        public int steps;
        public int currentStep;
        public int side;
        public boolean isLeftToRight;
        public boolean opening;
    }
}

