/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.docking;

import com.jidesoft.docking.DockableFrame;
import com.jidesoft.docking.DockingManager;
import com.jidesoft.docking.FloatingContainer;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.ResizableWindow;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;

public abstract class DockableFramePopup
extends JidePopup {
    private DockingManager nb;
    public DockableFrame _dockableFrame;

    public DockableFramePopup(DockingManager dockingManager) {
        if (dockingManager == null) {
            throw new IllegalArgumentException("DockingManager cannot be null.");
        }
        this.nb = dockingManager;
    }

    protected void internalShowPopup(int n2, int n3) {
        this.internalShowPopup(n2, n3, null);
    }

    protected void internalShowPopup(int n2, int n3, Component component) {
        if (this._window != null) {
            return;
        }
        this._dockableFrame = this.getDockableFrame();
        this._dockableFrame.u(false);
        this._dockableFrame.setTransient(true);
        this._dockableFrame.getContentPane().removeAll();
        this._dockableFrame.getContentPane().add(this);
        if (this.nb.getFrame(this._dockableFrame.getKey()) != null) {
            this.nb.showFrame(this._dockableFrame.getKey());
        } else {
            this._window = this.createHeavyweightPopupContainer(component);
            this._resizableSupport = this._window;
            if (this._window == null) {
                return;
            }
            this.installBorder();
            this._window.pack();
            Point point = this.getPopupLocation(new Point(n2, n3), this._window.getSize(), component);
            this._window.setLocation(point.x, point.y);
            this.installListeners();
            this.showPopupImmediately();
        }
    }

    protected ResizableWindow createHeavyweightPopupContainer(Component component) {
        FloatingContainer floatingContainer = this.nb.createFloatingContainer(SwingUtilities.getWindowAncestor(component));
        DockingManager.FloatingContainerCustomizer floatingContainerCustomizer = this.nb.getFloatingContainerCustomizer();
        if (floatingContainerCustomizer != null) {
            floatingContainerCustomizer.customize(floatingContainer);
        }
        floatingContainer.getContentPane().add(this._dockableFrame);
        if (floatingContainer instanceof ResizableWindow) {
            return (ResizableWindow)((Object)floatingContainer);
        }
        return null;
    }

    public abstract DockableFrame createDockableFrame();

    public DockableFrame getDockableFrame() {
        if (this._dockableFrame == null) {
            this._dockableFrame = this.createDockableFrame();
        }
        return this._dockableFrame;
    }

    public void setDetached(boolean bl) {
        if (this._detached != bl) {
            boolean bl2 = this._detached;
            this._detached = bl;
            this.firePropertyChange("detached", bl2, this._detached);
            if (bl) {
                this._dockableFrame.setShowGripper(this.nb.isShowGripper());
                try {
                    this._dockableFrame.setFloated(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                this._dockableFrame.u(false);
                this.setMovable(true);
            }
            if (this._window != null) {
                if (this._detached) {
                    if (this.getPopupBorder() == null) {
                        this._window.setBorder(UIDefaultsLookup.getBorder("Resizable.resizeBorder"));
                    } else {
                        this._window.setBorder(this.getPopupBorder());
                    }
                    if (this.isResizable()) {
                        this._window.getResizable().setResizableCorners(255);
                    }
                } else {
                    if (this.getPopupBorder() == null) {
                        this._window.setBorder(UIDefaultsLookup.getBorder("PopupMenu.border"));
                    } else {
                        this._window.setBorder(this.getPopupBorder());
                    }
                    if (this.isResizable()) {
                        this._window.getResizable().setResizableCorners(56);
                    }
                }
            }
        }
    }

    protected void endDragging() {
        super.endDragging();
        if (this.isDetached() && this.nb.getFrame(this._dockableFrame.getKey()) == null) {
            this._dockableFrame.setInitMode(1);
            this._dockableFrame.setUndockedBounds(new Rectangle(this._dockableFrame.getLocationOnScreen(), this._dockableFrame.getSize()));
            this.nb.addFrame(this._dockableFrame);
            this._window.pack();
            try {
                this._dockableFrame.setActive(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

