/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.project.resourcecache;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.exml.project.resourcecache.PathNode;
import ro.sync.exml.project.resourcecache.Resource;
import ro.sync.exml.project.resourcecache.d;
import ro.sync.util.URLUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ProjectResource
implements Serializable,
d {
    public static final long serialVersionUID = 1760405163219L;
    String name;
    private PathNode parent;
    private int usageCount = 1;
    private int indexInList = -1;
    String query;
    String anchor;

    public ProjectResource(String string, PathNode pathNode, String string2, String string3) {
        this.name = string;
        this.parent = pathNode;
        this.anchor = string2;
        this.query = string3;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getPath() + "[" + this.usageCount + "]";
    }

    public boolean equals(Object object) {
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return this.getPath().equals(resource.getPath());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public String getPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.parent.getPath());
        stringBuilder.append(this.name);
        if (this.anchor != null) {
            stringBuilder.append('#').append(this.anchor);
        }
        if (this.query != null) {
            stringBuilder.append('?').append(this.query);
        }
        return stringBuilder.toString();
    }

    public File getResourceFile() {
        File file = null;
        try {
            URL uRL = new URL(this.getPath());
            file = URLUtil.getCanonicalFileFromFileUrl(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return file;
    }

    @Override
    public String getParentPath() {
        return this.parent.getPath();
    }

    public PathNode getParent() {
        return this.parent;
    }

    public String getQuery() {
        return this.query;
    }

    public String getAnchor() {
        return this.anchor;
    }

    @Override
    public void increaseUsageCount() {
        ++this.usageCount;
    }

    @Override
    public void decreaseUsageCount() {
        --this.usageCount;
    }

    public void setIndex(int n2) {
        this.indexInList = n2;
    }

    public int getIndex() {
        return this.indexInList;
    }

    @Override
    public int getUsageCount() {
        return this.usageCount;
    }

    public void removeParent() {
        this.parent = null;
    }
}

