/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.List;
import java.util.Set;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.WidthRepresentation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.InsertColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableCellsContentConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSTableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class InsertColumnOperation
extends InsertColumnOperationBase
implements CALSConstants,
InsertTableCellsContentConstants {
    private ArgumentDescriptor[] arguments;
    protected String cellContent;

    public InsertColumnOperation() {
        super(new CALSDocumentTypeHelper());
        ArgumentDescriptor[] argumentDescriptorArray = super.getArguments();
        if (argumentDescriptorArray != null) {
            this.arguments = new ArgumentDescriptor[argumentDescriptorArray.length + 1];
            for (int i2 = 0; i2 < argumentDescriptorArray.length; ++i2) {
                this.arguments[i2] = argumentDescriptorArray[i2];
            }
            this.arguments[argumentDescriptorArray.length] = CELL_FRAGMENT_ARGUMENT;
        } else {
            this.arguments = CELL_FRAGMENT_ARGUMENT_IN_ARRAY;
        }
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        Object object = argumentsMap.getArgumentValue("cellFragment");
        if (object instanceof String) {
            this.cellContent = (String)object;
        }
        if ("".equals(this.cellContent)) {
            this.cellContent = null;
        }
        super.doOperation(authorAccess, argumentsMap);
    }

    @Override
    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, TableColumnSpecificationInformation tableColumnSpecificationInformation, String string) throws AuthorOperationException {
        StringBuilder stringBuilder;
        Object object3;
        Set<CALSColSpec> set = ((CALSTableCellInfoProvider)authorTableCellSpanProvider).getColSpecs();
        int n3 = -1;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        for (CALSColSpec cALSColSpec : set) {
            if (cALSColSpec.getColumnName() != null) {
                ++n4;
            }
            if (!cALSColSpec.isColNumberSpecified()) continue;
            ++n5;
        }
        boolean bl2 = set.size() == 0 || n5 > 0;
        boolean bl3 = set.size() == 0 || n4 > 0;
        for (CALSColSpec object22 : set) {
            n3 = object22.getIndexInDocument();
            if (object22.getColumnNumber() < n2 + 1) continue;
            bl = true;
            break;
        }
        int n6 = -1;
        if (n3 != -1) {
            Object object2;
            List<AuthorNode> list = authorElement.getContentNodes();
            for (Object object3 : list) {
                if (!this.isElement((AuthorNode)object3, "colspec") || (object2 = ((AuthorElement)object3).getAttribute("colnum")) == null) continue;
                try {
                    int n7 = Integer.parseInt(((AttrValue)object2).getValue());
                    if (n7 < n2 + 1) continue;
                    authorAccess.getDocumentController().setAttribute("colnum", new AttrValue("" + (n7 + 1)), (AuthorElement)object3);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            int n8 = 0;
            object3 = list.iterator();
            while (object3.hasNext()) {
                object2 = (AuthorNode)object3.next();
                if (this.isElement((AuthorNode)object2, "colspec") && n8 == n3) {
                    n6 = bl ? object2.getStartOffset() : object2.getEndOffset() + 1;
                    break;
                }
                ++n8;
            }
        } else if (n2 == 0) {
            n6 = authorElement.getStartOffset() + 1;
        }
        if (n6 != -1) {
            stringBuilder = new StringBuilder();
            stringBuilder.append("<").append("colspec");
            if (string != null) {
                stringBuilder.append(" xmlns=\"").append(string).append("\"");
            }
            if (bl3) {
                String string2 = null;
                if (tableColumnSpecificationInformation instanceof CALSTableColumnSpecificationInformation) {
                    string2 = ((CALSTableColumnSpecificationInformation)tableColumnSpecificationInformation).getColumnName();
                }
                if (string2 == null) {
                    string2 = this.getUniqueColSpecName(set, n2 + 1);
                }
                stringBuilder.append(" ").append("colname");
                stringBuilder.append("=\"").append(string2).append("\"");
            }
            if (bl2) {
                stringBuilder.append(" ").append("colnum");
                stringBuilder.append("=\"").append(n2 + 1).append("\"");
            }
            String string3 = this.getDefaultColWidthValue();
            if (tableColumnSpecificationInformation != null && (object3 = tableColumnSpecificationInformation.getWidthRepresentation()) != null) {
                string3 = ((WidthRepresentation)object3).getWidthRepresentation();
            }
            if (string3 != null) {
                stringBuilder.append(" ").append("colwidth");
                stringBuilder.append("=\"").append(string3).append("\"");
            }
        } else {
            throw new AuthorOperationException("Could not compute the index of the column to be inserted.");
        }
        stringBuilder.append("/>");
        authorAccess.getDocumentController().insertXMLFragment(stringBuilder.toString(), n6);
    }

    protected String getDefaultColWidthValue() {
        return "1*";
    }

    private String getUniqueColSpecName(Set set, int n2) {
        String string = "newCol" + n2;
        boolean bl = false;
        block0: while (!bl) {
            bl = true;
            for (CALSColSpec cALSColSpec : set) {
                if (!string.equals(cALSColSpec.getColumnName())) continue;
                bl = false;
                string = "newCol" + n2;
                ++n2;
                continue block0;
            }
        }
        return string;
    }

    @Override
    protected String getCellElementName(AuthorElement authorElement, int n2) {
        return "entry";
    }

    @Override
    protected String getDefaultContentForEmptyCells() {
        return this.cellContent;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }
}

