/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations.text;

import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.css.Styles;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.text.FormSelectedTextOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class CapitalizeSentencesOperation
extends FormSelectedTextOperation {
    private static final char[] SENTENCE_DELIMITER_CHARS = new char[]{'.', '?', '!'};

    @Override
    protected boolean isDelimiterBeforeTextNode(AuthorAccess authorAccess, int n2) throws BadLocationException, AuthorOperationException {
        AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
        boolean bl = false;
        Segment segment = new Segment();
        --n2;
        while (n2 >= 1) {
            authorDocumentController.getChars(n2, 1, segment);
            char c2 = segment.array[segment.offset];
            if (c2 == '\u0000') {
                OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n2);
                AuthorNode authorNode = offsetInformation.getNodeForMarkerOffset();
                Styles styles = authorAccess.getEditorAccess().getStyles(authorNode);
                if (!styles.isInline()) {
                    bl = true;
                    break;
                }
            } else {
                if (this.isSentenceDelimiter(c2)) {
                    bl = true;
                    break;
                }
                if (!this.isWordDelimiter(c2)) break;
            }
            --n2;
        }
        return bl;
    }

    @Override
    protected char[] processTextContent(char[] cArray, boolean bl) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            char c2 = cArray[i2];
            if (this.isSentenceDelimiter(c2)) {
                bl = true;
                continue;
            }
            if (!bl || !Character.isLetterOrDigit(c2)) continue;
            cArray[i2] = Character.toUpperCase(c2);
            bl = false;
        }
        return cArray;
    }

    private boolean isSentenceDelimiter(char c2) {
        boolean bl = false;
        for (int i2 = 0; i2 < SENTENCE_DELIMITER_CHARS.length; ++i2) {
            if (SENTENCE_DELIMITER_CHARS[i2] != c2) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public String getDescription() {
        return "Capitalize the first letter of each sentence in the current selection.";
    }
}

