/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.content.OffsetInformation;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.operations.CommonsOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ToggleSurroundWithElementOperation
implements AuthorOperation {
    private static final Logger logger = Logger.getLogger((String)ToggleSurroundWithElementOperation.class.getName());
    public static final String ARGUMENT_ELEMENT = "element";
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{new ArgumentDescriptor("element", 1, "The element to surround with."), new ArgumentDescriptor("schemaAware", 3, "This argument applies only on the surround with element operation and controls if the insertion is schema aware or not. When schema aware is enabled and the element insertion is not allowed, a dialog will be shown proposing insertion solutions, like:\n - splitting an ancestor of the node at insertion offset and inserting the element between the resulted elements;\n - inserting the element somewhere in the proximity of the insertion offset (left or right without skipping content);\n - inserting the element at insertion offset, even it is not allowed.\n\nNote: if a selection exists the surround with element operation is not schema aware.\nPossible values are: true, false. Default value is true.", new String[]{"true", "false"}, "true")};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws AuthorOperationException {
        Object object = argumentsMap.getArgumentValue(ARGUMENT_ELEMENT);
        Object object2 = argumentsMap.getArgumentValue("schemaAware");
        if (object == null || !(object instanceof String) || ((String)object).length() <= 0) throw new IllegalArgumentException("The value of the 'element' argument was not specified.");
        String string = (String)object;
        AuthorElement authorElement = this.getElementFromFragment(string, authorAccess);
        boolean bl = !"false".equals(object2);
        authorAccess.getDocumentController().beginCompoundEdit();
        try {
            if (authorAccess.getEditorAccess().hasSelection()) {
                boolean bl2;
                int n2;
                int n3 = authorAccess.getEditorAccess().getBalancedSelectionStart();
                boolean bl3 = this.unwrapElementsMatchingReferenceElement(n3, n2 = authorAccess.getEditorAccess().getBalancedSelectionEnd() - 1, authorElement, authorAccess, bl2 = authorAccess.getEditorAccess().getSelectionStart() == authorAccess.getEditorAccess().getCaretOffset());
                if (!bl3) return;
                CommonsOperationsUtil.surroundWithFragment(authorAccess, bl, string);
                return;
            } else {
                boolean bl4;
                int[] nArray = authorAccess.getEditorAccess().getWordAtCaret();
                int n4 = authorAccess.getEditorAccess().getCaretOffset();
                AuthorElement authorElement2 = this.getElementAtCaretOffset(authorAccess);
                AuthorElement authorElement3 = this.getElementMatchingReferenceElement(authorElement2, authorAccess, authorElement, true);
                boolean bl5 = bl4 = nArray != null && nArray[0] != n4 && nArray[1] != n4;
                if (authorElement3 != null) {
                    int n5 = 0;
                    if (bl4) {
                        OffsetInformation offsetInformation;
                        int[] nArray2 = this.unwrap(authorElement3, nArray[0], nArray[1] - 1, authorAccess);
                        int n6 = 0;
                        for (int i2 = nArray2[0]; i2 < nArray2[1] && (offsetInformation = authorAccess.getDocumentController().getContentInformationAtOffset(i2)).getPositionType() == 1; ++i2) {
                            ++n6;
                        }
                        n5 = n4 + n6 - (nArray[0] - nArray2[0]);
                    } else {
                        n5 = this.unwrap(authorElement3, n4, n4 - 1, authorAccess)[0];
                    }
                    authorAccess.getEditorAccess().setCaretPosition(n5);
                    return;
                } else if (bl4) {
                    CommonsOperationsUtil.surroundWithFragment(authorAccess, string, nArray[0], nArray[1] - 1);
                    authorAccess.getEditorAccess().setCaretPosition(n4 + 1);
                    return;
                } else {
                    CommonsOperationsUtil.surroundWithFragment(authorAccess, bl, string);
                }
            }
            return;
        }
        catch (AuthorOperationStoppedByUserException authorOperationStoppedByUserException) {
            authorAccess.getDocumentController().cancelCompoundEdit();
            return;
        }
        catch (AuthorOperationException authorOperationException) {
            authorAccess.getDocumentController().cancelCompoundEdit();
            throw authorOperationException;
        }
        catch (Exception exception) {
            logger.error((Object)exception, (Throwable)exception);
            authorAccess.getDocumentController().cancelCompoundEdit();
            throw new AuthorOperationException("The operation could not be executed.");
        }
        finally {
            authorAccess.getDocumentController().endCompoundEdit();
        }
    }

    private int[] extendSelectionOverSentinels(int n2, int n3, int n4, int n5, AuthorAccess authorAccess) throws BadLocationException {
        AuthorNode authorNode = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), n2, n3);
        if (authorNode != null) {
            boolean bl = false;
            if (authorNode.getStartOffset() == n2 - 1 && n2 - 1 >= n4) {
                --n2;
                bl = true;
            }
            if (authorNode.getEndOffset() == n3 + 1 && n3 + 1 <= n5) {
                ++n3;
                bl = true;
            }
            if (bl) {
                return this.extendSelectionOverSentinels(n2, n3, n4, n5, authorAccess);
            }
        }
        return new int[]{n2, n3};
    }

    private void select(int n2, int n3, AuthorAccess authorAccess, boolean bl) {
        if (bl) {
            authorAccess.getEditorAccess().select(n3, n2);
        } else {
            authorAccess.getEditorAccess().select(n2, n3);
        }
    }

    private AuthorElement getElementAtCaretOffset(AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorNode authorNode = null;
        try {
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
            throw new AuthorOperationException("Cannot identify the current element", badLocationException);
        }
        for (authorNode = authorAccess.getDocumentController().getNodeAtOffset(authorAccess.getEditorAccess().getCaretOffset()); authorNode != null && !(authorNode instanceof AuthorElement); authorNode = authorNode.getParent()) {
        }
        if (!(authorNode instanceof AuthorElement)) {
            throw new AuthorOperationException("The carret is not inside an element.");
        }
        AuthorElement authorElement = (AuthorElement)authorNode;
        return authorElement;
    }

    private AuthorElement getElementMatchingReferenceElement(AuthorElement authorElement, AuthorAccess authorAccess, AuthorElement authorElement2, boolean bl) {
        AuthorNode authorNode;
        AuthorElement authorElement3 = null;
        if (this.elementMatchesReferenceElement(authorElement, authorElement2)) {
            authorElement3 = authorElement;
        }
        AuthorElement authorElement4 = authorAccess.getDocumentController().getAuthorDocumentNode().getRootElement();
        while ((authorElement3 == null || bl) && (authorNode = authorElement.getParent()) instanceof AuthorElement && authorNode != authorElement4) {
            authorElement = (AuthorElement)authorNode;
            if (!this.elementMatchesReferenceElement(authorElement, authorElement2)) continue;
            authorElement3 = authorElement;
        }
        return authorElement3;
    }

    private boolean elementMatchesReferenceElement(AuthorElement authorElement, AuthorElement authorElement2) {
        boolean bl = true;
        if (authorElement.getName().equals(authorElement2.getName())) {
            if (authorElement.getNamespace().equals(authorElement2.getNamespace())) {
                int n2 = authorElement2.getAttributesCount();
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = authorElement2.getAttributeAtIndex(i2);
                    if (string.startsWith("xmlns")) continue;
                    AttrValue attrValue = authorElement.getAttribute(string);
                    AttrValue attrValue2 = authorElement2.getAttribute(string);
                    if (attrValue != null && attrValue2.getValue().equals(attrValue.getValue())) continue;
                    bl = false;
                    break;
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private AuthorElement getElementFromFragment(String string, AuthorAccess authorAccess) throws AuthorOperationException {
        AuthorElement authorElement = null;
        AuthorDocumentFragment authorDocumentFragment = authorAccess.getDocumentController().createNewDocumentFragmentInContext(string, authorAccess.getEditorAccess().getCaretOffset());
        List<AuthorNode> list = authorDocumentFragment.getContentNodes();
        if (list.size() != 1 || authorDocumentFragment.containsSimpleText()) {
            throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
        }
        AuthorNode authorNode = list.get(0);
        if (authorNode instanceof AuthorElement) {
            if (((AuthorElement)authorNode).getContentNodes().size() > 0) {
                throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
            }
        } else {
            throw new AuthorOperationException("The value of the 'element' argument is not valid. It must be an XML fragment containing a single element.");
        }
        authorElement = (AuthorElement)authorNode;
        return authorElement;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Toggle \"surround with element\" operation.\n If there is no selection in the document and the caret is inside a word,\nthe word is wrapped in the given element (or unwrapped if it is already\nincluded in the element), else the fragment is inserted at caret position.\n If there is a selection in the document, it is wrapped in the given element\n(or unwrapped if it is already included in the element).\n";
    }

    private int[] unwrap(AuthorElement authorElement, int n2, int n3, AuthorAccess authorAccess) {
        try {
            boolean bl = n2 > n3;
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            int n4 = authorElement.getStartOffset();
            int n5 = authorElement.getEndOffset();
            int[] nArray = this.extendSelectionOverSentinels(n2, n3, authorElement.getStartOffset(), authorElement.getEndOffset(), authorAccess);
            n2 = nArray[0];
            n3 = nArray[1];
            if (n2 > n4 && n3 < n5) {
                AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n3 + 1, n5);
                authorDocumentController.delete(n3 + 1, n5);
                AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n4 + 1);
                int n6 = authorNode.getEndOffset() + 1;
                authorDocumentController.insertFragment(n6, authorDocumentFragment);
                int n7 = 0;
                int n8 = n2 < n3 ? n3 - n2 + 1 : 0;
                AuthorDocumentFragment authorDocumentFragment2 = null;
                if (n2 <= authorNode.getEndOffset() - 1) {
                    authorDocumentFragment2 = authorDocumentController.createDocumentFragment(n2, authorNode.getEndOffset() - 1);
                    n7 = (authorDocumentFragment2.getLength() - n8) / 2;
                    authorDocumentController.delete(n2, authorNode.getEndOffset() - 1);
                    authorNode = authorDocumentController.getNodeAtOffset(n4 + 1);
                    n6 = authorNode.getEndOffset() + 1;
                    authorDocumentController.insertFragment(n6, authorDocumentFragment2);
                }
                n2 = n6 + n7;
                n3 = n2 + n8 - 1;
            } else if (n4 >= n2 && n3 >= n5 - 1) {
                if (n4 == n5 - 1) {
                    authorDocumentController.deleteNode(authorElement);
                } else {
                    AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n4 + 1, n5 - 1);
                    authorDocumentController.delete(n4, n5);
                    authorDocumentController.insertFragment(n4, authorDocumentFragment);
                }
                if (n2 > n4) {
                    --n2;
                }
                if (n3 != n5 - 1) {
                    n3 -= 2;
                }
            } else if (n4 < n2) {
                if (n2 < n5) {
                    AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n2, n5 - 1);
                    authorDocumentController.delete(n2, n5 - 1);
                    AuthorNode authorNode = authorDocumentController.getNodeAtOffset(n4 + 1);
                    int n9 = authorNode.getEndOffset() + 1;
                    authorDocumentController.insertFragment(n9, authorDocumentFragment);
                    if (bl) {
                        n3 = n2 = n9 + authorDocumentFragment.getLength() / 2;
                    } else {
                        n2 = n9;
                        n3 = n9 + authorDocumentFragment.getLength() + n3 - (n5 + 1);
                    }
                }
            } else if (n3 > n4) {
                AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n4 + 1, n3);
                authorDocumentController.delete(n4 + 1, n3);
                authorDocumentController.insertFragment(n4, authorDocumentFragment);
                n3 = bl ? (n2 = n4 + authorDocumentFragment.getLength() / 2) : n4 + authorDocumentFragment.getLength() - 1;
            } else {
                --n3;
            }
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return new int[]{++n2, --n3};
    }

    private boolean unwrapElementsMatchingReferenceElement(int object, int object2, AuthorElement authorElement, AuthorAccess authorAccess, boolean bl) throws AuthorOperationException {
        boolean bl2 = false;
        try {
            AuthorElement authorElement2;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Object object3;
            AuthorDocumentController authorDocumentController = authorAccess.getDocumentController();
            Segment segment = new Segment();
            authorDocumentController.getChars((int)object, object2 - object + 1, segment);
            char c2 = segment.first();
            int n7 = object;
            AuthorNode authorNode = null;
            AuthorNode authorNode2 = null;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean[] blArray = new boolean[object2 - object + 1];
            while (c2 != '\uffff') {
                if (c2 == '\u0000') {
                    OffsetInformation offsetInformation = authorDocumentController.getContentInformationAtOffset(n7);
                    object3 = offsetInformation.getNodeForMarkerOffset();
                    if (object3 instanceof AuthorElement) {
                        n6 = object3.getStartOffset();
                        n5 = object3.getEndOffset();
                        if (this.elementMatchesReferenceElement((AuthorElement)object3, authorElement)) {
                            n4 = Math.max(object, n6);
                            n3 = Math.min(object2, n5);
                            for (n2 = n4 - object; n2 <= n3 - object; ++n2) {
                                blArray[n2] = true;
                            }
                            if (offsetInformation.getPositionType() == 1) {
                                if (object2 < n5) {
                                    authorNode2 = (AuthorElement)object3;
                                    break;
                                }
                            } else if (offsetInformation.getPositionType() == 2 && object > n6) {
                                authorNode = (AuthorElement)object3;
                                bl3 = false;
                            }
                        } else {
                            blArray[n7 - object] = true;
                            if (offsetInformation.getPositionType() == 1) {
                                if (object2 < n5) {
                                    bl4 = true;
                                }
                            } else if (offsetInformation.getPositionType() == 2 && object > n6) {
                                bl3 = true;
                            }
                        }
                    }
                } else if (Character.isWhitespace(c2)) {
                    blArray[n7 - object] = true;
                }
                c2 = segment.next();
                ++n7;
            }
            for (int i2 = 0; i2 < blArray.length; ++i2) {
                if (blArray[i2]) continue;
                bl2 = true;
                break;
            }
            AuthorNode authorNode3 = null;
            if (!bl2 || bl3 || bl4) {
                if (authorNode2 != null) {
                    object3 = this.unwrap((AuthorElement)authorNode2, (int)object, (int)object2, authorAccess);
                    object = object3[0];
                    object2 = object3[1];
                }
                if (authorNode != null) {
                    object3 = this.unwrap((AuthorElement)authorNode, (int)object, (int)object2, authorAccess);
                    object = object3[0];
                    object2 = object3[1];
                }
            } else if (authorNode != null) {
                int n8 = authorNode.getEndOffset() + 1;
                n6 = authorNode2 != null ? authorNode2.getStartOffset() - 1 : object2;
                AuthorDocumentFragment authorDocumentFragment = authorDocumentController.createDocumentFragment(n8, n6);
                AuthorDocumentFragment authorDocumentFragment2 = null;
                n3 = 0;
                if (authorNode2 != null) {
                    n3 = authorNode2.getEndOffset() - object2;
                    authorDocumentFragment2 = authorDocumentController.createDocumentFragment(authorNode2.getStartOffset() + 1, authorNode2.getEndOffset() - 1);
                    authorDocumentController.deleteNode(authorNode2);
                }
                authorDocumentController.delete(n8, n6);
                n2 = authorNode.getEndOffset();
                if (authorNode2 != null) {
                    authorDocumentController.insertFragment(n2, authorDocumentFragment2);
                }
                authorDocumentController.insertFragment(n2, authorDocumentFragment);
                AuthorNode authorNode4 = authorDocumentController.getNodeAtOffset(n2);
                object2 = authorNode4.getEndOffset() - n3;
                authorNode3 = authorNode4;
                bl2 = false;
            } else if (authorNode2 != null) {
                object3 = authorDocumentController.createDocumentFragment((int)object, authorNode2.getStartOffset() - 1);
                n6 = authorNode2.getEndOffset() - object2;
                authorDocumentController.delete((int)object, authorNode2.getStartOffset() - 1);
                n5 = authorNode2.getStartOffset() + 1;
                authorDocumentController.insertFragment(n5, (AuthorDocumentFragment)object3);
                AuthorNode authorNode5 = authorDocumentController.getNodeAtOffset(n5);
                object2 = authorNode5.getEndOffset() - n6;
                authorNode3 = authorNode5;
                bl2 = false;
            }
            segment = new Segment();
            authorDocumentController.getChars((int)object, object2 - object + 1, segment);
            n7 = object;
            c2 = segment.first();
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            while (c2 != '\uffff') {
                OffsetInformation offsetInformation;
                AuthorNode authorNode6;
                if (c2 == '\u0000' && (authorNode6 = (offsetInformation = authorDocumentController.getContentInformationAtOffset(n7)).getNodeForMarkerOffset()) instanceof AuthorElement && this.elementMatchesReferenceElement((AuthorElement)authorNode6, authorElement)) {
                    n4 = authorNode6.getStartOffset();
                    n3 = authorNode6.getEndOffset();
                    if (offsetInformation.getPositionType() == 1 && object2 >= n3) {
                        arrayList.add(0, n4);
                    }
                }
                c2 = segment.next();
                ++n7;
            }
            for (Integer n9 : arrayList) {
                AuthorNode authorNode7 = authorDocumentController.getNodeAtOffset(n9 + 1);
                int[] nArray = this.unwrap((AuthorElement)authorNode7, (int)object, (int)object2, authorAccess);
                object = nArray[0];
                object2 = nArray[1];
            }
            this.select((int)object, object2 + 1, authorAccess, bl);
            AuthorNode authorNode8 = authorAccess.getDocumentController().getCommonParentNode(authorAccess.getDocumentController().getAuthorDocumentNode(), (int)object, (int)object2);
            if (authorNode8 instanceof AuthorElement && (authorElement2 = this.getElementMatchingReferenceElement((AuthorElement)authorNode8, authorAccess, authorElement, true)) != null && authorElement2 != authorNode3) {
                int[] nArray = this.unwrap(authorElement2, (int)object, (int)object2, authorAccess);
                this.select(nArray[0], nArray[1] + 1, authorAccess, bl);
                bl2 = false;
            }
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation could not be executed.");
        }
        return bl2;
    }
}

