/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.access.AuthorUtilAccess;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class SimpleURLChooserEditor
extends AbstractInplaceEditor
implements InplaceRenderer {
    private static final Logger logger = Logger.getLogger((String)SimpleURLChooserEditor.class.getName());
    private static final Boolean IS_ECLIPSE = Boolean.valueOf(System.getProperty("com.oxygenxml.is.eclipse.plugin"));
    private static final boolean IS_WIN32 = System.getProperty("os.name").toUpperCase().startsWith("WIN");
    private static final int VGAP = 0;
    private static final int HGAP = 5;
    private static final String UNDO_MANAGER_PROPERTY = "undo-manager-property";
    private final JButton browseBtn;
    private final JPanel urlChooserPanel = new JPanel(new BorderLayout(5, 0));
    private JTextField urlTextField;
    private boolean isBrowsing = false;
    private final Color defaultForeground;
    private AuthorUtilAccess utilAccess;
    private final java.awt.Font defaultFont;

    public SimpleURLChooserEditor() {
        URL uRL = SimpleURLChooserEditor.class.getResource("/images/Open16.gif");
        this.browseBtn = new JButton();
        if (uRL != null) {
            this.browseBtn.setIcon(new ImageIcon(uRL));
        }
        if (IS_WIN32) {
            this.browseBtn.setBorder(BorderFactory.createEmptyBorder(1, 6, 1, 5));
        }
        this.urlTextField = this.createTextField();
        this.defaultForeground = this.urlTextField.getForeground();
        this.urlTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                SimpleURLChooserEditor.this.fireEditingOccured();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                SimpleURLChooserEditor.this.fireEditingOccured();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                SimpleURLChooserEditor.this.fireEditingOccured();
            }
        });
        this.urlChooserPanel.add((Component)this.urlTextField, "Center");
        this.urlChooserPanel.add((Component)this.browseBtn, "East");
        this.urlChooserPanel.setOpaque(false);
        this.urlTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    SimpleURLChooserEditor.this.cancelEditing();
                } else if (keyEvent.getKeyCode() == 10) {
                    keyEvent.consume();
                    SimpleURLChooserEditor.this.stopEditing(true);
                }
            }
        });
        this.browseBtn.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    SimpleURLChooserEditor.this.cancelEditing();
                }
            }
        });
        FocusAdapter focusAdapter = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (focusEvent.getOppositeComponent() != SimpleURLChooserEditor.this.browseBtn && focusEvent.getOppositeComponent() != SimpleURLChooserEditor.this.urlTextField && !SimpleURLChooserEditor.this.isBrowsing) {
                    SimpleURLChooserEditor.this.fireCommitValue(new EditingEvent((String)SimpleURLChooserEditor.this.getValue()));
                }
            }
        };
        this.browseBtn.addFocusListener(focusAdapter);
        this.urlTextField.addFocusListener(focusAdapter);
        Insets insets = this.urlTextField.getMargin();
        Insets insets2 = null;
        insets2 = insets != null ? (Insets)insets.clone() : new Insets(1, 1, 1, 1);
        if (IS_WIN32 && IS_ECLIPSE.booleanValue()) {
            insets2.top = -1;
            insets2.left += 3;
        }
        this.urlTextField.setMargin(insets2);
        this.defaultFont = this.urlTextField.getFont();
    }

    @Override
    public String getDescription() {
        return "A sample implementation that provides a browse button associated with a text field.";
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.prepareComponents(authorInplaceContext, false);
        return this.urlChooserPanel;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.prepareComponents(authorInplaceContext, false);
        return this.computeRenderingInfo(authorInplaceContext);
    }

    private RendererLayoutInfo computeRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        Dimension dimension = this.urlTextField.getPreferredSize();
        int n2 = this.urlTextField.getPreferredSize().width;
        Integer n3 = (Integer)authorInplaceContext.getArguments().get("columns");
        if (n3 != null && n3 > 0) {
            FontMetrics fontMetrics = this.urlTextField.getFontMetrics(this.urlTextField.getFont());
            n2 = n3 * fontMetrics.charWidth('w');
        }
        n2 = (int)((double)n2 + (5.0 + this.browseBtn.getPreferredSize().getWidth()));
        int n4 = 0;
        if (IS_ECLIPSE.booleanValue()) {
            n4 = 5;
        }
        return new RendererLayoutInfo(this.urlTextField.getBaseline(dimension.width, dimension.height), new ro.sync.exml.view.graphics.Dimension(n2, dimension.height + n4));
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        this.prepareComponents(authorInplaceContext, false);
        return "Browse URL";
    }

    @Override
    public Object getEditorComponent(final AuthorInplaceContext authorInplaceContext, ro.sync.exml.view.graphics.Rectangle rectangle, Point point) {
        this.prepareComponents(authorInplaceContext, true);
        AuthorAccess authorAccess = authorInplaceContext.getAuthorAccess();
        final URL uRL = authorAccess.getEditorAccess().getEditorLocation();
        this.browseBtn.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block5: {
                    SimpleURLChooserEditor.this.isBrowsing = true;
                    try {
                        URL uRL3 = authorInplaceContext.getAuthorAccess().getWorkspaceAccess().chooseURL("Choose URL", null, null);
                        if (uRL3 == null) break block5;
                        String string = authorInplaceContext.getAuthorAccess().getUtilAccess().makeRelative(uRL, uRL3);
                        try {
                            URL uRL2 = SimpleURLChooserEditor.this.utilAccess.removeUserCredentials(new URL(string));
                            SimpleURLChooserEditor.this.urlTextField.setText(uRL2.toExternalForm());
                        }
                        catch (MalformedURLException malformedURLException) {
                            SimpleURLChooserEditor.this.urlTextField.setText(string);
                        }
                        SimpleURLChooserEditor.this.fireCommitValue(new EditingEvent((String)SimpleURLChooserEditor.this.getValue()));
                    }
                    finally {
                        SimpleURLChooserEditor.this.isBrowsing = false;
                    }
                }
            }
        });
        return this.urlChooserPanel;
    }

    @Override
    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        ro.sync.exml.view.graphics.Rectangle rectangle = null;
        try {
            Rectangle rectangle2 = this.urlTextField.modelToView(this.urlTextField.getCaretPosition());
            rectangle = new ro.sync.exml.view.graphics.Rectangle(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return rectangle;
    }

    @Override
    public void requestFocus() {
        this.urlTextField.requestFocus();
    }

    @Override
    public Object getValue() {
        String string = this.urlTextField.getText();
        try {
            URL uRL = this.utilAccess.removeUserCredentials(new URL(string));
            return uRL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return string;
        }
    }

    @Override
    public void stopEditing() {
        this.stopEditing(false);
    }

    private void stopEditing(boolean bl) {
        String string = this.urlTextField.getText();
        try {
            URL uRL = this.utilAccess.removeUserCredentials(new URL(string));
            string = uRL.toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (bl) {
            this.fireNextEditLocationRequested();
        } else {
            this.fireEditingStopped(new EditingEvent(string));
        }
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    private void prepareComponents(AuthorInplaceContext authorInplaceContext, boolean bl) {
        Object object;
        Font font;
        this.utilAccess = authorInplaceContext.getAuthorAccess().getUtilAccess();
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        if (color != null) {
            this.urlTextField.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.urlTextField.setForeground(this.defaultForeground);
        }
        this.setInitialValue(authorInplaceContext, bl);
        UndoManager undoManager = (UndoManager)this.urlTextField.getDocument().getProperty(UNDO_MANAGER_PROPERTY);
        if (undoManager != null) {
            undoManager.discardAllEdits();
        }
        if ((font = (Font)authorInplaceContext.getArguments().get("font")) != null) {
            object = new java.awt.Font(font.getName(), font.getStyle(), font.getSize());
            this.urlTextField.setFont((java.awt.Font)object);
            this.browseBtn.setFont((java.awt.Font)object);
        } else {
            this.urlTextField.setFont(this.defaultFont);
            this.browseBtn.setFont(this.defaultFont);
        }
        InplaceEditorUtil.relayout(this.urlTextField, authorInplaceContext);
        object = authorInplaceContext.getRelativeMouseLocation();
        boolean bl2 = false;
        if (object != null) {
            RendererLayoutInfo rendererLayoutInfo = this.computeRenderingInfo(authorInplaceContext);
            this.urlChooserPanel.setSize(rendererLayoutInfo.getSize().width, rendererLayoutInfo.getSize().height);
            this.urlChooserPanel.doLayout();
            Component component = this.urlChooserPanel.getComponentAt(((Point)object).x, ((Point)object).y);
            bl2 = component == this.browseBtn;
        }
        this.browseBtn.getModel().setRollover(bl2);
    }

    private void setInitialValue(AuthorInplaceContext authorInplaceContext, boolean bl) {
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        if (!bl && string == null) {
            this.urlTextField.setForeground(Color.GRAY);
            string = (String)authorInplaceContext.getArguments().get("default_value");
        }
        if (string == null) {
            string = "";
        }
        try {
            URL uRL = this.utilAccess.removeUserCredentials(new URL(string));
            this.urlTextField.setText(uRL.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            this.urlTextField.setText(string);
        }
    }

    protected JTextField createTextField() {
        JTextField jTextField = new JTextField();
        final UndoManager undoManager = new UndoManager();
        Document document = jTextField.getDocument();
        document.putProperty(UNDO_MANAGER_PROPERTY, undoManager);
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                undoManager.addEdit(undoableEditEvent.getEdit());
            }
        });
        jTextField.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (undoManager.canUndo()) {
                        undoManager.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        int n2 = System.getProperty("os.name").toUpperCase().startsWith("MAC OS") ? 256 : 128;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(90, n2, false);
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(89, n2, false);
        jTextField.getInputMap().put(keyStroke, "Undo");
        jTextField.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (undoManager.canRedo()) {
                        undoManager.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        jTextField.getInputMap().put(keyStroke2, "Redo");
        return jTextField;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return CursorType.CURSOR_NORMAL;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.setInitialValue(authorInplaceContext, true);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        try {
            this.urlTextField.getDocument().insertString(this.urlTextField.getCaretPosition(), string, null);
            bl = true;
        }
        catch (BadLocationException badLocationException) {
            logger.error((Object)badLocationException, (Throwable)badLocationException);
        }
        return bl;
    }
}

