/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.editor;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class InplaceEditorUtil {
    private static final Logger logger = Logger.getLogger((String)InplaceEditorUtil.class.getName());

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JPanel jPanel, AuthorInplaceContext authorInplaceContext) {
        return InplaceEditorUtil.getPreferredSize(jPanel, authorInplaceContext, jPanel.getFont().getSize());
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JPanel jPanel, AuthorInplaceContext authorInplaceContext, int n2) {
        Dimension dimension = jPanel.getPreferredSize();
        int n3 = dimension.width;
        int n4 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(authorInplaceContext.getArguments(), n2);
        if (n4 != -1) {
            n3 = n4;
        } else {
            Integer n5 = (Integer)authorInplaceContext.getArguments().get("columns");
            if (n5 != null && n5 > 0) {
                FontMetrics fontMetrics = jPanel.getFontMetrics(jPanel.getFont());
                n3 = n5 * fontMetrics.charWidth('w');
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(n3, dimension.height);
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JComboBox jComboBox, AuthorInplaceContext authorInplaceContext) {
        int n2 = jComboBox.getPreferredSize().width;
        int n3 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(authorInplaceContext.getArguments(), jComboBox.getFont().getSize());
        if (n3 != -1) {
            n2 = n3;
        } else {
            Integer n4 = (Integer)authorInplaceContext.getArguments().get("columns");
            if (n4 != null && n4 > 0) {
                FontMetrics fontMetrics = jComboBox.getFontMetrics(jComboBox.getFont());
                n2 = n4 * fontMetrics.charWidth('w');
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(n2, jComboBox.getPreferredSize().height);
    }

    public static ro.sync.exml.view.graphics.Dimension getPreferredSize(JTextField jTextField, AuthorInplaceContext authorInplaceContext) {
        FontMetrics fontMetrics = jTextField.getFontMetrics(jTextField.getFont());
        int n2 = jTextField.getPreferredSize().width + fontMetrics.charWidth('w');
        int n3 = authorInplaceContext.getPropertyEvaluator().evaluateWidthProperty(authorInplaceContext.getArguments(), jTextField.getFont().getSize());
        if (n3 != -1) {
            n2 = n3;
        } else {
            Integer n4 = (Integer)authorInplaceContext.getArguments().get("columns");
            if (n4 != null && n4 > 0) {
                n2 = n4 * fontMetrics.charWidth('w');
            } else if (jTextField.getText().length() == 0) {
                n2 = 2 * fontMetrics.charWidth('w');
            }
        }
        return new ro.sync.exml.view.graphics.Dimension(n2, jTextField.getPreferredSize().height);
    }

    public static void relayout(JComboBox jComboBox, AuthorInplaceContext authorInplaceContext) {
        ro.sync.exml.view.graphics.Dimension dimension = InplaceEditorUtil.getPreferredSize(jComboBox, authorInplaceContext);
        jComboBox.setSize(dimension.width, dimension.height);
        jComboBox.doLayout();
        InplaceEditorUtil.setCaretAtEnd((JTextField)jComboBox.getEditor().getEditorComponent(), authorInplaceContext);
    }

    public static void relayout(JTextField jTextField, AuthorInplaceContext authorInplaceContext) {
        ro.sync.exml.view.graphics.Dimension dimension = InplaceEditorUtil.getPreferredSize(jTextField, authorInplaceContext);
        jTextField.setSize(dimension.width, dimension.height);
        jTextField.doLayout();
        InplaceEditorUtil.setCaretAtEnd(jTextField, authorInplaceContext);
    }

    public static void setCaretAtEnd(final JTextComponent jTextComponent, AuthorInplaceContext authorInplaceContext) {
        boolean bl = true;
        if (authorInplaceContext.getAuthorAccess() != null && authorInplaceContext.getAuthorAccess().getWorkspaceAccess() != null) {
            bl = authorInplaceContext.getAuthorAccess().getWorkspaceAccess().isStandalone();
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                block3: {
                    int n2 = jTextComponent.getText().length();
                    jTextComponent.setCaretPosition(n2);
                    try {
                        Rectangle rectangle = jTextComponent.modelToView(n2);
                        if (rectangle != null) {
                            jTextComponent.scrollRectToVisible(rectangle);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        if (!logger.isDebugEnabled()) break block3;
                        logger.debug((Object)badLocationException, (Throwable)badLocationException);
                    }
                }
            }
        };
        try {
            if (bl || SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeAndWait(runnable);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.error((Object)invocationTargetException, (Throwable)invocationTargetException);
            logger.error((Object)invocationTargetException.getCause(), invocationTargetException.getCause());
        }
        catch (InterruptedException interruptedException) {
            logger.debug((Object)interruptedException, (Throwable)interruptedException);
        }
    }
}

