/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.SchemaManagerFilterBase;
import ro.sync.contentcompletion.xml.WhatAttributesCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.exml.m;
import ro.sync.exml.yb;
import ro.sync.ui.application.ib;
import ro.sync.ui.e.e;
import ro.sync.xml.XmlUtil;
import ro.sync.xml.parser.ParserCreator;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
@SkipObfuscate
public abstract class StyleGuideSchemaManagerFilterBase
extends SchemaManagerFilterBase {
    protected static final yb messages = m.e();
    private static Logger logger = Logger.getLogger(StyleGuideSchemaManagerFilterBase.class);
    private String locationOfMappingFile;
    private static final Map<String, Map<String, _b>> STYLE_GUIDE_ELEM_TO_HTML_CONTENT = new ConcurrentHashMap<String, Map<String, _b>>();

    public StyleGuideSchemaManagerFilterBase() {
    }

    public StyleGuideSchemaManagerFilterBase(String string) {
        this.locationOfMappingFile = string;
    }

    @Override
    public List<CIElement> filterElements(List<CIElement> list, WhatElementsCanGoHereContext whatElementsCanGoHereContext) {
        if (list != null) {
            String string = this.getMappingFileLocation(whatElementsCanGoHereContext);
            for (CIElement cIElement : list) {
                _b _b2;
                if (cIElement == null || (_b2 = this.getHTMLDocumentation(cIElement.getName(), string, true)) == null) continue;
                try {
                    cIElement.setAnnotation(this.mergeExistingAnnotation(cIElement.getAnnotation(), _b2));
                }
                catch (Exception exception) {
                    logger.error((Object)exception, (Throwable)exception);
                }
            }
        }
        return list;
    }

    protected String getMappingFileLocation(Context context) {
        return this.locationOfMappingFile;
    }

    private String mergeExistingAnnotation(String string, _b _b2) {
        if (_b2.c != null) {
            string = _b2.c;
        } else if (!_b2.b.isEmpty()) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                n2 = string.indexOf("</body>");
                if (n2 == -1) {
                    stringBuilder.append("<html><body>");
                    string = XmlUtil.escape(string);
                    string = string.replaceAll("\n", "<br />");
                    stringBuilder.append("<div>").append(string).append("</div>\n");
                } else {
                    stringBuilder.append(string.substring(0, n2));
                }
            } else {
                stringBuilder.append("<html><body>");
            }
            n2 = _b2.b.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (stringBuilder.toString().indexOf((String)_b2.b.get(i2)) != -1) continue;
                stringBuilder.append("<div>");
                stringBuilder.append((String)_b2.b.get(i2));
                stringBuilder.append("</div>");
            }
            stringBuilder.append("</body></html>");
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public List<CIAttribute> filterAttributes(List<CIAttribute> list, WhatAttributesCanGoHereContext whatAttributesCanGoHereContext) {
        if (list != null) {
            for (CIAttribute cIAttribute : list) {
                _b _b2 = this.getHTMLDocumentation(cIAttribute.getName(), this.getMappingFileLocation(whatAttributesCanGoHereContext), false);
                if (_b2 == null) continue;
                String string = this.mergeExistingAnnotation(cIAttribute.getAnnotation(), _b2);
                cIAttribute.setAnnotation(string);
            }
        }
        return list;
    }

    @Override
    public CIElement getElementDescription(CIElement cIElement, Context context) {
        _b _b2;
        if (cIElement != null && (_b2 = this.getHTMLDocumentation(cIElement.getName(), this.getMappingFileLocation(context), true)) != null) {
            try {
                cIElement.setAnnotation(this.mergeExistingAnnotation(cIElement.getAnnotation(), _b2));
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
            }
        }
        return cIElement;
    }

    _b getHTMLDocumentation(String string, String string2, boolean bl) {
        string = XmlUtil.getLocalName(string);
        Map<String, _b> map = STYLE_GUIDE_ELEM_TO_HTML_CONTENT.get(string2);
        if (map == null) {
            this.parseStyleGuideConfigurationMap(string2);
            map = STYLE_GUIDE_ELEM_TO_HTML_CONTENT.get(string2);
        }
        return map.get((bl ? "" : "@") + string);
    }

    @Override
    public void invalidate() {
        STYLE_GUIDE_ELEM_TO_HTML_CONTENT.clear();
    }

    void parseStyleGuideConfigurationMap(final String string) {
        final HashMap hashMap = new HashMap();
        ib ib2 = new ib("Download style guide mapping files"){

            @Override
            protected void mac() {
                try {
                    Document document;
                    URL uRL = new URL(string);
                    URL uRL2 = ro.sync.xml.m.b(null, uRL.toString(), false, true);
                    if (uRL2 != null) {
                        uRL = uRL2;
                    }
                    if ((document = ParserCreator.newDocumentBuilderFakeResolver().parse(uRL.toString())) != null) {
                        NodeList nodeList;
                        String string6 = document.getDocumentElement().getAttribute("htmlContentFilterStylesheet");
                        URL uRL3 = null;
                        if (string6 != null && string6.length() > 0) {
                            uRL3 = new URL(uRL, string6);
                        }
                        if ((nodeList = document.getElementsByTagName("mapping")) != null) {
                            for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
                                String string2;
                                Object object;
                                Node node = nodeList.item(i2);
                                if (node.getNodeType() != 1) continue;
                                Element element = (Element)node;
                                String string3 = null;
                                String string4 = null;
                                String string5 = element.getAttribute("elementName");
                                if (string5 != null && string5.length() > 0) {
                                    string3 = string5;
                                    string4 = element.getAttribute("path");
                                } else {
                                    object = element.getAttribute("attributeName");
                                    if (object != null && ((String)object).length() > 0) {
                                        string4 = element.getAttribute("path");
                                        string3 = "@" + (String)object;
                                    }
                                }
                                if (string4 == null || string4.length() <= 0) continue;
                                object = (_b)hashMap.get(string3);
                                if (object == null) {
                                    object = new _b();
                                    hashMap.put(string3, object);
                                }
                                if ("link".equals(element.getAttribute("type"))) {
                                    URL uRL4;
                                    URL uRL5;
                                    string2 = element.getAttribute("linkText");
                                    if (string2 == null || string2.length() == 0) {
                                        string2 = messages.b("More_details");
                                    }
                                    if ((uRL5 = ro.sync.xml.m.b(null, (uRL4 = new URL(new URL(element.getBaseURI()), string4)).toString(), false, true)) != null) {
                                        uRL4 = uRL5;
                                    }
                                    StringBuilder stringBuilder = new StringBuilder("<a href=\"").append(uRL4).append("\">").append(string2).append("</a>");
                                    ((_b)object).b.add(stringBuilder.toString());
                                    continue;
                                }
                                string2 = e.b(new URL(element.getBaseURI()), string4, uRL3);
                                ((_b)object).c = string2;
                            }
                        }
                    }
                }
                catch (Exception exception) {
                    logger.error((Object)exception, (Throwable)exception);
                }
            }
        };
        ib2.setPriority(1);
        ib2.start();
        try {
            ib2.join(1500L);
        }
        catch (InterruptedException interruptedException) {
            logger.debug((Object)interruptedException, (Throwable)interruptedException);
        }
        STYLE_GUIDE_ELEM_TO_HTML_CONTENT.put(string, hashMap);
    }

    private static class _b {
        private String c;
        private final List<String> b = new ArrayList<String>(1);

        private _b() {
        }
    }
}

