/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.helpers.FileURL;
import org.apache.xml.resolver.helpers.PublicId;
import org.apache.xml.resolver.readers.CatalogReader;
import org.apache.xml.resolver.readers.SAXCatalogReader;
import org.apache.xml.resolver.readers.TR9401CatalogReader;

public class Catalog {
    public static final int BASE = CatalogEntry.addEntryType((String)"BASE", (int)1);
    public static final int CATALOG = CatalogEntry.addEntryType((String)"CATALOG", (int)1);
    public static final int DOCUMENT = CatalogEntry.addEntryType((String)"DOCUMENT", (int)1);
    public static final int OVERRIDE = CatalogEntry.addEntryType((String)"OVERRIDE", (int)1);
    public static final int SGMLDECL = CatalogEntry.addEntryType((String)"SGMLDECL", (int)1);
    public static final int DELEGATE_PUBLIC = CatalogEntry.addEntryType((String)"DELEGATE_PUBLIC", (int)2);
    public static final int DELEGATE_SYSTEM = CatalogEntry.addEntryType((String)"DELEGATE_SYSTEM", (int)2);
    public static final int DELEGATE_URI = CatalogEntry.addEntryType((String)"DELEGATE_URI", (int)2);
    public static final int DOCTYPE = CatalogEntry.addEntryType((String)"DOCTYPE", (int)2);
    public static final int DTDDECL = CatalogEntry.addEntryType((String)"DTDDECL", (int)2);
    public static final int ENTITY = CatalogEntry.addEntryType((String)"ENTITY", (int)2);
    public static final int LINKTYPE = CatalogEntry.addEntryType((String)"LINKTYPE", (int)2);
    public static final int NOTATION = CatalogEntry.addEntryType((String)"NOTATION", (int)2);
    public static final int PUBLIC = CatalogEntry.addEntryType((String)"PUBLIC", (int)2);
    public static final int SYSTEM = CatalogEntry.addEntryType((String)"SYSTEM", (int)2);
    public static final int URI = CatalogEntry.addEntryType((String)"URI", (int)2);
    public static final int REWRITE_SYSTEM = CatalogEntry.addEntryType((String)"REWRITE_SYSTEM", (int)2);
    public static final int REWRITE_URI = CatalogEntry.addEntryType((String)"REWRITE_URI", (int)2);
    public static final int SYSTEM_SUFFIX = CatalogEntry.addEntryType((String)"SYSTEM_SUFFIX", (int)2);
    public static final int URI_SUFFIX = CatalogEntry.addEntryType((String)"URI_SUFFIX", (int)2);
    protected URL base;
    protected URL catalogCwd;
    protected AccessibleVector catalogEntries = new AccessibleVector();
    protected boolean default_override = true;
    protected CatalogManager catalogManager = CatalogManager.getStaticManager();
    protected Vector catalogFiles = new Vector();
    protected Vector localCatalogFiles = new Vector();
    protected Vector catalogs = new Vector();
    protected Vector localDelegate = new Vector();
    protected Hashtable readerMap = new Hashtable();
    protected Vector readerArr = new Vector();
    private static final boolean windows;
    private static Map<String, String> normalizedURIs;

    public Catalog() {
    }

    public Catalog(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public CatalogManager getCatalogManager() {
        return this.catalogManager;
    }

    public void setCatalogManager(CatalogManager catalogManager) {
        this.catalogManager = catalogManager;
    }

    public void setupReaders() {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(false);
        SAXCatalogReader sAXCatalogReader = new SAXCatalogReader(sAXParserFactory);
        sAXCatalogReader.setCatalogParser(null, "XCatalog", "org.apache.xml.resolver.readers.XCatalogReader");
        sAXCatalogReader.setCatalogParser("urn:oasis:names:tc:entity:xmlns:xml:catalog", "catalog", "org.apache.xml.resolver.readers.OASISXMLCatalogReader");
        this.addReader("application/xml", (CatalogReader)sAXCatalogReader);
        TR9401CatalogReader tR9401CatalogReader = new TR9401CatalogReader();
        this.addReader("text/plain", (CatalogReader)tR9401CatalogReader);
    }

    public void addReader(String string, CatalogReader catalogReader) {
        if (this.readerMap.containsKey(string)) {
            Integer n2 = (Integer)this.readerMap.get(string);
            this.readerArr.set(n2, catalogReader);
        } else {
            this.readerArr.add(catalogReader);
            Integer n3 = new Integer(this.readerArr.size() - 1);
            this.readerMap.put(string, n3);
        }
    }

    protected void copyReaders(Catalog catalog) {
        Object object;
        Vector<String> vector = new Vector<String>(this.readerMap.size());
        for (int i2 = 0; i2 < this.readerMap.size(); ++i2) {
            vector.add(null);
        }
        Enumeration enumeration = this.readerMap.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object = (Integer)this.readerMap.get(string);
            vector.set((Integer)object, string);
        }
        for (int i3 = 0; i3 < vector.size(); ++i3) {
            object = (String)vector.get(i3);
            Integer n2 = (Integer)this.readerMap.get(object);
            catalog.addReader((String)object, (CatalogReader)this.readerArr.get(n2));
        }
    }

    protected Catalog newCatalog() {
        String string = this.getClass().getName();
        try {
            Catalog catalog = (Catalog)Class.forName(string).newInstance();
            catalog.setCatalogManager(this.catalogManager);
            this.copyReaders(catalog);
            return catalog;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.catalogManager.debug.message(1, "Class Not Found Exception: " + string);
        }
        catch (IllegalAccessException illegalAccessException) {
            this.catalogManager.debug.message(1, "Illegal Access Exception: " + string);
        }
        catch (InstantiationException instantiationException) {
            this.catalogManager.debug.message(1, "Instantiation Exception: " + string);
        }
        catch (ClassCastException classCastException) {
            this.catalogManager.debug.message(1, "Class Cast Exception: " + string);
        }
        catch (Exception exception) {
            this.catalogManager.debug.message(1, "Other Exception: " + string);
        }
        Catalog catalog = new Catalog();
        catalog.setCatalogManager(this.catalogManager);
        this.copyReaders(catalog);
        return catalog;
    }

    public String getCurrentBase() {
        return this.base.toString();
    }

    public String getDefaultOverride() {
        if (this.default_override) {
            return "yes";
        }
        return "no";
    }

    public void loadSystemCatalogs() throws MalformedURLException, IOException {
        Vector vector = this.catalogManager.getCatalogFiles();
        if (vector != null) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                this.catalogFiles.addElement(vector.elementAt(i2));
            }
        }
        if (this.catalogFiles.size() > 0) {
            String string = (String)this.catalogFiles.lastElement();
            this.catalogFiles.removeElement(string);
            this.parseCatalog(string);
        }
    }

    public synchronized void parseCatalog(String string) throws MalformedURLException, IOException {
        this.default_override = this.catalogManager.getPreferPublic();
        if (this.catalogManager.debug.getDebug() >= 4) {
            this.catalogManager.debug.message(4, "Parse catalog: " + string);
        }
        this.catalogFiles.addElement(string);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(String string, InputStream inputStream) throws IOException, CatalogException {
        this.default_override = this.catalogManager.getPreferPublic();
        if (this.catalogManager.debug.getDebug() >= 4) {
            this.catalogManager.debug.message(4, "Parse " + string + " catalog on input stream");
        }
        CatalogReader catalogReader = null;
        if (this.readerMap.containsKey(string)) {
            int n2 = (Integer)this.readerMap.get(string);
            catalogReader = (CatalogReader)this.readerArr.get(n2);
        }
        if (catalogReader == null) {
            String string2 = "No CatalogReader for MIME type: " + string;
            this.catalogManager.debug.message(2, string2);
            throw new CatalogException(6, string2);
        }
        catalogReader.readCatalog(this, inputStream);
        this.parsePendingCatalogs();
    }

    public synchronized void parseCatalog(URL uRL) throws IOException {
        this.catalogCwd = uRL;
        this.base = uRL;
        this.default_override = this.catalogManager.getPreferPublic();
        if (this.catalogManager.debug.getDebug() >= 4) {
            this.catalogManager.debug.message(4, "Parse catalog: " + uRL.toString());
        }
        DataInputStream dataInputStream = null;
        boolean bl = false;
        for (int i2 = 0; !bl && i2 < this.readerArr.size(); ++i2) {
            CatalogReader catalogReader = (CatalogReader)this.readerArr.get(i2);
            try {
                dataInputStream = new DataInputStream(uRL.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                break;
            }
            try {
                catalogReader.readCatalog(this, (InputStream)dataInputStream);
                bl = true;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 7) break;
            }
            try {
                dataInputStream.close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (bl) {
            this.parsePendingCatalogs();
        }
    }

    protected synchronized void parsePendingCatalogs() throws MalformedURLException, IOException {
        Enumeration<Object> enumeration;
        Object object;
        if (!this.localCatalogFiles.isEmpty()) {
            object = new Vector();
            enumeration = this.localCatalogFiles.elements();
            while (enumeration.hasMoreElements()) {
                ((Vector)object).addElement(enumeration.nextElement());
            }
            for (int i2 = 0; i2 < this.catalogFiles.size(); ++i2) {
                String string = (String)this.catalogFiles.elementAt(i2);
                ((Vector)object).addElement(string);
            }
            this.catalogFiles = object;
            this.localCatalogFiles.clear();
        }
        if (this.catalogFiles.isEmpty() && !this.localDelegate.isEmpty()) {
            object = this.localDelegate.elements();
            while (object.hasMoreElements()) {
                this.catalogEntries.addElement(object.nextElement());
            }
            this.localDelegate.clear();
        }
        while (!this.catalogFiles.isEmpty()) {
            object = (String)this.catalogFiles.elementAt(0);
            try {
                this.catalogFiles.remove(0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (this.catalogEntries.size() == 0 && this.catalogs.size() == 0) {
                try {
                    this.parseCatalogFile((String)object);
                }
                catch (CatalogException catalogException) {
                    System.out.println("FIXME: " + catalogException.toString());
                }
            } else {
                this.catalogs.addElement(object);
            }
            if (!this.localCatalogFiles.isEmpty()) {
                enumeration = new Vector();
                Enumeration enumeration2 = this.localCatalogFiles.elements();
                while (enumeration2.hasMoreElements()) {
                    ((Vector)((Object)enumeration)).addElement(enumeration2.nextElement());
                }
                for (int i3 = 0; i3 < this.catalogFiles.size(); ++i3) {
                    object = (String)this.catalogFiles.elementAt(i3);
                    ((Vector)((Object)enumeration)).addElement(object);
                }
                this.catalogFiles = enumeration;
                this.localCatalogFiles.clear();
            }
            if (this.localDelegate.isEmpty()) continue;
            enumeration = this.localDelegate.elements();
            while (enumeration.hasMoreElements()) {
                this.catalogEntries.addElement(enumeration.nextElement());
            }
            this.localDelegate.clear();
        }
        this.catalogFiles.clear();
    }

    protected synchronized void parseCatalogFile(String string) throws MalformedURLException, IOException, CatalogException {
        Object object;
        boolean bl = false;
        try {
            this.base = new URL(string);
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (!bl && ((File)(object = new File(string))).exists()) {
            try {
                this.base = ((File)object).toURL();
                bl = true;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!bl) {
            try {
                this.catalogCwd = FileURL.makeURL((String)"basename");
            }
            catch (MalformedURLException malformedURLException) {
                String string2 = System.getProperty("user.dir");
                string2 = string2.replace('\\', '/');
                this.catalogManager.debug.message(1, "Malformed URL on cwd", string2);
                this.catalogCwd = null;
            }
            try {
                this.base = new URL(this.catalogCwd, this.fixSlashes(string));
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    this.base = new URL("file:" + this.fixSlashes(string));
                }
                catch (MalformedURLException malformedURLException2) {
                    this.catalogManager.debug.message(1, "Malformed URL on catalog filename", this.fixSlashes(string));
                    this.base = null;
                }
            }
        }
        this.catalogManager.debug.message(2, "Loading catalog", string);
        this.catalogManager.debug.message(4, "Default BASE", this.base.toString());
        string = this.base.toString();
        object = null;
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i2 = 0; !bl2 && i2 < this.readerArr.size(); ++i2) {
            CatalogReader catalogReader = (CatalogReader)this.readerArr.get(i2);
            try {
                bl3 = false;
                object = new DataInputStream(this.base.openStream());
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl3 = true;
                break;
            }
            try {
                catalogReader.readCatalog(this, (InputStream)object);
                bl2 = true;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 7) break;
            }
            try {
                ((FilterInputStream)object).close();
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (!bl2) {
            if (bl3) {
                this.catalogManager.debug.message(3, "Catalog does not exist", string);
            } else {
                this.catalogManager.debug.message(1, "Failed to parse catalog", string);
            }
        }
    }

    public void addEntry(CatalogEntry catalogEntry) {
        int n2 = catalogEntry.getEntryType();
        if (n2 == BASE) {
            String string = catalogEntry.getEntryArg(0);
            URL uRL = null;
            if (this.base == null) {
                this.catalogManager.debug.message(5, "BASE CUR", "null");
            } else {
                this.catalogManager.debug.message(5, "BASE CUR", this.base.toString());
            }
            this.catalogManager.debug.message(4, "BASE STR", string);
            try {
                string = this.fixSlashes(string);
                uRL = new URL(this.base, string);
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    uRL = new URL("file:" + string);
                }
                catch (MalformedURLException malformedURLException2) {
                    this.catalogManager.debug.message(1, "Malformed URL on base", string);
                    uRL = null;
                }
            }
            if (uRL != null) {
                this.base = uRL;
            }
            this.catalogManager.debug.message(5, "BASE NEW", this.base.toString());
        } else if (n2 == CATALOG) {
            String string = catalogEntry.getEntryArg(0);
            if (string != null && string.trim().length() > 0) {
                String string2 = this.makeAbsolute(catalogEntry.getEntryArg(0));
                this.catalogManager.debug.message(4, "CATALOG", string2);
                this.localCatalogFiles.addElement(string2);
            }
        } else if (n2 == PUBLIC) {
            String string = PublicId.normalize((String)catalogEntry.getEntryArg(0));
            String string3 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string3);
            this.catalogManager.debug.message(4, "PUBLIC", string, string3);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == SYSTEM) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string4 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string4);
            this.catalogManager.debug.message(4, "SYSTEM", string, string4);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == URI) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string5 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string5);
            this.catalogManager.debug.message(4, "URI", string, string5);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DOCUMENT) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(0)));
            catalogEntry.setEntryArg(0, string);
            this.catalogManager.debug.message(4, "DOCUMENT", string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == OVERRIDE) {
            this.catalogManager.debug.message(4, "OVERRIDE", catalogEntry.getEntryArg(0));
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == SGMLDECL) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(0)));
            catalogEntry.setEntryArg(0, string);
            this.catalogManager.debug.message(4, "SGMLDECL", string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DELEGATE_PUBLIC) {
            String string = PublicId.normalize((String)catalogEntry.getEntryArg(0));
            String string6 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string6);
            this.catalogManager.debug.message(4, "DELEGATE_PUBLIC", string, string6);
            this.addDelegate(catalogEntry);
        } else if (n2 == DELEGATE_SYSTEM) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string7 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string7);
            this.catalogManager.debug.message(4, "DELEGATE_SYSTEM", string, string7);
            this.addDelegate(catalogEntry);
        } else if (n2 == DELEGATE_URI) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string8 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string8);
            this.catalogManager.debug.message(4, "DELEGATE_URI", string, string8);
            this.addDelegate(catalogEntry);
        } else if (n2 == REWRITE_SYSTEM) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string9 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string9);
            this.catalogManager.debug.message(4, "REWRITE_SYSTEM", string, string9);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == REWRITE_URI) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string10 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string10);
            this.catalogManager.debug.message(4, "REWRITE_URI", string, string10);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == SYSTEM_SUFFIX) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string11 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string11);
            this.catalogManager.debug.message(4, "SYSTEM_SUFFIX", string, string11);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == URI_SUFFIX) {
            String string = this.normalizeURI(catalogEntry.getEntryArg(0));
            String string12 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(0, string);
            catalogEntry.setEntryArg(1, string12);
            this.catalogManager.debug.message(4, "URI_SUFFIX", string, string12);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DOCTYPE) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "DOCTYPE", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == DTDDECL) {
            String string = PublicId.normalize((String)catalogEntry.getEntryArg(0));
            catalogEntry.setEntryArg(0, string);
            String string13 = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string13);
            this.catalogManager.debug.message(4, "DTDDECL", string, string13);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == ENTITY) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "ENTITY", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == LINKTYPE) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "LINKTYPE", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else if (n2 == NOTATION) {
            String string = this.makeAbsolute(this.normalizeURI(catalogEntry.getEntryArg(1)));
            catalogEntry.setEntryArg(1, string);
            this.catalogManager.debug.message(4, "NOTATION", catalogEntry.getEntryArg(0), string);
            this.catalogEntries.addElement(catalogEntry);
        } else {
            this.catalogEntries.addElement(catalogEntry);
        }
    }

    public void unknownEntry(Vector vector) {
        if (vector != null && vector.size() > 0) {
            String string = (String)vector.elementAt(0);
            this.catalogManager.debug.message(2, "Unrecognized token parsing catalog", string);
        }
    }

    public void parseAllCatalogs() throws MalformedURLException, IOException {
        Catalog catalog;
        for (int i2 = 0; i2 < this.catalogs.size(); ++i2) {
            catalog = null;
            try {
                catalog = (Catalog)this.catalogs.elementAt(i2);
                continue;
            }
            catch (ClassCastException classCastException) {
                String string = (String)this.catalogs.elementAt(i2);
                catalog = this.newCatalog();
                catalog.parseCatalog(string);
                this.catalogs.setElementAt(catalog, i2);
                catalog.parseAllCatalogs();
            }
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            catalog = (CatalogEntry)enumeration.nextElement();
            if (catalog.getEntryType() != DELEGATE_PUBLIC && catalog.getEntryType() != DELEGATE_SYSTEM && catalog.getEntryType() != DELEGATE_URI) continue;
            Catalog catalog2 = this.newCatalog();
            catalog2.parseCatalog(catalog.getEntryArg(1));
        }
    }

    public String resolveDoctype(String string, String string2, String string3) throws MalformedURLException, IOException {
        String string4 = null;
        if (this.catalogManager.debug.getDebug() >= 3) {
            this.catalogManager.debug.message(3, "resolveDoctype(" + string + "," + string2 + "," + string3 + ")");
        }
        string3 = this.normalizeURI(string3);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN((String)string2);
        }
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN((String)string3);
            if (string2 != null && !string2.equals(string3)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string3 = null;
            } else {
                string2 = string3;
                string3 = null;
            }
        }
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        if (string2 != null && (string4 = this.resolveLocalPublic(DOCTYPE, string, string2, string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != DOCTYPE || !catalogEntry.getEntryArg(0).equals(string) || !bl && string3 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(DOCTYPE, string, string2, string3);
    }

    public String resolveDocument() throws MalformedURLException, IOException {
        if (this.catalogManager.debug.getDebug() >= 3) {
            this.catalogManager.debug.message(3, "resolveDocument");
        }
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() != DOCUMENT) continue;
            return catalogEntry.getEntryArg(0);
        }
        return this.resolveSubordinateCatalogs(DOCUMENT, null, null, null);
    }

    public String resolveEntity(String string, String string2, String string3) throws MalformedURLException, IOException {
        String string4 = null;
        if (this.catalogManager.debug.getDebug() >= 3) {
            this.catalogManager.debug.message(3, "resolveEntity(" + string + "," + string2 + "," + string3 + ")");
        }
        string3 = this.normalizeURI(string3);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN((String)string2);
        }
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN((String)string3);
            if (string2 != null && !string2.equals(string3)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string3 = null;
            } else {
                string2 = string3;
                string3 = null;
            }
        }
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        if (string2 != null && (string4 = this.resolveLocalPublic(ENTITY, string, string2, string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != ENTITY || !catalogEntry.getEntryArg(0).equals(string) || !bl && string3 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(ENTITY, string, string2, string3);
    }

    public String resolveNotation(String string, String string2, String string3) throws MalformedURLException, IOException {
        String string4 = null;
        if (this.catalogManager.debug.getDebug() >= 3) {
            this.catalogManager.debug.message(3, "resolveNotation(" + string + "," + string2 + "," + string3 + ")");
        }
        string3 = this.normalizeURI(string3);
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN((String)string2);
        }
        if (string3 != null && string3.startsWith("urn:publicid:")) {
            string3 = PublicId.decodeURN((String)string3);
            if (string2 != null && !string2.equals(string3)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string3 = null;
            } else {
                string2 = string3;
                string3 = null;
            }
        }
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        if (string2 != null && (string4 = this.resolveLocalPublic(NOTATION, string, string2, string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        Enumeration enumeration = this.catalogEntries.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry = (CatalogEntry)enumeration.nextElement();
            if (catalogEntry.getEntryType() == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.getEntryType() != NOTATION || !catalogEntry.getEntryArg(0).equals(string) || !bl && string3 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        return this.resolveSubordinateCatalogs(NOTATION, string, string2, string3);
    }

    public String resolvePublic(String string, String string2) throws MalformedURLException, IOException {
        String string3;
        if (this.catalogManager.debug.getDebug() >= 3) {
            this.catalogManager.debug.message(3, "resolvePublic(" + string + "," + string2 + ")");
        }
        string2 = this.normalizeURI(string2);
        if (string != null && string.startsWith("urn:publicid:")) {
            string = PublicId.decodeURN((String)string);
        }
        if (string2 != null && string2.startsWith("urn:publicid:")) {
            string2 = PublicId.decodeURN((String)string2);
            if (string != null && !string.equals(string2)) {
                this.catalogManager.debug.message(1, "urn:publicid: system identifier differs from public identifier; using public identifier");
                string2 = null;
            } else {
                string = string2;
                string2 = null;
            }
        }
        if (string2 != null && (string3 = this.resolveLocalSystem(string2)) != null) {
            return string3;
        }
        string3 = this.resolveLocalPublic(PUBLIC, null, string, string2);
        if (string3 != null) {
            return string3;
        }
        return this.resolveSubordinateCatalogs(PUBLIC, null, string, string2);
    }

    protected synchronized String resolveLocalPublic(int n2, String string, String string2, String string3) throws MalformedURLException, IOException {
        int n3;
        String string4;
        Object[] objectArray = this.catalogEntries.getElementData();
        int n4 = this.catalogEntries.size();
        string2 = PublicId.normalize((String)string2);
        if (string3 != null && (string4 = this.resolveLocalSystem(string3)) != null) {
            return string4;
        }
        boolean bl = this.default_override;
        for (int i2 = 0; i2 < n4; ++i2) {
            CatalogEntry catalogEntry = (CatalogEntry)objectArray[i2];
            if (catalogEntry.entryType == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.entryType != PUBLIC || !catalogEntry.getEntryArg(0).equals(string2) || !bl && string3 != null) continue;
            return catalogEntry.getEntryArg(1);
        }
        bl = this.default_override;
        Vector<String> vector = new Vector<String>();
        for (n3 = 0; n3 < n4; ++n3) {
            String string5;
            int n5;
            CatalogEntry catalogEntry = (CatalogEntry)objectArray[n3];
            if (catalogEntry.entryType == OVERRIDE) {
                bl = catalogEntry.getEntryArg(0).equalsIgnoreCase("YES");
                continue;
            }
            if (catalogEntry.entryType != DELEGATE_PUBLIC || !bl && string3 != null || (n5 = (string5 = catalogEntry.getEntryArg(0)).length()) > string2.length() || !string5.equals(string2.substring(0, n5))) continue;
            vector.addElement(catalogEntry.getEntryArg(1));
        }
        n3 = vector.size();
        if (n3 > 0) {
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                for (int i3 = 0; i3 < n3; ++i3) {
                    this.catalogManager.debug.message(2, "\t" + vector.get(i3));
                }
            }
            Catalog catalog = this.newCatalog();
            for (int i4 = 0; i4 < n3; ++i4) {
                catalog.parseCatalog((String)vector.get(i4));
            }
            return catalog.resolvePublic(string2, null);
        }
        return null;
    }

    public String resolveSystem(String string) throws MalformedURLException, IOException {
        String string2;
        if (this.catalogManager.debug.getDebug() >= 3) {
            this.catalogManager.debug.message(3, "resolveSystem(" + string + ")");
        }
        if ((string = this.normalizeURI(string)) != null && string.startsWith("urn:publicid:")) {
            string = PublicId.decodeURN((String)string);
            return this.resolvePublic(string, null);
        }
        if (string != null && (string2 = this.resolveLocalSystem(string)) != null) {
            return string2;
        }
        return this.resolveSubordinateCatalogs(SYSTEM, null, null, string);
    }

    protected String resolveLocalSystem(String string) throws MalformedURLException, IOException {
        int n2;
        String string2;
        Object object;
        Object object2;
        int n3 = this.catalogEntries.size();
        Object[] objectArray = this.catalogEntries.getElementData();
        for (int i2 = 0; i2 < n3; ++i2) {
            object2 = (CatalogEntry)objectArray[i2];
            String string3 = object2.getEntryArg(0);
            if (object2.entryType != SYSTEM || !string3.equals(string) && (!windows || !string3.equalsIgnoreCase(string))) continue;
            return object2.getEntryArg(1);
        }
        String string4 = null;
        object2 = null;
        for (int i3 = 0; i3 < n3; ++i3) {
            String string5;
            int n4;
            object = (CatalogEntry)objectArray[i3];
            if (object.entryType != REWRITE_SYSTEM || (n4 = (string5 = object.getEntryArg(0)).length()) > string.length() || !string5.equals(string.substring(0, n4)) || string4 != null && n4 <= string4.length()) continue;
            string4 = string5;
            object2 = object.getEntryArg(1);
        }
        if (object2 != null) {
            return (String)object2 + string.substring(string4.length());
        }
        String string6 = null;
        object = null;
        for (int i4 = 0; i4 < n3; ++i4) {
            int n5;
            CatalogEntry catalogEntry = (CatalogEntry)objectArray[i4];
            if (catalogEntry.entryType != SYSTEM_SUFFIX || (n5 = (string2 = catalogEntry.getEntryArg(0)).length()) > string.length() || !string.endsWith(string2) || string6 != null && n5 <= string6.length()) continue;
            string6 = string2;
            object = catalogEntry.getEntryArg(1);
        }
        if (object != null) {
            return object;
        }
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; n2 < n3; ++n2) {
            String string7;
            int n6;
            string2 = (CatalogEntry)objectArray[n2];
            if (((CatalogEntry)string2).entryType != DELEGATE_SYSTEM || (n6 = (string7 = string2.getEntryArg(0)).length()) > string.length() || !string7.equals(string.substring(0, n6))) continue;
            String string8 = string2.getEntryArg(1);
            if (this.base != null && this.base.toString().equals(string8)) continue;
            vector.addElement(string8);
        }
        n2 = vector.size();
        if (n2 > 0) {
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                for (int i5 = 0; i5 < n2; ++i5) {
                    this.catalogManager.debug.message(2, "\t" + vector.get(i5));
                }
            }
            Catalog catalog = this.newCatalog();
            for (int i6 = 0; i6 < n2; ++i6) {
                catalog.parseCatalog((String)vector.get(i6));
            }
            return catalog.resolveSystem(string);
        }
        return null;
    }

    public String resolveURI(String string) throws MalformedURLException, IOException {
        String string2;
        if (this.catalogManager.debug.getDebug() >= 3) {
            this.catalogManager.debug.message(3, "resolveURI(" + string + ")");
        }
        if ((string = this.normalizeURI(string)) != null && string.startsWith("urn:publicid:")) {
            string = PublicId.decodeURN((String)string);
            return this.resolvePublic(string, null);
        }
        if (string != null && (string2 = this.resolveLocalURI(string)) != null) {
            return string2;
        }
        return this.resolveSubordinateCatalogs(URI, null, null, string);
    }

    protected String resolveLocalURI(String string) throws MalformedURLException, IOException {
        int n2;
        String string2;
        Object object;
        Object object2;
        Object[] objectArray = this.catalogEntries.getElementData();
        int n3 = this.catalogEntries.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            object2 = (CatalogEntry)objectArray[i2];
            if (object2.entryType != URI || !object2.getEntryArg(0).equals(string)) continue;
            return object2.getEntryArg(1);
        }
        String string3 = null;
        object2 = null;
        for (int i3 = 0; i3 < n3; ++i3) {
            String string4;
            int n4;
            object = (CatalogEntry)objectArray[i3];
            if (object.entryType != REWRITE_URI || (n4 = (string4 = object.getEntryArg(0)).length()) > string.length() || !string4.equals(string.substring(0, n4)) || string3 != null && n4 <= string3.length()) continue;
            string3 = string4;
            object2 = object.getEntryArg(1);
        }
        if (object2 != null) {
            return (String)object2 + string.substring(string3.length());
        }
        String string5 = null;
        object = null;
        for (int i4 = 0; i4 < n3; ++i4) {
            int n5;
            CatalogEntry catalogEntry = (CatalogEntry)objectArray[i4];
            if (catalogEntry.entryType != URI_SUFFIX || (n5 = (string2 = catalogEntry.getEntryArg(0)).length()) > string.length() || !string.endsWith(string2) || string5 != null && n5 <= string5.length()) continue;
            string5 = string2;
            object = catalogEntry.getEntryArg(1);
        }
        if (object != null) {
            return object;
        }
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; n2 < n3; ++n2) {
            String string6;
            int n6;
            string2 = (CatalogEntry)objectArray[n2];
            if (string2.getEntryType() != DELEGATE_URI || (n6 = (string6 = string2.getEntryArg(0)).length()) > string.length() || !string6.equals(string.substring(0, n6))) continue;
            vector.addElement(string2.getEntryArg(1));
        }
        n2 = vector.size();
        if (n2 > 0) {
            if (this.catalogManager.debug.getDebug() > 1) {
                this.catalogManager.debug.message(2, "Switching to delegated catalog(s):");
                for (int i5 = 0; i5 < n2; ++i5) {
                    this.catalogManager.debug.message(2, "\t" + vector.get(i5));
                }
            }
            Catalog catalog = this.newCatalog();
            for (int i6 = 0; i6 < n2; ++i6) {
                catalog.parseCatalog((String)vector.get(i6));
            }
            return catalog.resolveURI(string);
        }
        return null;
    }

    protected synchronized String resolveSubordinateCatalogs(int n2, String string, String string2, String string3) throws MalformedURLException, IOException {
        for (int i2 = 0; i2 < this.catalogs.size(); ++i2) {
            Catalog catalog = null;
            try {
                catalog = (Catalog)this.catalogs.elementAt(i2);
            }
            catch (ClassCastException classCastException) {
                String string4 = (String)this.catalogs.elementAt(i2);
                catalog = this.newCatalog();
                try {
                    catalog.parseCatalog(string4);
                }
                catch (MalformedURLException malformedURLException) {
                    this.catalogManager.debug.message(1, "Malformed Catalog URL", string4);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, file not found", string4);
                }
                catch (IOException iOException) {
                    this.catalogManager.debug.message(1, "Failed to load catalog, I/O error", string4);
                }
                this.catalogs.setElementAt(catalog, i2);
            }
            String string5 = null;
            if (n2 == DOCTYPE) {
                string5 = catalog.resolveDoctype(string, string2, string3);
            } else if (n2 == DOCUMENT) {
                string5 = catalog.resolveDocument();
            } else if (n2 == ENTITY) {
                string5 = catalog.resolveEntity(string, string2, string3);
            } else if (n2 == NOTATION) {
                string5 = catalog.resolveNotation(string, string2, string3);
            } else if (n2 == PUBLIC) {
                string5 = catalog.resolvePublic(string2, string3);
            } else if (n2 == SYSTEM) {
                string5 = catalog.resolveSystem(string3);
            } else if (n2 == URI) {
                string5 = catalog.resolveURI(string3);
            }
            if (string5 == null) continue;
            return string5;
        }
        return null;
    }

    protected String fixSlashes(String string) {
        return string.replace('\\', '/');
    }

    protected String makeAbsolute(String string) {
        URL uRL = null;
        string = this.fixSlashes(string);
        try {
            uRL = new URL(this.base, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.catalogManager.debug.message(1, "Malformed URL on system identifier", string);
        }
        if (uRL != null) {
            return uRL.toString();
        }
        return string;
    }

    protected String normalizeURI(String string) {
        byte[] byArray;
        String string2;
        if (normalizedURIs.size() > 1000) {
            normalizedURIs.clear();
        }
        if ((string2 = normalizedURIs.get(string)) != null) {
            return string2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string == null) {
            return null;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.catalogManager.debug.message(1, "UTF-8 is an unsupported encoding!?");
            return string;
        }
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            if (n2 <= 32 || n2 > 127 || n2 == 34 || n2 == 60 || n2 == 62 || n2 == 92 || n2 == 94 || n2 == 96 || n2 == 123 || n2 == 124 || n2 == 125 || n2 == 127) {
                stringBuilder.append(this.encodedByte(n2));
                continue;
            }
            stringBuilder.append((char)byArray[i2]);
        }
        String string3 = stringBuilder.toString();
        normalizedURIs.put(string, string3);
        return string3;
    }

    protected String encodedByte(int n2) {
        String string = Integer.toHexString(n2).toUpperCase();
        if (string.length() < 2) {
            return "%0" + string;
        }
        return "%" + string;
    }

    protected void addDelegate(CatalogEntry catalogEntry) {
        int n2 = 0;
        String string = catalogEntry.getEntryArg(0);
        Enumeration enumeration = this.localDelegate.elements();
        while (enumeration.hasMoreElements()) {
            CatalogEntry catalogEntry2 = (CatalogEntry)enumeration.nextElement();
            String string2 = catalogEntry2.getEntryArg(0);
            if (string2.equals(string)) {
                return;
            }
            if (string2.length() > string.length()) {
                ++n2;
            }
            if (string2.length() >= string.length()) continue;
            break;
        }
        if (this.localDelegate.size() == 0) {
            this.localDelegate.addElement(catalogEntry);
        } else {
            this.localDelegate.insertElementAt(catalogEntry, n2);
        }
    }

    static {
        String string = System.getProperty("os.name");
        windows = string.indexOf("Windows") >= 0;
        normalizedURIs = Collections.synchronizedMap(new HashMap());
    }

    private static class AccessibleVector
    extends Vector {
        private AccessibleVector() {
        }

        public Object[] getElementData() {
            return this.elementData;
        }
    }
}

