/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.xpointer;

import java.util.ArrayList;
import java.util.HashMap;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xinclude.XIncludeHandler;
import org.apache.xerces.xinclude.XIncludeNamespaceSupport;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLErrorHandler;
import org.apache.xerces.xpointer.ElementSchemePointer;
import org.apache.xerces.xpointer.ShortHandPointer;
import org.apache.xerces.xpointer.XPointerErrorHandler;
import org.apache.xerces.xpointer.XPointerMessageFormatter;
import org.apache.xerces.xpointer.XPointerPart;
import org.apache.xerces.xpointer.XPointerProcessor;

public final class XPointerHandler
extends XIncludeHandler
implements XPointerProcessor {
    protected ArrayList fXPointerParts = new ArrayList();
    protected XPointerPart fXPointerPart = null;
    protected boolean fFoundMatchingPtrPart = false;
    protected XMLErrorReporter fXPointerErrorReporter;
    protected XMLErrorHandler fErrorHandler;
    protected SymbolTable fSymbolTable = null;
    private final String ELEMENT_SCHEME_NAME = "element";
    protected boolean fIsXPointerResolved = false;
    protected boolean fFixupBase = false;
    protected boolean fFixupLang = false;
    int fActualDepth = 0x3FFFFFFF;

    public XPointerHandler() {
        this.fSymbolTable = new SymbolTable();
    }

    public XPointerHandler(SymbolTable symbolTable, XMLErrorHandler xMLErrorHandler, XMLErrorReporter xMLErrorReporter) {
        this.fSymbolTable = symbolTable;
        this.fErrorHandler = xMLErrorHandler;
        this.fXPointerErrorReporter = xMLErrorReporter;
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public void parseXPointer(String string) throws XNIException {
        this.init();
        Tokens tokens = new Tokens(this.fSymbolTable);
        Scanner scanner = new Scanner(this.fSymbolTable){

            @Override
            protected void addToken(Tokens tokens, int n2) throws XNIException {
                if (n2 == 0 || n2 == 1 || n2 == 3 || n2 == 4 || n2 == 2) {
                    super.addToken(tokens, n2);
                    return;
                }
                XPointerHandler.this.reportError("InvalidXPointerToken", new Object[]{tokens.getTokenString(n2)});
            }
        };
        int n2 = string.length();
        boolean bl = scanner.scanExpr(this.fSymbolTable, tokens, string, 0, n2);
        if (!bl) {
            this.reportError("InvalidXPointerExpression", new Object[]{string});
        }
        while (tokens.hasMore()) {
            int n3 = tokens.nextToken();
            switch (n3) {
                case 2: {
                    n3 = tokens.nextToken();
                    String string2 = tokens.getTokenString(n3);
                    if (string2 == null) {
                        this.reportError("InvalidXPointerExpression", new Object[]{string});
                    }
                    Object object = new ShortHandPointer(this.fSymbolTable);
                    object.setSchemeName(string2);
                    this.fXPointerParts.add(object);
                    break;
                }
                case 3: {
                    n3 = tokens.nextToken();
                    String string2 = tokens.getTokenString(n3);
                    n3 = tokens.nextToken();
                    Object object = tokens.getTokenString(n3);
                    String string3 = string2 + (String)object;
                    int n4 = 0;
                    int n5 = 0;
                    n3 = tokens.nextToken();
                    String string4 = tokens.getTokenString(n3);
                    if (string4 != "XPTRTOKEN_OPEN_PAREN") {
                        if (n3 == 2) {
                            this.reportError("MultipleShortHandPointers", new Object[]{string});
                        } else {
                            this.reportError("InvalidXPointerExpression", new Object[]{string});
                        }
                    }
                    ++n4;
                    String string5 = null;
                    while (tokens.hasMore() && (string5 = tokens.getTokenString(n3 = tokens.nextToken())) == "XPTRTOKEN_OPEN_PAREN") {
                        ++n4;
                    }
                    n3 = tokens.nextToken();
                    string5 = tokens.getTokenString(n3);
                    n3 = tokens.nextToken();
                    String string6 = tokens.getTokenString(n3);
                    if (string6 != "XPTRTOKEN_CLOSE_PAREN") {
                        this.reportError("SchemeDataNotFollowedByCloseParenthesis", new Object[]{string});
                    }
                    ++n5;
                    while (tokens.hasMore() && tokens.getTokenString(tokens.peekToken()) == "XPTRTOKEN_OPEN_PAREN") {
                        ++n5;
                    }
                    if (n4 != n5) {
                        this.reportError("UnbalancedParenthesisInXPointerExpression", new Object[]{string, new Integer(n4), new Integer(n5)});
                    }
                    if (string3.equals("element")) {
                        ElementSchemePointer elementSchemePointer = new ElementSchemePointer(this.fSymbolTable, this.fErrorReporter);
                        elementSchemePointer.setSchemeName(string3);
                        elementSchemePointer.setSchemeData(string5);
                        try {
                            elementSchemePointer.parseXPointer(string5);
                            this.fXPointerParts.add(elementSchemePointer);
                            break;
                        }
                        catch (XNIException xNIException) {
                            throw new XNIException((Exception)((Object)xNIException));
                        }
                    }
                    this.reportWarning("SchemeUnsupported", new Object[]{string3});
                    break;
                }
                default: {
                    this.reportError("InvalidXPointerExpression", new Object[]{string});
                }
            }
        }
    }

    public boolean resolveXPointer(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, int n2) throws XNIException {
        boolean bl = false;
        if (!this.fFoundMatchingPtrPart) {
            for (int i2 = 0; i2 < this.fXPointerParts.size(); ++i2) {
                this.fXPointerPart = (XPointerPart)this.fXPointerParts.get(i2);
                if (!this.fXPointerPart.resolveXPointer(qName, xMLAttributes, augmentations, n2)) continue;
                this.fFoundMatchingPtrPart = true;
                bl = true;
            }
        } else if (this.fXPointerPart.resolveXPointer(qName, xMLAttributes, augmentations, n2)) {
            bl = true;
        }
        if (!this.fIsXPointerResolved) {
            this.fIsXPointerResolved = bl;
        }
        return bl;
    }

    public boolean isFragmentResolved() throws XNIException {
        boolean bl;
        boolean bl2 = bl = this.fXPointerPart != null ? this.fXPointerPart.isFragmentResolved() : false;
        if (!this.fIsXPointerResolved) {
            this.fIsXPointerResolved = bl;
        }
        return bl;
    }

    public boolean isChildFragmentResolved() throws XNIException {
        boolean bl = this.fXPointerPart != null ? this.fXPointerPart.isChildFragmentResolved() : false;
        return bl;
    }

    public boolean isXPointerResolved() throws XNIException {
        return this.fIsXPointerResolved;
    }

    public XPointerPart getXPointerPart() {
        return this.fXPointerPart;
    }

    private void reportError(String string, Object[] objectArray) throws XNIException {
        throw new XNIException(this.fErrorReporter.getMessageFormatter("http://www.w3.org/TR/XPTR").formatMessage(this.fErrorReporter.getLocale(), string, objectArray));
    }

    private void reportWarning(String string, Object[] objectArray) throws XNIException {
        this.fXPointerErrorReporter.reportError("http://www.w3.org/TR/XPTR", string, objectArray, (short)0);
    }

    protected void initErrorReporter() {
        if (this.fXPointerErrorReporter == null) {
            this.fXPointerErrorReporter = new XMLErrorReporter();
        }
        if (this.fErrorHandler == null) {
            this.fErrorHandler = new XPointerErrorHandler();
        }
        this.fXPointerErrorReporter.putMessageFormatter("http://www.w3.org/TR/XPTR", (MessageFormatter)new XPointerMessageFormatter());
    }

    protected void init() {
        this.fXPointerParts.clear();
        this.fXPointerPart = null;
        this.fFoundMatchingPtrPart = false;
        this.fIsXPointerResolved = false;
        this.initErrorReporter();
    }

    public ArrayList getPointerParts() {
        return this.fXPointerParts;
    }

    @Override
    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.comment(xMLString, augmentations);
    }

    @Override
    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.processingInstruction(string, xMLString, augmentations);
    }

    @Override
    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (!this.resolveXPointer(qName, xMLAttributes, augmentations, 0)) {
            int n2 = this.fDepth;
            if (this.fFixupBase || this.fFixupLang) {
                ++this.fActualDepth;
                this.fDepth = this.fActualDepth;
            }
            if (this.fFixupBase) {
                this.processXMLBaseAttributes(xMLAttributes);
            }
            if (this.fFixupLang) {
                this.processXMLLangAttributes(xMLAttributes);
            }
            if (this.fFixupBase || this.fFixupLang) {
                this.fDepth = n2;
            }
            this.fNamespaceContext.setContextInvalid();
            return;
        }
        super.startElement(qName, xMLAttributes, augmentations);
    }

    @Override
    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (!this.resolveXPointer(qName, xMLAttributes, augmentations, 2)) {
            this.fNamespaceContext.setContextInvalid();
            return;
        }
        super.emptyElement(qName, xMLAttributes, augmentations);
    }

    @Override
    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.characters(xMLString, augmentations);
    }

    @Override
    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.ignorableWhitespace(xMLString, augmentations);
    }

    @Override
    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (!this.resolveXPointer(qName, null, augmentations, 1)) {
            if (this.fFixupBase || this.fFixupLang) {
                if (this.fBaseURIScope.size() > 0 && this.fActualDepth == this.fBaseURIScope.peek()) {
                    this.restoreBaseURI();
                }
                if (this.fLanguageScope.size() > 0 && this.fActualDepth == this.fLanguageScope.peek()) {
                    this.fCurrentLanguage = this.restoreLanguage();
                }
                --this.fActualDepth;
            }
            return;
        }
        super.endElement(qName, augmentations);
    }

    @Override
    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.startCDATA(augmentations);
    }

    @Override
    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
    }

    @Override
    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.endGeneralEntity(string, augmentations);
    }

    @Override
    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (!this.isChildFragmentResolved()) {
            return;
        }
        super.endCDATA(augmentations);
    }

    @Override
    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string == "http://apache.org/xml/properties/internal/error-reporter") {
            this.fXPointerErrorReporter = object != null ? (XMLErrorReporter)object : null;
        }
        if (string == "http://apache.org/xml/properties/internal/error-handler") {
            this.fErrorHandler = object != null ? (XMLErrorHandler)object : null;
        }
        if (string == "http://apache.org/xml/features/xinclude/fixup-language") {
            this.fFixupLang = object != null ? (Boolean)object : false;
        }
        if (string == "http://apache.org/xml/features/xinclude/fixup-base-uris") {
            this.fFixupBase = object != null ? (Boolean)object : false;
        }
        if (string == "http://apache.org/xml/properties/internal/namespace-context") {
            this.fNamespaceContext = (XIncludeNamespaceSupport)object;
        }
        super.setProperty(string, object);
    }

    private class Scanner {
        private static final byte CHARTYPE_INVALID = 0;
        private static final byte CHARTYPE_OTHER = 1;
        private static final byte CHARTYPE_WHITESPACE = 2;
        private static final byte CHARTYPE_CARRET = 3;
        private static final byte CHARTYPE_OPEN_PAREN = 4;
        private static final byte CHARTYPE_CLOSE_PAREN = 5;
        private static final byte CHARTYPE_MINUS = 6;
        private static final byte CHARTYPE_PERIOD = 7;
        private static final byte CHARTYPE_SLASH = 8;
        private static final byte CHARTYPE_DIGIT = 9;
        private static final byte CHARTYPE_COLON = 10;
        private static final byte CHARTYPE_EQUAL = 11;
        private static final byte CHARTYPE_LETTER = 12;
        private static final byte CHARTYPE_UNDERSCORE = 13;
        private static final byte CHARTYPE_NONASCII = 14;
        private final byte[] fASCIICharMap = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 1, 1, 1, 1, 1, 1, 4, 5, 1, 1, 1, 6, 7, 8, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 1, 1, 11, 1, 1, 1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 1, 1, 1, 3, 13, 1, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 1, 1, 1, 1, 1};
        private SymbolTable fSymbolTable;

        private Scanner(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
        }

        private boolean scanExpr(SymbolTable symbolTable, Tokens tokens, String string, int n2, int n3) throws XNIException {
            int n4 = 0;
            int n5 = 0;
            boolean bl = false;
            String string2 = null;
            String string3 = null;
            String string4 = null;
            StringBuffer stringBuffer = new StringBuffer();
            while (n2 != n3) {
                int n6 = string.charAt(n2);
                while ((n6 == 32 || n6 == 10 || n6 == 9 || n6 == 13) && ++n2 != n3) {
                    n6 = string.charAt(n2);
                }
                if (n2 == n3) break;
                int n7 = n6 >= 128 ? 14 : this.fASCIICharMap[n6];
                switch (n7) {
                    case 4: {
                        this.addToken(tokens, 0);
                        ++n4;
                        ++n2;
                        break;
                    }
                    case 5: {
                        this.addToken(tokens, 1);
                        ++n5;
                        ++n2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: {
                        if (n4 == 0) {
                            int n8 = n2;
                            if ((n2 = this.scanNCName(string, n3, n2)) == n8) {
                                XPointerHandler.this.reportError("InvalidShortHandPointer", new Object[]{string});
                                return false;
                            }
                            n6 = n2 < n3 ? (int)string.charAt(n2) : -1;
                            string2 = symbolTable.addSymbol(string.substring(n8, n2));
                            string3 = XMLSymbols.EMPTY_STRING;
                            if (n6 == 58) {
                                if (++n2 == n3) {
                                    return false;
                                }
                                n6 = string.charAt(n2);
                                string3 = string2;
                                n8 = n2;
                                if ((n2 = this.scanNCName(string, n3, n2)) == n8) {
                                    return false;
                                }
                                n6 = n2 < n3 ? (int)string.charAt(n2) : -1;
                                bl = true;
                                string2 = symbolTable.addSymbol(string.substring(n8, n2));
                            }
                            if (n2 != n3) {
                                this.addToken(tokens, 3);
                                tokens.addToken(string3);
                                tokens.addToken(string2);
                                bl = false;
                            } else if (n2 == n3) {
                                this.addToken(tokens, 2);
                                tokens.addToken(string2);
                                bl = false;
                            }
                            n5 = 0;
                            break;
                        }
                        if (n4 > 0 && n5 == 0 && string2 != null) {
                            int n9 = n2;
                            if ((n2 = this.scanData(string, stringBuffer, n3, n2)) == n9) {
                                XPointerHandler.this.reportError("InvalidSchemeDataInXPointer", new Object[]{string});
                                return false;
                            }
                            n6 = n2 < n3 ? (int)string.charAt(n2) : -1;
                            string4 = symbolTable.addSymbol(stringBuffer.toString());
                            this.addToken(tokens, 4);
                            tokens.addToken(string4);
                            n4 = 0;
                            stringBuffer.delete(0, stringBuffer.length());
                            break;
                        }
                        return false;
                    }
                }
            }
            return true;
        }

        private int scanNCName(String string, int n2, int n3) {
            byte by;
            char c2 = string.charAt(n3);
            if (c2 >= '\u0080' ? !XMLChar.isNameStart((int)c2) : (by = this.fASCIICharMap[c2]) != 12 && by != 13) {
                return n3;
            }
            while (++n3 < n2 && !((c2 = string.charAt(n3)) >= '\u0080' ? !XMLChar.isName((int)c2) : (by = this.fASCIICharMap[c2]) != 12 && by != 9 && by != 7 && by != 6 && by != 13)) {
            }
            return n3;
        }

        private int scanData(String string, StringBuffer stringBuffer, int n2, int n3) {
            while (n3 != n2) {
                int n4;
                char c2 = string.charAt(n3);
                int n5 = n4 = c2 >= '\u0080' ? 14 : this.fASCIICharMap[c2];
                if (n4 == 4) {
                    stringBuffer.append((int)c2);
                    ++n3;
                    n3 = this.scanData(string, stringBuffer, n2, n3);
                    if (n3 == n2) {
                        return n3;
                    }
                    c2 = string.charAt(n3);
                    int n6 = n4 = c2 >= '\u0080' ? 14 : this.fASCIICharMap[c2];
                    if (n4 != 5) {
                        return n2;
                    }
                    stringBuffer.append(c2);
                    ++n3;
                    continue;
                }
                if (n4 == 5) {
                    return n3;
                }
                if (n4 == 3) {
                    int n7 = n4 = (c2 = string.charAt(++n3)) >= '\u0080' ? 14 : this.fASCIICharMap[c2];
                    if (n4 != 3 && n4 != 4 && n4 != 5) break;
                    stringBuffer.append(c2);
                    ++n3;
                    continue;
                }
                stringBuffer.append(c2);
                ++n3;
            }
            return n3;
        }

        protected void addToken(Tokens tokens, int n2) throws XNIException {
            tokens.addToken(n2);
        }
    }

    private final class Tokens {
        private static final int XPTRTOKEN_OPEN_PAREN = 0;
        private static final int XPTRTOKEN_CLOSE_PAREN = 1;
        private static final int XPTRTOKEN_SHORTHAND = 2;
        private static final int XPTRTOKEN_SCHEMENAME = 3;
        private static final int XPTRTOKEN_SCHEMEDATA = 4;
        private final String[] fgTokenNames = new String[]{"XPTRTOKEN_OPEN_PAREN", "XPTRTOKEN_CLOSE_PAREN", "XPTRTOKEN_SHORTHAND", "XPTRTOKEN_SCHEMENAME", "XPTRTOKEN_SCHEMEDATA"};
        private static final int INITIAL_TOKEN_COUNT = 256;
        private int[] fTokens = new int[256];
        private int fTokenCount = 0;
        private int fCurrentTokenIndex;
        private SymbolTable fSymbolTable;
        private HashMap fTokenNames = new HashMap();

        private Tokens(SymbolTable symbolTable) {
            this.fSymbolTable = symbolTable;
            this.fTokenNames.put(new Integer(0), "XPTRTOKEN_OPEN_PAREN");
            this.fTokenNames.put(new Integer(1), "XPTRTOKEN_CLOSE_PAREN");
            this.fTokenNames.put(new Integer(2), "XPTRTOKEN_SHORTHAND");
            this.fTokenNames.put(new Integer(3), "XPTRTOKEN_SCHEMENAME");
            this.fTokenNames.put(new Integer(4), "XPTRTOKEN_SCHEMEDATA");
        }

        private String getTokenString(int n2) {
            return (String)this.fTokenNames.get(new Integer(n2));
        }

        private void addToken(String string) {
            Integer n2 = (Integer)this.fTokenNames.get(string);
            if (n2 == null) {
                n2 = new Integer(this.fTokenNames.size());
                this.fTokenNames.put(n2, string);
            }
            this.addToken(n2);
        }

        private void addToken(int n2) {
            try {
                this.fTokens[this.fTokenCount] = n2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray = this.fTokens;
                this.fTokens = new int[this.fTokenCount << 1];
                System.arraycopy(nArray, 0, this.fTokens, 0, this.fTokenCount);
                this.fTokens[this.fTokenCount] = n2;
            }
            ++this.fTokenCount;
        }

        private void rewind() {
            this.fCurrentTokenIndex = 0;
        }

        private boolean hasMore() {
            return this.fCurrentTokenIndex < this.fTokenCount;
        }

        private int nextToken() throws XNIException {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                XPointerHandler.this.reportError("XPointerProcessingError", null);
            }
            return this.fTokens[this.fCurrentTokenIndex++];
        }

        private int peekToken() throws XNIException {
            if (this.fCurrentTokenIndex == this.fTokenCount) {
                XPointerHandler.this.reportError("XPointerProcessingError", null);
            }
            return this.fTokens[this.fCurrentTokenIndex];
        }

        private String nextTokenAsString() throws XNIException {
            String string = this.getTokenString(this.nextToken());
            if (string == null) {
                XPointerHandler.this.reportError("XPointerProcessingError", null);
            }
            return string;
        }
    }
}

