/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.instruct.ValueOf;
import net.sf.saxon.expr.instruct.WithParam;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionParser;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.functions.Current;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.ItemTypePattern;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternThatSetsCurrent;
import net.sf.saxon.pattern.PatternWithPredicate;
import net.sf.saxon.style.AbsentExtensionElement;
import net.sf.saxon.style.AttributeValueTemplate;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.LiteralResultElement;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.SourceBinding;
import net.sf.saxon.style.StylesheetProcedure;
import net.sf.saxon.style.XSLAttributeSet;
import net.sf.saxon.style.XSLFallback;
import net.sf.saxon.style.XSLForEachGroup;
import net.sf.saxon.style.XSLGeneralVariable;
import net.sf.saxon.style.XSLLocalParam;
import net.sf.saxon.style.XSLLocalVariable;
import net.sf.saxon.style.XSLSort;
import net.sf.saxon.style.XSLSortOrMergeKey;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.style.XSLWithParam;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.TextImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.ConversionResult;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;
import org.xml.sax.Locator;

public abstract class StyleElement
extends ElementImpl
implements Locator,
Container,
InstructionInfo {
    protected String[] extensionNamespaces = null;
    private String[] excludedNamespaces = null;
    protected DecimalValue version = null;
    protected ExpressionContext staticContext = null;
    protected XPathException validationError = null;
    protected int reportingCircumstances = 1;
    protected String defaultXPathNamespace = null;
    protected String defaultCollationName = null;
    protected boolean expandText = false;
    private boolean explaining = false;
    private StructuredQName objectName;
    private XSLStylesheet containingStylesheet;
    public static final int REPORT_ALWAYS = 1;
    public static final int REPORT_UNLESS_FORWARDS_COMPATIBLE = 2;
    public static final int REPORT_IF_INSTANTIATED = 3;
    public static final int REPORT_UNLESS_FALLBACK_AVAILABLE = 4;
    protected int actionsCompleted = 0;
    public static final int ACTION_VALIDATE = 1;
    public static final int ACTION_COMPILE = 2;
    public static final int ACTION_TYPECHECK = 4;
    public static final int ACTION_OPTIMIZE = 8;
    public static final int ACTION_FIXUP = 16;
    public static final int ACTION_PROCESS_ATTRIBUTES = 32;
    protected static final String[] YES_NO = new String[]{"no", "yes"};

    public Executable getExecutable() {
        return this.getPreparedStylesheet();
    }

    public LocationProvider getLocationProvider() {
        return this.getPreparedStylesheet().getLocationMap();
    }

    public StaticContext getStaticContext() {
        if (this.staticContext == null) {
            this.staticContext = new ExpressionContext(this);
        }
        return this.staticContext;
    }

    public int getContainerGranularity() {
        return 1;
    }

    public ExpressionVisitor makeExpressionVisitor() {
        return ExpressionVisitor.make((StaticContext)this.getStaticContext(), (Executable)this.getPreparedStylesheet());
    }

    protected boolean isExplaining() {
        return this.explaining;
    }

    public void substituteFor(StyleElement styleElement) {
        this.setRawParent(styleElement.getRawParent());
        this.setAttributeList(styleElement.getAttributeList());
        this.setNamespaceList(styleElement.getNamespaceList());
        this.setNameCode(styleElement.getNameCode());
        this.setRawSequenceNumber(styleElement.getRawSequenceNumber());
        this.extensionNamespaces = styleElement.extensionNamespaces;
        this.excludedNamespaces = styleElement.excludedNamespaces;
        this.version = styleElement.version;
        this.staticContext = styleElement.staticContext;
        this.validationError = styleElement.validationError;
        this.reportingCircumstances = styleElement.reportingCircumstances;
    }

    public void setValidationError(TransformerException transformerException, int n2) {
        this.validationError = XPathException.makeXPathException((TransformerException)transformerException);
        this.reportingCircumstances = n2;
    }

    public boolean isInstruction() {
        return false;
    }

    public boolean isDeclaration() {
        return false;
    }

    protected ItemType getReturnedItemType() {
        return AnyItemType.getInstance();
    }

    protected ItemType getCommonChildItemType() {
        TypeHierarchy typeHierarchy = this.getConfiguration().getTypeHierarchy();
        ErrorType errorType = ErrorType.getInstance();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        do {
            NodeInfo nodeInfo;
            if ((nodeInfo = axisIterator.next()) == null) {
                return errorType;
            }
            if (nodeInfo instanceof StyleElement) {
                ItemType itemType = ((StyleElement)nodeInfo).getReturnedItemType();
                if (itemType == null) continue;
                errorType = Type.getCommonSuperType((ItemType)errorType, (ItemType)itemType, (TypeHierarchy)typeHierarchy);
                continue;
            }
            errorType = Type.getCommonSuperType((ItemType)errorType, (ItemType)NodeKindTest.TEXT, (TypeHierarchy)typeHierarchy);
        } while (errorType != AnyItemType.getInstance());
        return errorType;
    }

    protected boolean markTailCalls() {
        return false;
    }

    protected boolean mayContainSequenceConstructor() {
        return false;
    }

    protected boolean mayContainFallback() {
        return this.mayContainSequenceConstructor();
    }

    protected boolean mayContainParam(String string) {
        return false;
    }

    public XSLStylesheet getContainingStylesheet() {
        if (this.containingStylesheet == null) {
            if (this instanceof XSLStylesheet) {
                this.containingStylesheet = (XSLStylesheet)this;
            } else {
                NodeImpl nodeImpl = this.getParent();
                if (nodeImpl instanceof StyleElement) {
                    this.containingStylesheet = ((StyleElement)nodeImpl).getContainingStylesheet();
                } else {
                    return null;
                }
            }
        }
        return this.containingStylesheet;
    }

    public final StructuredQName makeQName(String string) throws XPathException, NamespaceException {
        StructuredQName structuredQName;
        try {
            structuredQName = StructuredQName.fromLexicalQName((CharSequence)string, (boolean)false, (boolean)this.isXslt30Processor(), (NameChecker)this.getConfiguration().getNameChecker(), (NamespaceResolver)this);
        }
        catch (XPathException xPathException) {
            xPathException.setIsStaticError(true);
            String string2 = xPathException.getErrorCodeLocalPart();
            if ("FONS0004".equals(string2)) {
                xPathException.setErrorCode("XTSE0280");
            } else if ("FOCA0002".equals(string2)) {
                xPathException.setErrorCode("XTSE0020");
            } else if (string2 == null) {
                xPathException.setErrorCode("XTSE0020");
            }
            throw xPathException;
        }
        if (NamespaceConstant.isReserved((String)structuredQName.getURI())) {
            XPathException xPathException = new XPathException("Namespace prefix " + structuredQName.getPrefix() + " refers to a reserved namespace");
            xPathException.setIsStaticError(true);
            xPathException.setErrorCode("XTSE0080");
            throw xPathException;
        }
        return structuredQName;
    }

    public SavedNamespaceContext makeNamespaceContext() {
        return new SavedNamespaceContext(NamespaceIterator.iterateNamespaces((NodeInfo)this));
    }

    public NamespaceResolver getNamespaceResolver() {
        return this;
    }

    protected void processAllAttributes() throws XPathException {
        this.processDefaultCollationAttribute();
        this.staticContext = new ExpressionContext(this);
        this.processAttributes();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).processAllAttributes();
            if (!((StyleElement)nodeInfo).explaining) continue;
            this.explaining = true;
        }
        return;
    }

    public void processStandardAttributes(String string) throws XPathException {
        this.processExtensionElementAttribute(string);
        this.processExcludedNamespaces(string);
        this.processVersionAttribute(string);
        this.processDefaultXPathNamespaceAttribute(string);
        this.processExpandTextAttribute(string);
    }

    public String getAttributeValue(String string) {
        FingerprintedQName fingerprintedQName = FingerprintedQName.fromClarkName((String)string);
        return this.getAttributeValue(fingerprintedQName.getURI(), fingerprintedQName.getLocalPart());
    }

    protected final void processAttributes() throws XPathException {
        try {
            this.prepareAttributes();
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
    }

    protected void checkUnknownAttribute(NodeName nodeName) throws XPathException {
        String string = nodeName.getURI();
        String string2 = this.getURI();
        String string3 = nodeName.getStructuredQName().getClarkName();
        if (string3.equals("{http://saxon.sf.net/}explain")) {
            this.explaining = "yes".equals(this.getAttributeValue(string3));
        }
        if (this.forwardsCompatibleModeIsEnabled()) {
            return;
        }
        if (this.isInstruction() && string.equals("http://www.w3.org/1999/XSL/Transform") && !string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3.endsWith("}default-collation") || string3.endsWith("}xpath-default-namespace") || string3.endsWith("}expand-text") || string3.endsWith("}extension-element-prefixes") || string3.endsWith("}exclude-result-prefixes") || string3.endsWith("}version") || string3.endsWith("}use-when"))) {
            return;
        }
        if (string2.equals("http://www.w3.org/1999/XSL/Transform") && (string3.equals("default-collation") || string3.equals("expand-text") || string3.equals("xpath-default-namespace") || string3.equals("extension-element-prefixes") || string3.equals("exclude-result-prefixes") || string3.equals("version") || string3.equals("use-when") || string3.equals("static"))) {
            return;
        }
        if ("".equals(string) || "http://www.w3.org/1999/XSL/Transform".equals(string)) {
            this.compileError("Attribute " + Err.wrap((CharSequence)nodeName.getDisplayName(), (int)2) + " is not allowed on element " + Err.wrap((CharSequence)this.getDisplayName(), (int)1), "XTSE0090");
        }
    }

    protected abstract void prepareAttributes() throws XPathException;

    protected StyleElement getLastChildInstruction() {
        StyleElement styleElement = null;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (nodeInfo instanceof StyleElement) {
                styleElement = (StyleElement)nodeInfo;
                continue;
            }
            styleElement = null;
        }
        return styleElement;
    }

    public Expression makeExpression(String string) throws XPathException {
        try {
            return ExpressionTool.make((String)string, (StaticContext)this.staticContext, (Container)this, (int)0, (int)0, (int)this.getLineNumber(), (CodeInjector)this.getPreparedStylesheet().getCompilerInfo().getCodeInjector());
        }
        catch (XPathException xPathException) {
            xPathException.setLocator((SourceLocator)((Object)this));
            if (xPathException.isReportableStatically()) {
                this.compileError(xPathException);
            }
            ErrorExpression errorExpression = new ErrorExpression(xPathException);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            errorExpression.setContainer((Container)this);
            return errorExpression;
        }
    }

    public Pattern makePattern(String string) throws XPathException {
        try {
            return Pattern.make((String)string, (StaticContext)this.staticContext, (Executable)this.getPreparedStylesheet());
        }
        catch (XPathException xPathException) {
            if ("XPST0003".equals(xPathException.getErrorCodeLocalPart())) {
                xPathException.setErrorCode("XTSE0340");
            }
            this.compileError(xPathException);
            return new ItemTypePattern((ItemType)AnyNodeTest.getInstance());
        }
    }

    protected Expression makeAttributeValueTemplate(String string) throws XPathException {
        try {
            return AttributeValueTemplate.make((String)string, (int)this.getLineNumber(), (ExpressionContext)this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return new StringLiteral((CharSequence)string);
        }
    }

    protected void checkAttributeValue(String string, String string2, boolean bl, String[] stringArray) throws XPathException {
        if (bl && string2.contains("{")) {
            return;
        }
        if (Arrays.binarySearch(stringArray, string2) < 0) {
            FastStringBuffer fastStringBuffer = new FastStringBuffer(64);
            fastStringBuffer.append("Invalid value for ");
            fastStringBuffer.append("@");
            fastStringBuffer.append(string);
            fastStringBuffer.append(". Value must be one of (");
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                fastStringBuffer.append(i2 == 0 ? "" : "|");
                fastStringBuffer.append(stringArray[i2]);
            }
            fastStringBuffer.append(")");
            this.compileError(fastStringBuffer.toString(), "XTSE0020");
        }
    }

    public SequenceType makeSequenceType(String string) throws XPathException {
        this.getStaticContext();
        try {
            ExpressionParser expressionParser = this.getConfiguration().newExpressionParser("XP", false, this.staticContext.getXPathLanguageLevel());
            expressionParser.setLanguage(0, this.staticContext.getXPathLanguageLevel());
            return expressionParser.parseSequenceType(string, (StaticContext)this.staticContext);
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
            return SequenceType.ANY_SEQUENCE;
        }
    }

    protected void processExtensionElementAttribute(String string) throws XPathException {
        String string2 = this.getAttributeValue(string, "extension-element-prefixes");
        if (string2 != null) {
            int n2 = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r", false);
            while (stringTokenizer.hasMoreTokens()) {
                stringTokenizer.nextToken();
                ++n2;
            }
            this.extensionNamespaces = new String[n2];
            n2 = 0;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t\n\r", false);
            while (stringTokenizer2.hasMoreTokens()) {
                String string3;
                String string4 = stringTokenizer2.nextToken();
                if ("#default".equals(string4)) {
                    string4 = "";
                }
                if ((string3 = this.getURIForPrefix(string4, false)) == null) {
                    this.extensionNamespaces = null;
                    this.compileError("Namespace prefix " + string4 + " is undeclared", "XTSE1430");
                    continue;
                }
                assert (this.extensionNamespaces != null);
                this.extensionNamespaces[n2++] = string3;
            }
        }
    }

    protected void processExcludedNamespaces(String string) throws XPathException {
        String string2 = this.getAttributeValue(string, "exclude-result-prefixes");
        if (string2 != null) {
            if ("#all".equals(Whitespace.trim((CharSequence)string2))) {
                Iterator iterator = NamespaceIterator.iterateNamespaces((NodeInfo)this);
                ArrayList<String> arrayList = new ArrayList<String>();
                while (iterator.hasNext()) {
                    arrayList.add(((NamespaceBinding)iterator.next()).getURI());
                }
                this.excludedNamespaces = arrayList.toArray(new String[arrayList.size()]);
            } else {
                int n2 = 0;
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r", false);
                while (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                    ++n2;
                }
                this.excludedNamespaces = new String[n2];
                n2 = 0;
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, " \t\n\r", false);
                while (stringTokenizer2.hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if ("#default".equals(string3)) {
                        string3 = "";
                    } else if ("#all".equals(string3)) {
                        this.compileError("In exclude-result-prefixes, cannot mix #all with other values", "XTSE0020");
                    }
                    String string4 = this.getURIForPrefix(string3, true);
                    if (string4 == null) {
                        this.excludedNamespaces = null;
                        this.compileError("Namespace prefix " + string3 + " is not declared", "XTSE0808");
                        break;
                    }
                    this.excludedNamespaces[n2++] = string4;
                    if (string3.length() != 0 || string4.length() != 0) continue;
                    this.compileError("Cannot exclude the #default namespace when no default namespace is declared", "XTSE0809");
                }
            }
        }
    }

    protected void processVersionAttribute(String string) throws XPathException {
        String string2 = Whitespace.trim((CharSequence)this.getAttributeValue(string, "version"));
        if (string2 != null) {
            ConversionResult conversionResult = DecimalValue.makeDecimalValue((CharSequence)string2, (boolean)true);
            if (conversionResult instanceof ValidationFailure) {
                this.compileError("The version attribute must be a decimal literal", "XTSE0110");
                this.version = DecimalValue.TWO;
            } else {
                this.version = (DecimalValue)conversionResult;
            }
        }
    }

    public DecimalValue getEffectiveVersion() {
        if (this.version == null) {
            NodeImpl nodeImpl = this.getParent();
            if (nodeImpl instanceof StyleElement) {
                this.version = ((StyleElement)nodeImpl).getEffectiveVersion();
            } else {
                return DecimalValue.TWO;
            }
        }
        return this.version;
    }

    public boolean forwardsCompatibleModeIsEnabled() {
        return this.getEffectiveVersion().compareTo((Object)this.getProcessorVersion()) > 0;
    }

    public boolean xPath10ModeIsEnabled() {
        return this.getEffectiveVersion().compareTo((Object)DecimalValue.TWO) < 0;
    }

    public DecimalValue getProcessorVersion() {
        return this.getPreparedStylesheet().getStyleNodeFactory().getXsltProcessorVersion();
    }

    public boolean isXslt30Processor() {
        return this.getProcessorVersion().compareTo((Object)DecimalValue.THREE) >= 0;
    }

    protected void processDefaultCollationAttribute() throws XPathException {
        String string = this.getURI().equals("http://www.w3.org/1999/XSL/Transform") ? "" : "http://www.w3.org/1999/XSL/Transform";
        String string2 = this.getAttributeValue(string, "default-collation");
        if (string2 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, " \t\n\r", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
                    this.defaultCollationName = string3;
                    return;
                }
                if (string3.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = string3;
                    return;
                }
                try {
                    URI uRI = new URI(string3);
                    if (!uRI.isAbsolute()) {
                        URI uRI2 = new URI(this.getBaseURI());
                        uRI = uRI2.resolve(uRI);
                        string3 = uRI.toString();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    this.compileError("default collation '" + string3 + "' is not a valid URI");
                    string3 = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
                }
                if (string3.startsWith("http://saxon.sf.net/")) {
                    this.defaultCollationName = string3;
                    return;
                }
                if (this.getPreparedStylesheet().getNamedCollation(string3) != null) {
                    this.defaultCollationName = string3;
                    return;
                }
                if (this.getPrincipalStylesheetModule().findCollation(string3, this.getBaseURI()) == null) continue;
                this.defaultCollationName = string3;
                return;
            }
            this.compileError("No recognized collation URI found in default-collation attribute", "XTSE0125");
        }
    }

    protected String getDefaultCollationName() {
        Object object;
        StyleElement styleElement = this;
        while (true) {
            if (styleElement.defaultCollationName != null) {
                return styleElement.defaultCollationName;
            }
            object = styleElement.getParent();
            if (!(object instanceof StyleElement)) break;
            styleElement = (StyleElement)object;
        }
        object = this.getConfiguration().getCollationMap().getDefaultCollationName();
        return object == null ? "http://www.w3.org/2005/xpath-functions/collation/codepoint" : object;
    }

    protected boolean definesExtensionElement(String string) {
        if (this.extensionNamespaces == null) {
            return false;
        }
        for (String string2 : this.extensionNamespaces) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isExtensionNamespace(String string) {
        StyleElement styleElement = this;
        while (styleElement instanceof StyleElement) {
            if (styleElement.definesExtensionElement(string)) {
                return true;
            }
            styleElement = styleElement.getParent();
        }
        return false;
    }

    protected boolean definesExcludedNamespace(String string) {
        if (this.excludedNamespaces == null) {
            return false;
        }
        for (String string2 : this.excludedNamespaces) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isExcludedNamespace(String string) {
        if (string.equals("http://www.w3.org/1999/XSL/Transform") || string.equals("http://www.w3.org/XML/1998/namespace")) {
            return true;
        }
        if (this.isExtensionNamespace(string)) {
            return true;
        }
        StyleElement styleElement = this;
        while (styleElement instanceof StyleElement) {
            if (styleElement.definesExcludedNamespace(string)) {
                return true;
            }
            styleElement = styleElement.getParent();
        }
        return false;
    }

    protected void processDefaultXPathNamespaceAttribute(String string) {
        String string2 = this.getAttributeValue(string, "xpath-default-namespace");
        if (string2 != null) {
            this.defaultXPathNamespace = string2;
        }
    }

    protected String getDefaultXPathNamespace() {
        StyleElement styleElement = this;
        while (styleElement instanceof StyleElement) {
            String string = styleElement.defaultXPathNamespace;
            if (string != null) {
                return string;
            }
            styleElement = styleElement.getParent();
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processExpandTextAttribute(String string) throws XPathException {
        String string2 = this.getAttributeValue(string, "expand-text");
        if (string2 != null) {
            if ("no".equals(string2 = Whitespace.trim((CharSequence)string2))) {
                this.expandText = false;
                return;
            } else {
                if (!"yes".equals(string2)) throw new XPathException("The value of expand-text must be 'yes' or 'no'", "XTSE0020");
                this.expandText = true;
            }
            return;
        } else {
            NodeImpl nodeImpl = this.getParent();
            this.expandText = nodeImpl instanceof StyleElement ? ((StyleElement)nodeImpl).expandText : false;
        }
    }

    public boolean isExpandingText() {
        return this.expandText;
    }

    public SchemaType getSchemaType(String string) throws XPathException {
        try {
            String string2;
            String[] stringArray = this.getConfiguration().getNameChecker().getQNameParts((CharSequence)string);
            String string3 = stringArray[1];
            if ("".equals(stringArray[0])) {
                string2 = this.getDefaultXPathNamespace();
            } else {
                string2 = this.getURIForPrefix(stringArray[0], false);
                if (string2 == null) {
                    this.compileError("Namespace prefix for type annotation is undeclared", "XTSE1520");
                    return null;
                }
            }
            int n2 = this.getNamePool().allocate(stringArray[0], string2, string3);
            if (string2.equals("http://www.w3.org/2001/XMLSchema")) {
                SchemaType schemaType = BuiltInType.getSchemaType((int)StandardNames.getFingerprint((String)string2, (String)string3));
                if (schemaType == null) {
                    this.compileError("Unknown built-in type " + string, "XTSE1520");
                    return null;
                }
                return schemaType;
            }
            if (!this.getPrincipalStylesheetModule().isImportedSchema(string2)) {
                this.compileError("There is no imported schema for the namespace of type " + string, "XTSE1520");
                return null;
            }
            SchemaType schemaType = this.getConfiguration().getSchemaType(n2 & 0xFFFFF);
            if (schemaType == null) {
                this.compileError("There is no type named " + string + " in an imported schema", "XTSE1520");
            }
            return schemaType;
        }
        catch (QNameException qNameException) {
            this.compileError("Invalid type name. " + qNameException.getMessage(), "XTSE1520");
            return null;
        }
    }

    public SimpleType getTypeAnnotation(SchemaType schemaType) {
        return (SimpleType)schemaType;
    }

    public void validate(Declaration declaration) throws XPathException {
    }

    public void postValidate() throws XPathException {
    }

    protected void index(Declaration declaration, PrincipalStylesheetModule principalStylesheetModule) throws XPathException {
    }

    public Expression typeCheck(String string, Expression expression) throws XPathException {
        if (expression == null) {
            return null;
        }
        expression.setContainer((Container)this);
        try {
            expression = this.makeExpressionVisitor().typeCheck(expression, new ExpressionVisitor.ContextItemType(Type.ITEM_TYPE, true));
            expression = ExpressionTool.resolveCallsToCurrentFunction((Expression)expression, (Configuration)this.getConfiguration());
            CodeInjector codeInjector = this.getPreparedStylesheet().getCompilerInfo().getCodeInjector();
            if (codeInjector != null) {
                return codeInjector.inject(expression, this.getStaticContext(), 2011, new StructuredQName("", "", string));
            }
            return expression;
        }
        catch (XPathException xPathException) {
            if (xPathException.isReportableStatically()) {
                this.compileError(xPathException);
                return expression;
            }
            ErrorExpression errorExpression = new ErrorExpression(xPathException);
            errorExpression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            return errorExpression;
        }
    }

    public void allocateSlots(Expression expression) {
        SlotManager slotManager = this.getContainingSlotManager();
        if (slotManager == null) {
            throw new AssertionError((Object)"Slot manager has not been allocated");
        }
        int n2 = slotManager.getNumberOfVariables();
        int n3 = ExpressionTool.allocateSlots((Expression)expression, (int)n2, (SlotManager)slotManager);
        if (n3 > n2) {
            slotManager.setNumberOfVariables(n3);
        }
    }

    public void allocatePatternSlots(int n2) {
        this.getPrincipalStylesheetModule().allocatePatternSlots(n2);
    }

    public Pattern typeCheck(String string, Pattern pattern) throws XPathException {
        if (pattern == null) {
            return null;
        }
        try {
            Expression expression;
            pattern = pattern.analyze(this.makeExpressionVisitor(), new ExpressionVisitor.ContextItemType(Type.NODE_TYPE, true));
            boolean bl = false;
            Iterator iterator = pattern.iterateSubExpressions();
            while (iterator.hasNext()) {
                expression = (Expression)iterator.next();
                if (!ExpressionTool.callsFunction((Expression)expression, (StructuredQName)Current.FN_CURRENT)) continue;
                bl = true;
                break;
            }
            if (bl) {
                expression = new PatternThatSetsCurrent(pattern);
                pattern.bindCurrent(expression.getCurrentBinding());
                pattern = expression;
            }
            return pattern;
        }
        catch (XPathException xPathException) {
            if (xPathException.isReportableStatically()) {
                XPathException xPathException2 = new XPathException("Error in " + string + " pattern", (Throwable)xPathException);
                xPathException2.setLocator((SourceLocator)((Object)this));
                xPathException2.setErrorCodeQName(xPathException.getErrorCodeQName());
                throw xPathException2;
            }
            PatternWithPredicate patternWithPredicate = new PatternWithPredicate((Pattern)new ItemTypePattern((ItemType)AnyItemType.getInstance()), (Expression)new ErrorExpression(xPathException));
            patternWithPredicate.setExecutable((Executable)this.getPreparedStylesheet());
            return patternWithPredicate;
        }
    }

    public void fixupReferences() throws XPathException {
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        NodeInfo nodeInfo;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof StyleElement)) continue;
            ((StyleElement)nodeInfo).fixupReferences();
        }
        return;
    }

    public SlotManager getContainingSlotManager() {
        StyleElement styleElement = this;
        while (true) {
            NodeInfo nodeInfo;
            if ((nodeInfo = styleElement.getParent()) instanceof XSLStylesheet) {
                if (styleElement instanceof StylesheetProcedure) {
                    return ((StylesheetProcedure)styleElement).getSlotManager();
                }
                return null;
            }
            styleElement = nodeInfo;
        }
    }

    public void validateSubtree(Declaration declaration) throws XPathException {
        if (this.isActionCompleted(1)) {
            return;
        }
        this.setActionCompleted(1);
        if (this.validationError != null) {
            if (this.reportingCircumstances == 1) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 2 && !this.forwardsCompatibleModeIsEnabled()) {
                this.compileError(this.validationError);
            } else if (this.reportingCircumstances == 4) {
                if (!this.forwardsCompatibleModeIsEnabled()) {
                    this.compileError(this.validationError);
                } else {
                    NodeInfo nodeInfo;
                    boolean bl = false;
                    AxisIterator axisIterator = this.iterateAxis((byte)3);
                    while ((nodeInfo = axisIterator.next()) != null) {
                        if (!(nodeInfo instanceof XSLFallback)) continue;
                        bl = true;
                        ((XSLFallback)nodeInfo).validateSubtree(declaration);
                    }
                    if (!bl) {
                        this.compileError(this.validationError);
                    }
                }
            }
        } else {
            try {
                this.validate(declaration);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
            this.validateChildren(declaration);
            this.postValidate();
        }
    }

    protected void validateChildren(Declaration declaration) throws XPathException {
        NodeInfo nodeInfo;
        boolean bl = this.mayContainSequenceConstructor();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        StyleElement styleElement = null;
        boolean bl2 = false;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (nodeInfo instanceof StyleElement) {
                bl2 = false;
                if (bl && !((StyleElement)nodeInfo).isInstruction() && !this.isPermittedChild((StyleElement)nodeInfo)) {
                    ((StyleElement)nodeInfo).compileError("An " + this.getDisplayName() + " element must not contain an " + nodeInfo.getDisplayName() + " element", "XTSE0010");
                }
                ((StyleElement)nodeInfo).validateSubtree(declaration);
                styleElement = (StyleElement)nodeInfo;
                continue;
            }
            bl2 = this.getPreparedStylesheet().getStyleNodeFactory().validateTextNode(nodeInfo);
        }
        if (styleElement instanceof XSLLocalVariable && !(this instanceof XSLStylesheet) && !bl2) {
            styleElement.compileWarning("A variable with no following sibling instructions has no effect", "SXWN9001");
        }
    }

    protected boolean isPermittedChild(StyleElement styleElement) {
        return false;
    }

    public PreparedStylesheet getPreparedStylesheet() {
        XSLStylesheet xSLStylesheet = this.getContainingStylesheet();
        return xSLStylesheet == null ? null : xSLStylesheet.getPreparedStylesheet();
    }

    public PrincipalStylesheetModule getPrincipalStylesheetModule() {
        return this.getContainingStylesheet().getPrincipalStylesheetModule();
    }

    protected void checkSortComesFirst(boolean bl) throws XPathException {
        NodeInfo nodeInfo;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        boolean bl2 = false;
        boolean bl3 = false;
        while ((nodeInfo = axisIterator.next()) != null) {
            if (nodeInfo instanceof XSLSort) {
                if (bl3) {
                    ((XSLSort)nodeInfo).compileError("Within " + this.getDisplayName() + ", xsl:sort elements must come before other instructions", "XTSE0010");
                }
                bl2 = true;
                continue;
            }
            if (nodeInfo.getNodeKind() == 3) {
                if (Whitespace.isWhite((CharSequence)nodeInfo.getStringValueCS())) continue;
                bl3 = true;
                continue;
            }
            bl3 = true;
        }
        if (bl && !bl2) {
            this.compileError(this.getDisplayName() + " must have at least one xsl:sort child", "XTSE0010");
        }
    }

    public void checkTopLevel(String string) throws XPathException {
        if (!(this.getParent() instanceof XSLStylesheet)) {
            this.compileError("Element " + this.getDisplayName() + " must always be a child of xsl:stylesheet or xsl:transform", string);
        }
    }

    public void checkEmpty() throws XPathException {
        if (this.hasChildNodes()) {
            this.compileError("Element must be empty", "XTSE0260");
        }
    }

    public void reportAbsence(String string) throws XPathException {
        this.compileError("Element must have an @" + string + " attribute", "XTSE0010");
    }

    public Expression compile(Executable executable, Declaration declaration) throws XPathException {
        return null;
    }

    public void compileDeclaration(Executable executable, Declaration declaration) throws XPathException {
    }

    public Expression compileSequenceConstructor(Executable executable, Declaration declaration, SequenceIterator sequenceIterator, boolean bl) throws XPathException {
        NodeInfo nodeInfo;
        int n2 = this.allocateLocationId(this.getSystemId(), this.getLineNumber());
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        int n3 = this.getLineNumber();
        while ((nodeInfo = (NodeInfo)sequenceIterator.next()) != null) {
            Expression expression;
            LetExpression letExpression;
            Expression expression2;
            SourceBinding sourceBinding;
            Object object;
            if (nodeInfo instanceof StyleElement) {
                n3 = nodeInfo.getLineNumber();
            }
            if (nodeInfo.getNodeKind() == 3) {
                if (this.isExpandingText()) {
                    this.getPreparedStylesheet().getStyleNodeFactory().compileContentValueTemplate((TextImpl)nodeInfo, arrayList);
                    continue;
                }
                object = nodeInfo.iterateAxis((byte)7);
                sourceBinding = object.next();
                if (sourceBinding instanceof XSLLocalParam || sourceBinding instanceof XSLSort) continue;
                expression2 = new ValueOf((Expression)new StringLiteral((CharSequence)nodeInfo.getStringValue()), false, false);
                expression2.setLocationId(this.allocateLocationId(this.getSystemId(), n3));
                letExpression = this.getPreparedStylesheet().getCompilerInfo().getCodeInjector();
                if (letExpression != null) {
                    expression = letExpression.inject(expression2, this.getStaticContext(), 201, null);
                    expression.setLocationId(expression2.getLocationId());
                    expression2 = expression;
                }
                arrayList.add(expression2);
                continue;
            }
            if (nodeInfo instanceof XSLLocalVariable) {
                object = (XSLLocalVariable)nodeInfo;
                sourceBinding = object.getSourceBinding();
                object.compileLocalVariable(executable, declaration);
                expression2 = this.compileSequenceConstructor(executable, declaration, sequenceIterator, bl);
                if (expression2 == null || Literal.isEmptySequence((Expression)expression2)) continue;
                letExpression = new LetExpression();
                letExpression.setRequiredType(object.getRequiredType());
                letExpression.setVariableQName(sourceBinding.getVariableQName());
                letExpression.setSequence(sourceBinding.getSelectExpression());
                letExpression.setAction(expression2);
                sourceBinding.fixupBinding((Binding)letExpression);
                n2 = this.allocateLocationId(nodeInfo.getSystemId(), nodeInfo.getLineNumber());
                letExpression.setLocationId(n2);
                if (this.getPreparedStylesheet().isCompileWithTracing()) {
                    expression = new TraceExpression((Expression)letExpression);
                    expression.setConstructType(2013);
                    expression.setObjectName(object.getSourceBinding().getVariableQName());
                    expression.setNamespaceResolver(this.getNamespaceResolver());
                    expression.setProperty("xslVariable", nodeInfo);
                    arrayList.add(expression);
                    continue;
                }
                arrayList.add(letExpression);
                continue;
            }
            if (!(nodeInfo instanceof StyleElement)) continue;
            object = (StyleElement)nodeInfo;
            if (((StyleElement)object).validationError != null && !(this instanceof AbsentExtensionElement)) {
                sourceBinding = this.fallbackProcessing(executable, declaration, (StyleElement)object);
            } else {
                sourceBinding = ((StyleElement)object).compile(executable, declaration);
                if (sourceBinding != null) {
                    if (sourceBinding.getContainer() == null) {
                        sourceBinding.setContainer((Container)this);
                    }
                    n2 = this.allocateLocationId(this.getSystemId(), object.getLineNumber());
                    sourceBinding.setLocationId(n2);
                    if ((bl || !(nodeInfo instanceof XSLLocalParam)) && this.getPreparedStylesheet().isCompileWithTracing()) {
                        sourceBinding = StyleElement.makeTraceInstruction((StyleElement)object, (Expression)sourceBinding);
                    }
                }
            }
            if (sourceBinding == null) continue;
            arrayList.add(sourceBinding);
        }
        nodeInfo = Block.makeBlock(arrayList);
        nodeInfo.setLocationId(n2);
        return nodeInfo;
    }

    protected static Expression makeTraceInstruction(StyleElement styleElement, Expression expression) {
        if (expression instanceof TraceExpression && !(styleElement instanceof StylesheetProcedure)) {
            return expression;
        }
        CodeInjector codeInjector = styleElement.getPreparedStylesheet().getCompilerInfo().getCodeInjector();
        if (codeInjector != null) {
            Expression expression2;
            int n2 = styleElement.getFingerprint();
            if (styleElement instanceof LiteralResultElement) {
                n2 = 2006;
            }
            if ((expression2 = codeInjector.inject(expression, styleElement.getStaticContext(), n2, styleElement.getObjectName())) instanceof TraceExpression) {
                ((TraceExpression)expression2).setProperty("details", styleElement);
            }
            expression2.setLocationId(styleElement.allocateLocationId(styleElement.getSystemId(), styleElement.getLineNumber()));
            return expression2;
        }
        return expression;
    }

    protected Expression fallbackProcessing(Executable executable, Declaration declaration, StyleElement styleElement) throws XPathException {
        NodeInfo nodeInfo;
        Expression expression = null;
        AxisIterator axisIterator = styleElement.iterateAxis((byte)3);
        while ((nodeInfo = axisIterator.next()) != null) {
            if (!(nodeInfo instanceof XSLFallback)) continue;
            Expression expression2 = ((XSLFallback)nodeInfo).compileSequenceConstructor(executable, declaration, (SequenceIterator)nodeInfo.iterateAxis((byte)3), true);
            if (expression2 == null) {
                expression2 = Literal.makeEmptySequence();
            }
            if (expression == null) {
                expression = expression2;
                continue;
            }
            expression = Block.makeBlock((Expression)expression, (Expression)expression2);
            expression.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
        }
        if (expression != null) {
            return expression;
        }
        return new ErrorExpression(styleElement.validationError);
    }

    protected int allocateLocationId(String string, int n2) {
        return this.getStaticContext().getLocationMap().allocateLocationId(string, n2);
    }

    public SortKeyDefinition[] makeSortKeys(Declaration declaration) throws XPathException {
        SortKeyDefinition[] sortKeyDefinitionArray;
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((sortKeyDefinitionArray = axisIterator.next()) != null) {
            if (!(sortKeyDefinitionArray instanceof XSLSortOrMergeKey)) continue;
            ((XSLSortOrMergeKey)sortKeyDefinitionArray).compile((Executable)this.getPreparedStylesheet(), declaration);
            if (sortKeyDefinitionArray instanceof XSLSort && n2 != 0 && ((XSLSort)sortKeyDefinitionArray).getStable() != null) {
                this.compileError("stable attribute may appear only on the first xsl:sort element", "XTSE1017");
            }
            ++n2;
        }
        if (n2 > 0) {
            NodeInfo nodeInfo;
            sortKeyDefinitionArray = new SortKeyDefinition[n2];
            axisIterator = this.iterateAxis((byte)3);
            int n3 = 0;
            while ((nodeInfo = axisIterator.next()) != null) {
                if (!(nodeInfo instanceof XSLSortOrMergeKey)) continue;
                sortKeyDefinitionArray[n3++] = ((XSLSortOrMergeKey)nodeInfo).getSortKeyDefinition().simplify(this.makeExpressionVisitor());
            }
            return sortKeyDefinitionArray;
        }
        return null;
    }

    protected AttributeSet[] getAttributeSets(String string, List<Declaration> list) throws XPathException {
        AttributeSet[] attributeSetArray;
        if (list == null) {
            list = new ArrayList<Declaration>(4);
        }
        PrincipalStylesheetModule principalStylesheetModule = this.getPrincipalStylesheetModule();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r", false);
        while (stringTokenizer.hasMoreTokens()) {
            boolean bl;
            StructuredQName structuredQName;
            attributeSetArray = stringTokenizer.nextToken();
            try {
                structuredQName = this.makeQName((String)attributeSetArray);
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage(), "XTSE0710");
                structuredQName = null;
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage(), "XTSE0710");
                structuredQName = null;
            }
            if (bl = principalStylesheetModule.getAttributeSets(structuredQName, list)) continue;
            this.compileError("No attribute-set exists named " + (String)attributeSetArray, "XTSE0710");
        }
        attributeSetArray = new AttributeSet[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            XSLAttributeSet xSLAttributeSet = (XSLAttributeSet)list.get(i2).getSourceElement();
            attributeSetArray[i2] = xSLAttributeSet.getInstruction();
        }
        return attributeSetArray;
    }

    protected WithParam[] getWithParamInstructions(Executable executable, Declaration declaration, boolean bl, Expression expression) throws XPathException {
        XSLWithParam xSLWithParam;
        WithParam[] withParamArray;
        int n2 = 0;
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((withParamArray = axisIterator.next()) != null) {
            if (!(withParamArray instanceof XSLWithParam) || (xSLWithParam = (XSLWithParam)withParamArray).getSourceBinding().hasProperty(8) != bl) continue;
            ++n2;
        }
        if (n2 == 0) {
            return WithParam.EMPTY_ARRAY;
        }
        withParamArray = new WithParam[n2];
        n2 = 0;
        axisIterator = this.iterateAxis((byte)3);
        while ((xSLWithParam = axisIterator.next()) != null) {
            XSLWithParam xSLWithParam2;
            if (!(xSLWithParam instanceof XSLWithParam) || (xSLWithParam2 = xSLWithParam).getSourceBinding().hasProperty(8) != bl) continue;
            WithParam withParam = xSLWithParam2.compileWithParam(executable, declaration);
            withParam.setLocationId(executable.getLocationMap().allocateLocationId(this.getSystemId(), this.getLineNumber()));
            withParamArray[n2++] = withParam;
        }
        return withParamArray;
    }

    protected void compileError(XPathException xPathException) throws XPathException {
        xPathException.setIsStaticError(true);
        if (xPathException.getLocator() == null || (xPathException.getLocator() instanceof ExpressionLocation || xPathException.getLocator() instanceof Expression) && !(this instanceof StylesheetProcedure)) {
            xPathException.setLocator((SourceLocator)((Object)this));
        }
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        try {
            if (preparedStylesheet == null) {
                throw xPathException;
            }
            preparedStylesheet.reportError((TransformerException)((Object)xPathException));
        }
        catch (TransformerException transformerException) {
            if (transformerException.getLocator() == null) {
                transformerException.setLocator((SourceLocator)((Object)this));
            }
            throw XPathException.makeXPathException((TransformerException)transformerException);
        }
    }

    public void compileError(String string) throws XPathException {
        XPathException xPathException = new XPathException(string);
        xPathException.setLocator((SourceLocator)((Object)this));
        this.compileError(xPathException);
    }

    public void compileError(String string, StructuredQName structuredQName) throws XPathException {
        XPathException xPathException = new XPathException(string);
        xPathException.setErrorCodeQName(structuredQName);
        xPathException.setLocator((SourceLocator)((Object)this));
        this.compileError(xPathException);
    }

    public void compileError(String string, String string2) throws XPathException {
        XPathException xPathException = new XPathException(string);
        xPathException.setErrorCode(string2);
        xPathException.setLocator((SourceLocator)((Object)this));
        this.compileError(xPathException);
    }

    protected void undeclaredNamespaceError(String string, String string2) throws XPathException {
        if (string2 == null) {
            string2 = "XTSE0280";
        }
        this.compileError("Undeclared namespace prefix " + Err.wrap((CharSequence)string), string2);
    }

    protected void compileWarning(String string, StructuredQName structuredQName) throws XPathException {
        XPathException xPathException = new XPathException(string);
        xPathException.setErrorCodeQName(structuredQName);
        xPathException.setLocator((SourceLocator)((Object)this));
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        if (preparedStylesheet != null) {
            preparedStylesheet.reportWarning((TransformerException)((Object)xPathException));
        }
    }

    protected void compileWarning(String string, String string2) throws XPathException {
        XPathException xPathException = new XPathException(string);
        xPathException.setErrorCode(string2);
        xPathException.setLocator((SourceLocator)((Object)this));
        PreparedStylesheet preparedStylesheet = this.getPreparedStylesheet();
        if (preparedStylesheet != null) {
            preparedStylesheet.reportWarning((TransformerException)((Object)xPathException));
        }
    }

    protected void issueWarning(TransformerException transformerException) {
        PreparedStylesheet preparedStylesheet;
        if (transformerException.getLocator() == null) {
            transformerException.setLocator((SourceLocator)((Object)this));
        }
        if ((preparedStylesheet = this.getPreparedStylesheet()) != null) {
            preparedStylesheet.reportWarning(transformerException);
        }
    }

    protected void issueWarning(String string, SourceLocator sourceLocator) {
        TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string);
        if (sourceLocator == null) {
            transformerConfigurationException.setLocator((SourceLocator)((Object)this));
        } else {
            transformerConfigurationException.setLocator(sourceLocator);
        }
        this.issueWarning(transformerConfigurationException);
    }

    public boolean isTopLevel() {
        return this.getParent() instanceof XSLStylesheet;
    }

    public SourceBinding getBindingInformation(StructuredQName structuredQName) {
        return null;
    }

    public SourceBinding bindVariable(StructuredQName structuredQName) {
        SourceBinding sourceBinding = this.bindLocalVariable(structuredQName);
        if (sourceBinding != null) {
            return sourceBinding;
        }
        SourceBinding sourceBinding2 = this.getPrincipalStylesheetModule().getGlobalVariable(structuredQName);
        if (sourceBinding2 == null || Navigator.isAncestorOrSelf((NodeInfo)sourceBinding2.getSourceElement(), (NodeInfo)this)) {
            return null;
        }
        return sourceBinding2;
    }

    public SourceBinding bindLocalVariable(StructuredQName structuredQName) {
        block7: {
            StyleElement styleElement = this;
            StyleElement styleElement2 = this;
            if (!this.isTopLevel()) {
                XSLForEachGroup xSLForEachGroup;
                AxisIterator axisIterator = styleElement.iterateAxis((byte)11);
                do {
                    styleElement = axisIterator.next();
                    while (styleElement == null) {
                        styleElement = styleElement2.getParent();
                        while (styleElement instanceof StyleElement && !styleElement.seesAvuncularVariables()) {
                            styleElement = styleElement.getParent();
                        }
                        if (styleElement instanceof XSLForEachGroup) {
                            xSLForEachGroup = (XSLForEachGroup)styleElement;
                            if (structuredQName.equals((Object)xSLForEachGroup.getGroupBindingName())) {
                                return xSLForEachGroup.getGroupSourceBinding();
                            }
                            if (structuredQName.equals((Object)xSLForEachGroup.getKeyBindingName())) {
                                return xSLForEachGroup.getKeyBinding();
                            }
                        }
                        styleElement2 = styleElement;
                        if (styleElement.getParent() instanceof XSLStylesheet) break;
                        axisIterator = styleElement.iterateAxis((byte)11);
                        styleElement = axisIterator.next();
                    }
                    if (styleElement.getParent() instanceof XSLStylesheet) break block7;
                } while (!(styleElement instanceof XSLGeneralVariable) || (xSLForEachGroup = ((XSLGeneralVariable)styleElement).getBindingInformation(structuredQName)) == null);
                return xSLForEachGroup;
            }
        }
        return null;
    }

    protected boolean seesAvuncularVariables() {
        return true;
    }

    public int getConstructType() {
        return this.getFingerprint();
    }

    public StructuredQName getObjectName() {
        return this.objectName;
    }

    public void setObjectName(StructuredQName structuredQName) {
        this.objectName = structuredQName;
    }

    public Object getProperty(String string) {
        return this.getAttributeValue("", string);
    }

    public Iterator<String> getProperties() {
        NodeInfo nodeInfo;
        NamePool namePool = this.getNamePool();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        AxisIterator axisIterator = this.iterateAxis((byte)2);
        while ((nodeInfo = axisIterator.next()) != null) {
            arrayList.add(namePool.getClarkName(nodeInfo.getNameCode()));
        }
        return arrayList.iterator();
    }

    public String getSystemId(long l2) {
        return this.getSystemId();
    }

    public int getLineNumber(long l2) {
        return this.getLineNumber();
    }

    public int getColumnNumber(long l2) {
        return this.getColumnNumber();
    }

    public int getHostLanguage() {
        return 50;
    }

    public boolean isActionCompleted(int n2) {
        return (this.actionsCompleted & n2) != 0;
    }

    public void setActionCompleted(int n2) {
        this.actionsCompleted |= n2;
    }
}

