/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key;

import de.schlichtherle.key.AbstractKeyProvider;
import de.schlichtherle.key.KeyPromptingCancelledException;
import de.schlichtherle.key.KeyProvider;
import de.schlichtherle.key.PromptingKeyManager;
import de.schlichtherle.key.PromptingKeyProviderUI;
import de.schlichtherle.key.UnknownKeyException;

public class PromptingKeyProvider
extends AbstractKeyProvider {
    private final PromptingLock lock = new PromptingLock();
    private String resourceID;
    private PromptingKeyProviderUI ui;
    private State state = Reset.access$100();

    public synchronized String getResourceID() {
        return this.resourceID;
    }

    final synchronized void setResourceID(String string) {
        this.resourceID = string;
    }

    protected String getUIClassID() {
        return "PromptingKeyProvider";
    }

    private final synchronized PromptingKeyProviderUI getUI() {
        return this.ui;
    }

    final synchronized void setUI(PromptingKeyProviderUI promptingKeyProviderUI) {
        this.ui = promptingKeyProviderUI;
    }

    private final synchronized State getState() {
        return this.state;
    }

    private final synchronized void setState(State state) {
        this.state = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getCreateKeyImpl() throws UnknownKeyException {
        PromptingLock promptingLock = this.lock;
        synchronized (promptingLock) {
            return this.getState().getCreateKey(this);
        }
    }

    private Object promptCreateKey() throws UnknownKeyException {
        Object object;
        PromptingKeyManager.ensurePrompting();
        Object object2 = this.getKey();
        try {
            object = this.getUI();
            object.promptCreateKey(this);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof UnknownKeyException) {
                throw (UnknownKeyException)throwable;
            }
            throw runtimeException;
        }
        this.resetKey(object2);
        object = this.getKey();
        if (object != null) {
            this.setState(KeyChanged.STATE);
            return object;
        }
        this.setState(Cancelled.STATE);
        throw new KeyPromptingCancelledException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getOpenKeyImpl() throws UnknownKeyException {
        PromptingLock promptingLock = this.lock;
        synchronized (promptingLock) {
            return this.getState().getOpenKey(this);
        }
    }

    private Object promptOpenKey(boolean bl) throws UnknownKeyException {
        boolean bl2;
        Object object;
        PromptingKeyManager.ensurePrompting();
        Object object2 = this.getKey();
        try {
            object = this.getUI();
            bl2 = bl ? object.promptInvalidOpenKey(this) : object.promptUnknownOpenKey(this);
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof UnknownKeyException) {
                throw (UnknownKeyException)throwable;
            }
            throw runtimeException;
        }
        this.resetKey(object2);
        object = this.getKey();
        if (object != null) {
            if (bl2) {
                this.setState(KeyChangeRequested.STATE);
            } else {
                this.setState(KeyProvided.STATE);
            }
            return object;
        }
        this.setState(Cancelled.STATE);
        throw new KeyPromptingCancelledException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetKey(Object object) {
        if (object != null && object != this.getKey()) {
            Object object2 = this.getKey();
            try {
                this.setKey(object);
                this.resetKey();
            }
            finally {
                this.setKey(object2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidOpenKeyImpl() {
        PromptingLock promptingLock = this.lock;
        synchronized (promptingLock) {
            this.getState().invalidOpenKey(this);
        }
    }

    final void resetCancelledPrompt() {
        this.getState().resetCancelledPrompt(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reset() {
        this.setState(Reset.STATE);
        try {
            this.resetKey();
        }
        finally {
            this.onReset();
        }
    }

    protected void onReset() {
    }

    protected synchronized KeyProvider addToKeyManager(String string) throws NullPointerException, IllegalStateException {
        String string2 = this.getResourceID();
        if (string2 != null && !string2.equals(string)) {
            throw new IllegalStateException("PromptingKeyProvider instances cannot be shared!");
        }
        KeyProvider keyProvider = super.addToKeyManager(string);
        this.setResourceID(string);
        return keyProvider;
    }

    protected synchronized KeyProvider removeFromKeyManager(String string) throws NullPointerException, IllegalStateException {
        KeyProvider keyProvider = super.removeFromKeyManager(this.getResourceID());
        this.setResourceID(null);
        return keyProvider;
    }

    private static class PromptingLock {
        private PromptingLock() {
        }
    }

    private static class Cancelled
    extends State {
        private static final State STATE = new Cancelled();

        private Cancelled() {
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            throw new KeyPromptingCancelledException();
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            throw new KeyPromptingCancelledException();
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }

        public void resetCancelledPrompt(PromptingKeyProvider promptingKeyProvider) {
            promptingKeyProvider.reset();
        }
    }

    private static class KeyChanged
    extends KeyProvided {
        private static final State STATE = new KeyChanged();

        private KeyChanged() {
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }
    }

    private static class KeyChangeRequested
    extends KeyProvided {
        private static final State STATE = new KeyChangeRequested();

        private KeyChangeRequested() {
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptCreateKey();
        }
    }

    private static class KeyProvided
    extends State {
        private static final State STATE = new KeyProvided();

        private KeyProvided() {
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.getKey();
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) {
            return promptingKeyProvider.getKey();
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
            promptingKeyProvider.setState(KeyInvalidated.STATE);
        }
    }

    private static class KeyInvalidated
    extends Reset {
        private static final State STATE = new KeyInvalidated();

        private KeyInvalidated() {
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptOpenKey(true);
        }
    }

    private static class Reset
    extends State {
        private static final State STATE = new Reset();

        private Reset() {
        }

        public Object getCreateKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptCreateKey();
        }

        public Object getOpenKey(PromptingKeyProvider promptingKeyProvider) throws UnknownKeyException {
            return promptingKeyProvider.promptOpenKey(false);
        }

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }
    }

    private static abstract class State {
        private State() {
        }

        public abstract Object getCreateKey(PromptingKeyProvider var1) throws UnknownKeyException;

        public abstract Object getOpenKey(PromptingKeyProvider var1) throws UnknownKeyException;

        public void invalidOpenKey(PromptingKeyProvider promptingKeyProvider) {
        }

        public void resetCancelledPrompt(PromptingKeyProvider promptingKeyProvider) {
        }
    }
}

