/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io;

import de.schlichtherle.io.ArchiveBusyException;
import de.schlichtherle.io.ArchiveController;
import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.ArchiveFileSystem;
import de.schlichtherle.io.ContainsFileException;
import de.schlichtherle.io.File;
import de.schlichtherle.io.FileBusyException;
import de.schlichtherle.io.IORunnable;
import de.schlichtherle.io.InputIOException;
import de.schlichtherle.io.Streams;
import de.schlichtherle.io.archive.spi.ArchiveEntry;
import de.schlichtherle.io.archive.spi.RfsEntry;
import de.schlichtherle.io.util.Paths;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Arrays;

final class Files {
    private static final CopyLock copyLock;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Files() {
    }

    public static boolean contains(java.io.File file, java.io.File file2) {
        file = Files.getCanOrAbsFile(file);
        file2 = Files.getCanOrAbsFile(file2);
        return Files.contains(file.getPath(), file2.getPath());
    }

    static boolean contains(String string, String string2) {
        int n;
        if (File.separatorChar == '\\') {
            string = string.toLowerCase();
            string2 = string2.toLowerCase();
        }
        if (!string2.startsWith(string)) {
            return false;
        }
        int n2 = string.length();
        if (n2 == (n = string2.length())) {
            return true;
        }
        if (n2 < n) {
            return string2.charAt(n2) == File.separatorChar;
        }
        return false;
    }

    public static java.io.File getCanOrAbsFile(java.io.File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            java.io.File file2 = file.getParentFile();
            return Files.normalize(file2 != null ? new java.io.File(Files.getCanOrAbsFile(file2), file.getName()) : file.getAbsoluteFile());
        }
    }

    public static java.io.File normalize(java.io.File file) {
        String string = file.getPath();
        String string2 = Paths.normalize(string, File.separatorChar);
        return string2 != string ? new java.io.File(string2) : file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWritableOrCreatable(java.io.File file) {
        try {
            if (!file.exists()) {
                boolean bl = file.createNewFile();
                boolean bl2 = Files.isWritableOrCreatable(file);
                if (bl && !file.delete()) {
                    bl2 = false;
                }
                return bl2;
            }
            if (file.canWrite()) {
                boolean bl;
                long l = file.lastModified();
                if (!file.setLastModified(l + 1L)) {
                    return false;
                }
                try {
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rwd");
                    try {
                        boolean bl3;
                        int n = randomAccessFile.read();
                        if (n == -1) {
                            n = 0;
                            bl3 = true;
                        } else {
                            bl3 = false;
                        }
                        randomAccessFile.seek(0L);
                        randomAccessFile.write(~n & 0xFF);
                        try {
                            randomAccessFile.seek(0L);
                            randomAccessFile.write(n);
                            randomAccessFile.seek(0L);
                            int n2 = randomAccessFile.read();
                            bl = n == n2;
                        }
                        finally {
                            if (bl3) {
                                randomAccessFile.setLength(0L);
                            }
                        }
                    }
                    finally {
                        randomAccessFile.close();
                    }
                }
                finally {
                    if (!file.setLastModified(l)) {
                        bl = false;
                    }
                }
                return bl;
            }
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public static final boolean mv(java.io.File file, java.io.File file2, ArchiveDetector archiveDetector) {
        return !Files.contains(file, file2) && Files.mv0(file, file2, archiveDetector);
    }

    private static boolean mv0(java.io.File file, java.io.File file2, ArchiveDetector archiveDetector) {
        boolean bl = true;
        if (file.isDirectory()) {
            boolean bl2;
            long l = file.lastModified();
            boolean bl3 = file instanceof File && ((File)file).getInnerArchive() != null;
            boolean bl4 = file2 instanceof File && ((File)file2).getInnerArchive() != null;
            boolean bl5 = bl2 = bl3 && l <= 0L;
            if (!(bl2 && bl4 && File.isLenient())) {
                file2.mkdir();
            }
            Object[] objectArray = file.list();
            if (!bl3 && bl4) {
                Arrays.sort(objectArray);
            }
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                bl &= Files.mv0(archiveDetector.createFile(file, (String)object), archiveDetector.createFile(file2, (String)object), archiveDetector);
            }
            if (!bl2) {
                bl &= file2.setLastModified(l);
            }
        } else if (file.isFile()) {
            try {
                Files.cp(true, file, file2);
            }
            catch (IOException iOException) {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl && file.delete();
    }

    public static final void cp_r(boolean bl, java.io.File file, java.io.File file2, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) throws IOException {
        if (Files.contains(file, file2)) {
            throw new ContainsFileException(file, file2);
        }
        Files.cp_r0(bl, file, file2, archiveDetector, archiveDetector2);
    }

    private static void cp_r0(boolean bl, java.io.File file, java.io.File file2, ArchiveDetector archiveDetector, ArchiveDetector archiveDetector2) throws IOException {
        if (file.isDirectory()) {
            boolean bl2;
            long l = file.lastModified();
            boolean bl3 = file instanceof File && ((File)file).getInnerArchive() != null;
            boolean bl4 = file2 instanceof File && ((File)file2).getInnerArchive() != null;
            boolean bl5 = bl2 = bl3 && l <= 0L;
            if (!(bl2 && bl4 && File.isLenient() || file2.mkdir() || file2.isDirectory())) {
                throw new IOException("destination is not a directory");
            }
            Object[] objectArray = file.list();
            if (!bl3 && bl4) {
                Arrays.sort(objectArray);
            }
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                Object object = objectArray[i];
                Files.cp_r0(bl, archiveDetector.createFile(file, (String)object), archiveDetector2.createFile(file2, (String)object), archiveDetector, archiveDetector2);
            }
            if (bl && !bl2 && !file2.setLastModified(l)) {
                throw new IOException("cannot set last modification time");
            }
        } else if (file.isFile() && (!file2.exists() || file2.isFile())) {
            Files.cp0(bl, file, file2);
        } else {
            throw new IOException("cannot copy non-existent or special files");
        }
    }

    public static final void cp(boolean bl, java.io.File file, java.io.File file2) throws IOException {
        if (Files.contains(file, file2)) {
            throw new ContainsFileException(file, file2);
        }
        Files.cp0(bl, file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean bl, java.io.File file, java.io.File file2) throws IOException {
        if (!$assertionsDisabled && file == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && file2 == null) {
            throw new AssertionError();
        }
        try {
            Object object;
            try {
                if (file instanceof File) {
                    object = (File)file;
                    ((File)object).ensureNotVirtualRoot("cannot read");
                    String string = ((File)object).getEnclEntryName();
                    if (string != null) {
                        Files.cp0(bl, ((File)object).getEnclArchive().getArchiveController(), string, file2);
                        return;
                    }
                }
            }
            catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
                // empty catch block
            }
            object = new FileInputStream(file);
            try {
                Files.cp0(bl, file, (InputStream)object, file2);
            }
            finally {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException) {
                    throw new InputIOException(iOException);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (ArchiveBusyException archiveBusyException) {
            throw new FileBusyException(archiveBusyException);
        }
        catch (ArchiveFileSystem.ArchiveFileSystemException archiveFileSystemException) {
            FileNotFoundException fileNotFoundException = new FileNotFoundException(archiveFileSystemException.toString());
            fileNotFoundException.initCause(archiveFileSystemException);
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            file2.delete();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean bl, java.io.File file, InputStream inputStream, java.io.File file2) throws IOException {
        Object object;
        try {
            if (file2 instanceof File) {
                object = (File)file2;
                ((File)object).ensureNotVirtualRoot("cannot write");
                String string = ((File)object).getEnclEntryName();
                if (string != null) {
                    Files.cp0(bl, file, inputStream, ((File)object).getEnclArchive().getArchiveController(), string);
                    return;
                }
            }
        }
        catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
            // empty catch block
        }
        object = new FileOutputStream(file2);
        try {
            Streams.cat(inputStream, (OutputStream)object);
        }
        finally {
            ((OutputStream)object).close();
        }
        if (bl && !file2.setLastModified(file.lastModified())) {
            throw new IOException(file2.getPath() + " (cannot preserve last modification time)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean bl, ArchiveController archiveController, String string, java.io.File file) throws IOException {
        try {
            FileOutputStream fileOutputStream;
            long l;
            Object object;
            block15: {
                try {
                    if (file instanceof File) {
                        object = (File)file;
                        ((File)object).ensureNotVirtualRoot("cannot write");
                        String string2 = ((File)object).getEnclEntryName();
                        if (string2 != null) {
                            Files.cp0(bl, archiveController, string, ((File)object).getEnclArchive().getArchiveController(), string2);
                            return;
                        }
                    }
                }
                catch (ArchiveController.RfsEntryFalsePositiveException rfsEntryFalsePositiveException) {
                    if (rfsEntryFalsePositiveException.getController() != archiveController) break block15;
                    throw rfsEntryFalsePositiveException;
                }
            }
            archiveController.readLock().lock();
            try {
                object = archiveController.createInputStream0(string);
                l = archiveController.lastModified(string);
            }
            finally {
                archiveController.readLock().unlock();
            }
            try {
                fileOutputStream = new FileOutputStream(file);
            }
            catch (IOException iOException) {
                try {
                    ((InputStream)object).close();
                }
                catch (IOException iOException2) {
                    throw new InputIOException(iOException2);
                }
                throw iOException;
            }
            Files.cp((InputStream)object, fileOutputStream);
            if (bl && !file.setLastModified(l)) {
                throw new IOException(file.getPath() + " (cannot preserve last modification time)");
            }
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            if (!$assertionsDisabled && archiveController != archiveEntryFalsePositiveException.getController()) {
                throw new AssertionError();
            }
            Files.cp0(bl, archiveController.getEnclController(), archiveController.enclEntryName(string), file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp0(boolean bl, ArchiveController archiveController, String string, ArchiveController archiveController2, String string2) throws IOException {
        try {
            class IOStreamCreator
            implements IORunnable {
                InputStream in;
                OutputStream out;
                private final /* synthetic */ ArchiveController val$srcController;
                private final /* synthetic */ String val$srcEntryName;
                private final /* synthetic */ ArchiveController val$dstController;
                private final /* synthetic */ String val$dstEntryName;
                private final /* synthetic */ boolean val$preserve;

                IOStreamCreator(ArchiveController archiveController, String string, ArchiveController archiveController2, String string2, boolean bl) {
                    this.val$srcController = archiveController;
                    this.val$srcEntryName = string;
                    this.val$dstController = archiveController2;
                    this.val$dstEntryName = string2;
                    this.val$preserve = bl;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    ArchiveEntry archiveEntry;
                    ArchiveFileSystem.Delta delta;
                    ArchiveEntry archiveEntry2;
                    class SrcControllerUpdater
                    implements IORunnable {
                        SrcControllerUpdater() {
                        }

                        public void run() throws IOException {
                            val$srcController.autoUmount(val$srcEntryName);
                            val$srcController.readLock().lock();
                        }
                    }
                    this.val$srcController.runWriteLocked(new SrcControllerUpdater());
                    try {
                        this.val$dstController.autoUmount(this.val$dstEntryName);
                        ArchiveFileSystem archiveFileSystem = this.val$srcController.autoMount(false);
                        archiveEntry2 = archiveFileSystem.get(this.val$srcEntryName);
                        boolean bl = File.isLenient();
                        ArchiveFileSystem archiveFileSystem2 = this.val$dstController.autoMount(bl);
                        delta = archiveFileSystem2.link(this.val$dstEntryName, bl, this.val$preserve ? archiveEntry2 : null);
                        archiveEntry = delta.getEntry();
                        this.in = this.val$srcController.createInputStream(archiveEntry2, archiveEntry);
                    }
                    finally {
                        this.val$srcController.readLock().unlock();
                    }
                    try {
                        this.out = this.val$dstController.createOutputStream(archiveEntry, archiveEntry2);
                        try {
                            delta.commit();
                        }
                        catch (IOException iOException) {
                            this.out.close();
                            throw iOException;
                        }
                    }
                    catch (IOException iOException) {
                        try {
                            this.in.close();
                        }
                        catch (IOException iOException2) {
                            throw new InputIOException(iOException2);
                        }
                        throw iOException;
                    }
                }
            }
            IOStreamCreator iOStreamCreator = new IOStreamCreator(archiveController, string, archiveController2, string2, bl);
            CopyLock copyLock = Files.copyLock;
            synchronized (copyLock) {
                archiveController2.runWriteLocked(iOStreamCreator);
            }
            Files.cp(iOStreamCreator.in, iOStreamCreator.out);
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            if (archiveController2 != archiveEntryFalsePositiveException.getController()) {
                throw archiveEntryFalsePositiveException;
            }
            Files.cp0(bl, archiveController, string, archiveController2.getEnclController(), archiveController2.enclEntryName(string2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final void cp0(boolean bl, java.io.File file, InputStream inputStream, ArchiveController archiveController, String string) throws IOException {
        try {
            class OStreamCreator
            implements IORunnable {
                OutputStream out;
                private final /* synthetic */ ArchiveController val$dstController;
                private final /* synthetic */ String val$dstEntryName;
                private final /* synthetic */ java.io.File val$src;
                private final /* synthetic */ boolean val$preserve;

                OStreamCreator(ArchiveController archiveController, String string, java.io.File file, boolean bl) {
                    this.val$dstController = archiveController;
                    this.val$dstEntryName = string;
                    this.val$src = file;
                    this.val$preserve = bl;
                }

                public void run() throws IOException {
                    this.val$dstController.autoUmount(this.val$dstEntryName);
                    boolean bl = File.isLenient();
                    RfsEntry rfsEntry = new RfsEntry(this.val$src);
                    ArchiveFileSystem archiveFileSystem = this.val$dstController.autoMount(bl);
                    ArchiveFileSystem.Delta delta = archiveFileSystem.link(this.val$dstEntryName, bl, this.val$preserve ? rfsEntry : null);
                    ArchiveEntry archiveEntry = delta.getEntry();
                    this.out = this.val$dstController.createOutputStream(archiveEntry, rfsEntry);
                    delta.commit();
                }
            }
            OStreamCreator oStreamCreator = new OStreamCreator(archiveController, string, file, bl);
            archiveController.runWriteLocked(oStreamCreator);
            OutputStream outputStream = oStreamCreator.out;
            try {
                Streams.cat(inputStream, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        catch (ArchiveController.ArchiveEntryFalsePositiveException archiveEntryFalsePositiveException) {
            if (!$assertionsDisabled && archiveController != archiveEntryFalsePositiveException.getController()) {
                throw new AssertionError();
            }
            Files.cp0(bl, file, inputStream, archiveController.getEnclController(), archiveController.enclEntryName(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cp(InputStream inputStream, OutputStream outputStream) throws IOException {
        try {
            try {
                Streams.cat(inputStream, outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                throw new InputIOException(iOException);
            }
        }
    }

    public static boolean rm_r(java.io.File file) {
        boolean bl = true;
        if (file.isDirectory()) {
            java.io.File[] fileArray = file.listFiles();
            int n = fileArray.length;
            while (--n >= 0) {
                bl &= Files.rm_r(fileArray[n]);
            }
        }
        return bl && file.delete();
    }

    static {
        $assertionsDisabled = !Files.class.desiredAssertionStatus();
        copyLock = new CopyLock();
    }

    private static class CopyLock {
        private CopyLock() {
        }
    }
}

