/*
 * Decompiled with CFR 0.152.
 */
package org.libjpegturbo.turbojpeg;

import java.awt.image.BufferedImage;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.Closeable;
import java.nio.ByteOrder;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJException;
import org.libjpegturbo.turbojpeg.TJLoader;
import org.libjpegturbo.turbojpeg.YUVImage;

public class TJCompressor
implements Closeable {
    private static final String NO_ASSOC_ERROR = "No source image is associated with this instance";
    private long handle = 0L;
    private byte[] srcBuf = null;
    private int[] srcBufInt = null;
    private int srcWidth = 0;
    private int srcHeight = 0;
    private int srcX = -1;
    private int srcY = -1;
    private int srcPitch = 0;
    private int srcStride = 0;
    private int srcPixelFormat = -1;
    private YUVImage srcYUVImage = null;
    private int subsamp = -1;
    private int jpegQuality = -1;
    private int compressedSize = 0;
    private int yuvPad = 4;
    private ByteOrder byteOrder = null;

    public TJCompressor() throws TJException {
        this.init();
    }

    public TJCompressor(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) throws TJException {
        this.setSourceImage(byArray, n, n2, n3, n4, n5, n6);
    }

    @Deprecated
    public TJCompressor(byte[] byArray, int n, int n2, int n3, int n4) throws TJException {
        this.setSourceImage(byArray, n, n2, n3, n4);
    }

    public TJCompressor(BufferedImage bufferedImage, int n, int n2, int n3, int n4) throws TJException {
        this.setSourceImage(bufferedImage, n, n2, n3, n4);
    }

    public void setSourceImage(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) throws TJException {
        if (this.handle == 0L) {
            this.init();
        }
        if (byArray == null || n < 0 || n2 < 0 || n3 < 1 || n5 < 1 || n4 < 0 || n6 < 0 || n6 >= 12) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcBuf = byArray;
        this.srcWidth = n3;
        this.srcPitch = n4 == 0 ? n3 * TJ.getPixelSize(n6) : n4;
        this.srcHeight = n5;
        this.srcPixelFormat = n6;
        this.srcX = n;
        this.srcY = n2;
        this.srcBufInt = null;
        this.srcYUVImage = null;
    }

    @Deprecated
    public void setSourceImage(byte[] byArray, int n, int n2, int n3, int n4) throws TJException {
        this.setSourceImage(byArray, 0, 0, n, n2, n3, n4);
        this.srcY = -1;
        this.srcX = -1;
    }

    public void setSourceImage(BufferedImage bufferedImage, int n, int n2, int n3, int n4) throws TJException {
        int n5;
        if (this.handle == 0L) {
            this.init();
        }
        if (bufferedImage == null || n < 0 || n2 < 0 || n3 < 0 || n4 < 0) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcX = n;
        this.srcY = n2;
        this.srcWidth = n3 == 0 ? bufferedImage.getWidth() : n3;
        int n6 = this.srcHeight = n4 == 0 ? bufferedImage.getHeight() : n4;
        if (n + n3 > bufferedImage.getWidth() || n2 + n4 > bufferedImage.getHeight()) {
            throw new IllegalArgumentException("Compression region exceeds the bounds of the source image");
        }
        boolean bl = false;
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.nativeOrder();
        }
        switch (bufferedImage.getType()) {
            case 5: {
                n5 = 1;
                break;
            }
            case 6: 
            case 7: {
                n5 = 4;
                break;
            }
            case 10: {
                n5 = 6;
                break;
            }
            case 4: {
                n5 = this.byteOrder == ByteOrder.BIG_ENDIAN ? 4 : 2;
                bl = true;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n5 = this.byteOrder == ByteOrder.BIG_ENDIAN ? 5 : 3;
                bl = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported BufferedImage format");
            }
        }
        this.srcPixelFormat = n5;
        WritableRaster writableRaster = bufferedImage.getRaster();
        if (bl) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)bufferedImage.getSampleModel();
            this.srcStride = singlePixelPackedSampleModel.getScanlineStride();
            DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
            this.srcBufInt = dataBufferInt.getData();
            this.srcBuf = null;
        } else {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)bufferedImage.getSampleModel();
            int n7 = componentSampleModel.getPixelStride();
            if (n7 != TJ.getPixelSize(n5)) {
                throw new IllegalArgumentException("Inconsistency between pixel format and pixel size in BufferedImage");
            }
            this.srcPitch = componentSampleModel.getScanlineStride();
            DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
            this.srcBuf = dataBufferByte.getData();
            this.srcBufInt = null;
        }
        this.srcYUVImage = null;
    }

    public void setSourceImage(YUVImage yUVImage) throws TJException {
        if (this.handle == 0L) {
            this.init();
        }
        if (yUVImage == null) {
            throw new IllegalArgumentException("Invalid argument in setSourceImage()");
        }
        this.srcYUVImage = yUVImage;
        this.srcBuf = null;
        this.srcBufInt = null;
    }

    public void setSubsamp(int n) {
        if (n < 0 || n >= 6) {
            throw new IllegalArgumentException("Invalid argument in setSubsamp()");
        }
        this.subsamp = n;
    }

    public void setJPEGQuality(int n) {
        if (n < 1 || n > 100) {
            throw new IllegalArgumentException("Invalid argument in setJPEGQuality()");
        }
        this.jpegQuality = n;
    }

    public void compress(byte[] byArray, int n) throws TJException {
        if (byArray == null || n < 0) {
            throw new IllegalArgumentException("Invalid argument in compress()");
        }
        if (this.srcBuf == null && this.srcBufInt == null && this.srcYUVImage == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.jpegQuality < 0) {
            throw new IllegalStateException("JPEG Quality not set");
        }
        if (this.subsamp < 0 && this.srcYUVImage == null) {
            throw new IllegalStateException("Subsampling level not set");
        }
        if (this.srcYUVImage != null) {
            this.compressedSize = this.compressFromYUV(this.srcYUVImage.getPlanes(), this.srcYUVImage.getOffsets(), this.srcYUVImage.getWidth(), this.srcYUVImage.getStrides(), this.srcYUVImage.getHeight(), this.srcYUVImage.getSubsamp(), byArray, this.jpegQuality, n);
        } else if (this.srcBuf != null) {
            this.compressedSize = this.srcX >= 0 && this.srcY >= 0 ? this.compress(this.srcBuf, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, byArray, this.subsamp, this.jpegQuality, n) : this.compress(this.srcBuf, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, byArray, this.subsamp, this.jpegQuality, n);
        } else if (this.srcBufInt != null) {
            this.compressedSize = this.srcX >= 0 && this.srcY >= 0 ? this.compress(this.srcBufInt, this.srcX, this.srcY, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, byArray, this.subsamp, this.jpegQuality, n) : this.compress(this.srcBufInt, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, byArray, this.subsamp, this.jpegQuality, n);
        }
    }

    public byte[] compress(int n) throws TJException {
        this.checkSourceImage();
        byte[] byArray = new byte[TJ.bufSize(this.srcWidth, this.srcHeight, this.subsamp)];
        this.compress(byArray, n);
        return byArray;
    }

    @Deprecated
    public void compress(BufferedImage bufferedImage, byte[] byArray, int n) throws TJException {
        this.setSourceImage(bufferedImage, 0, 0, 0, 0);
        this.compress(byArray, n);
    }

    @Deprecated
    public byte[] compress(BufferedImage bufferedImage, int n) throws TJException {
        this.setSourceImage(bufferedImage, 0, 0, 0, 0);
        return this.compress(n);
    }

    public void encodeYUV(YUVImage yUVImage, int n) throws TJException {
        if (yUVImage == null || n < 0) {
            throw new IllegalArgumentException("Invalid argument in encodeYUV()");
        }
        if (this.srcBuf == null && this.srcBufInt == null) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
        if (this.srcYUVImage != null) {
            throw new IllegalStateException("Source image is not correct type");
        }
        this.checkSubsampling();
        if (this.srcWidth != yUVImage.getWidth() || this.srcHeight != yUVImage.getHeight()) {
            throw new IllegalStateException("Destination image is the wrong size");
        }
        if (this.srcBufInt != null) {
            this.encodeYUV(this.srcBufInt, this.srcX, this.srcY, this.srcWidth, this.srcStride, this.srcHeight, this.srcPixelFormat, yUVImage.getPlanes(), yUVImage.getOffsets(), yUVImage.getStrides(), yUVImage.getSubsamp(), n);
        } else {
            this.encodeYUV(this.srcBuf, this.srcX, this.srcY, this.srcWidth, this.srcPitch, this.srcHeight, this.srcPixelFormat, yUVImage.getPlanes(), yUVImage.getOffsets(), yUVImage.getStrides(), yUVImage.getSubsamp(), n);
        }
        this.compressedSize = 0;
    }

    @Deprecated
    public void encodeYUV(byte[] byArray, int n) throws TJException {
        if (byArray == null) {
            throw new IllegalArgumentException("Invalid argument in encodeYUV()");
        }
        this.checkSourceImage();
        this.checkSubsampling();
        YUVImage yUVImage = new YUVImage(byArray, this.srcWidth, 4, this.srcHeight, this.subsamp);
        this.encodeYUV(yUVImage, n);
    }

    public YUVImage encodeYUV(int n, int n2) throws TJException {
        this.checkSourceImage();
        this.checkSubsampling();
        if (n < 1 || (n & n - 1) != 0) {
            throw new IllegalStateException("Invalid argument in encodeYUV()");
        }
        YUVImage yUVImage = new YUVImage(this.srcWidth, n, this.srcHeight, this.subsamp);
        this.encodeYUV(yUVImage, n2);
        return yUVImage;
    }

    public YUVImage encodeYUV(int[] nArray, int n) throws TJException {
        this.checkSourceImage();
        this.checkSubsampling();
        YUVImage yUVImage = new YUVImage(this.srcWidth, nArray, this.srcHeight, this.subsamp);
        this.encodeYUV(yUVImage, n);
        return yUVImage;
    }

    @Deprecated
    public byte[] encodeYUV(int n) throws TJException {
        this.checkSourceImage();
        this.checkSubsampling();
        YUVImage yUVImage = new YUVImage(this.srcWidth, 4, this.srcHeight, this.subsamp);
        this.encodeYUV(yUVImage, n);
        return yUVImage.getBuf();
    }

    @Deprecated
    public void encodeYUV(BufferedImage bufferedImage, byte[] byArray, int n) throws TJException {
        this.setSourceImage(bufferedImage, 0, 0, 0, 0);
        this.encodeYUV(byArray, n);
    }

    @Deprecated
    public byte[] encodeYUV(BufferedImage bufferedImage, int n) throws TJException {
        this.setSourceImage(bufferedImage, 0, 0, 0, 0);
        return this.encodeYUV(n);
    }

    public int getCompressedSize() {
        return this.compressedSize;
    }

    @Override
    public void close() throws TJException {
        if (this.handle != 0L) {
            this.destroy();
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        catch (TJException tJException) {
        }
        finally {
            super.finalize();
        }
    }

    private native void init() throws TJException;

    private native void destroy() throws TJException;

    @Deprecated
    private native int compress(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws TJException;

    private native int compress(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8, int var9, int var10, int var11) throws TJException;

    @Deprecated
    private native int compress(int[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8, int var9) throws TJException;

    private native int compress(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[] var8, int var9, int var10, int var11) throws TJException;

    private native int compressFromYUV(byte[][] var1, int[] var2, int var3, int[] var4, int var5, int var6, byte[] var7, int var8, int var9) throws TJException;

    @Deprecated
    private native void encodeYUV(byte[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8) throws TJException;

    private native void encodeYUV(byte[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[][] var8, int[] var9, int[] var10, int var11, int var12) throws TJException;

    @Deprecated
    private native void encodeYUV(int[] var1, int var2, int var3, int var4, int var5, byte[] var6, int var7, int var8) throws TJException;

    private native void encodeYUV(int[] var1, int var2, int var3, int var4, int var5, int var6, int var7, byte[][] var8, int[] var9, int[] var10, int var11, int var12) throws TJException;

    private void checkSourceImage() {
        if (this.srcWidth < 1 || this.srcHeight < 1) {
            throw new IllegalStateException(NO_ASSOC_ERROR);
        }
    }

    private void checkSubsampling() {
        if (this.subsamp < 0) {
            throw new IllegalStateException("Subsampling level not set");
        }
    }

    static {
        TJLoader.load();
    }
}

