commit() {
  [ ! -f $1/Pkgfile ] && return
  release=1
  . $1/Pkgfile
  if [ -z $version ]; then
     printf "ERROR: version is not set\n"
     return -1
  fi
  if [ -z $name ]; then
     name="$(basename $1)"
     printf "WARNING: name was not set\n"
  fi
  git add $1
  COMMENT="$name $version-$release"
  [ ! -z "$2" ] && COMMENT+="
$2"
  git commit -m "$COMMENT"
}
match_Pkgfile() {
	unset makedepends run
	for PKGFILE in $(find . -name Pkgfile | sort ); do
		DIR="$(dirname $PKGFILE)/"
		(cd $DIR && source Pkgfile && \
		for i in ${makedepends[@]} ${run[@]}; do [ "$1" == "$i" ] && \
		printf "($(basename $(dirname $DIR))) $name $version\n";done)
	done
}
match_Anything() {
	find . -name Pkgfile -exec grep -l $1 {} +
}
export -f commit match_Pkgfile match_Anything
