/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.sctp;

import com.sun.nio.sctp.AbstractNotificationHandler;
import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.IllegalUnbindException;
import com.sun.nio.sctp.InvalidStreamException;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.NotificationHandler;
import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpMultiChannel;
import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;
import sun.nio.ch.sctp.AssociationChange;
import sun.nio.ch.sctp.AssociationImpl;
import sun.nio.ch.sctp.ResultContainer;
import sun.nio.ch.sctp.SctpChannelImpl;
import sun.nio.ch.sctp.SctpNet;
import sun.nio.ch.sctp.SctpNotification;

public class SctpMultiChannelImpl
extends SctpMultiChannel
implements SelChImpl {
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long receiverThread = 0L;
    private volatile long senderThread = 0L;
    private final Object receiveLock = new Object();
    private final Object sendLock = new Object();
    private final Object stateLock = new Object();
    private ChannelState state = ChannelState.UNINITIALIZED;
    int port = -1;
    private HashSet<InetSocketAddress> localAddresses = new HashSet();
    private boolean wildcard;
    private HashMap<SocketAddress, Association> addressMap = new HashMap();
    private HashMap<Association, Set<SocketAddress>> associationMap = new HashMap();
    private final ThreadLocal<Association> associationToRemove = new ThreadLocal<Association>(){

        @Override
        protected Association initialValue() {
            return null;
        }
    };
    private final ThreadLocal<Boolean> receiveInvoked = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private InternalNotificationHandler internalNotificationHandler = new InternalNotificationHandler();

    public SctpMultiChannelImpl(SelectorProvider selectorProvider) throws IOException {
        super(selectorProvider);
        this.fd = SctpNet.socket(false);
        this.fdVal = IOUtil.fdVal(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpMultiChannel bind(SocketAddress socketAddress, int n) throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpen();
                    if (this.isBound()) {
                        SctpNet.throwAlreadyBoundException();
                    }
                    InetSocketAddress inetSocketAddress = socketAddress == null ? new InetSocketAddress(0) : Net.checkAddress(socketAddress);
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkListen(inetSocketAddress.getPort());
                    }
                    Net.bind(this.fd, inetSocketAddress.getAddress(), inetSocketAddress.getPort());
                    InetSocketAddress inetSocketAddress2 = Net.localAddress(this.fd);
                    this.port = inetSocketAddress2.getPort();
                    this.localAddresses.add(inetSocketAddress);
                    if (inetSocketAddress.getAddress().isAnyLocalAddress()) {
                        this.wildcard = true;
                    }
                    SctpNet.listen(this.fdVal, n < 1 ? 50 : n);
                }
            }
        }
        return this;
    }

    @Override
    public SctpMultiChannel bindAddress(InetAddress inetAddress) throws IOException {
        return this.bindUnbindAddress(inetAddress, true);
    }

    @Override
    public SctpMultiChannel unbindAddress(InetAddress inetAddress) throws IOException {
        return this.bindUnbindAddress(inetAddress, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpMultiChannel bindUnbindAddress(InetAddress inetAddress, boolean bl) throws IOException {
        if (inetAddress == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (!this.isBound()) {
                        throw new NotYetBoundException();
                    }
                    if (this.wildcard) {
                        throw new IllegalStateException("Cannot add or remove addresses from a channel that is bound to the wildcard address");
                    }
                    if (inetAddress.isAnyLocalAddress()) {
                        throw new IllegalArgumentException("Cannot add or remove the wildcard address");
                    }
                    if (bl) {
                        for (InetSocketAddress object4 : this.localAddresses) {
                            if (!object4.getAddress().equals(inetAddress)) continue;
                            SctpNet.throwAlreadyBoundException();
                        }
                    } else {
                        if (this.localAddresses.size() <= 1) {
                            throw new IllegalUnbindException("Cannot remove address from a channel with only one address bound");
                        }
                        boolean bl2 = false;
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(inetAddress)) continue;
                            bl2 = true;
                            break;
                        }
                        if (!bl2) {
                            throw new IllegalUnbindException("Cannot remove address from a channel that is not bound to that address");
                        }
                    }
                    SctpNet.bindx(this.fdVal, new InetAddress[]{inetAddress}, this.port, bl);
                    if (bl) {
                        this.localAddresses.add(new InetSocketAddress(inetAddress, this.port));
                    } else {
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(inetAddress)) continue;
                            this.localAddresses.remove(inetSocketAddress);
                            break;
                        }
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Association> associations() throws ClosedChannelException, NotYetBoundException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                throw new NotYetBoundException();
            }
            return Collections.unmodifiableSet(this.associationMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiverCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.receiverThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.senderThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    @Override
    protected void implConfigureBlocking(boolean bl) throws IOException {
        IOUtil.configureBlocking(this.fd, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            SctpNet.preClose(this.fdVal);
            if (this.receiverThread != 0L) {
                NativeThread.signal(this.receiverThread);
            }
            if (this.senderThread != 0L) {
                NativeThread.signal(this.senderThread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private boolean translateReadyOps(int n, int n2, SelectionKeyImpl selectionKeyImpl) {
        int n3 = selectionKeyImpl.nioInterestOps();
        int n4 = selectionKeyImpl.nioReadyOps();
        int n5 = n2;
        if ((n & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((n & (Net.POLLERR | Net.POLLHUP)) != 0) {
            n5 = n3;
            selectionKeyImpl.nioReadyOps(n5);
            return (n5 & ~n4) != 0;
        }
        if ((n & Net.POLLIN) != 0 && (n3 & 1) != 0) {
            n5 |= 1;
        }
        if ((n & Net.POLLOUT) != 0 && (n3 & 4) != 0) {
            n5 |= 4;
        }
        selectionKeyImpl.nioReadyOps(n5);
        return (n5 & ~n4) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, selectionKeyImpl.nioReadyOps(), selectionKeyImpl);
    }

    @Override
    public boolean translateAndSetReadyOps(int n, SelectionKeyImpl selectionKeyImpl) {
        return this.translateReadyOps(n, 0, selectionKeyImpl);
    }

    @Override
    public void translateAndSetInterestOps(int n, SelectionKeyImpl selectionKeyImpl) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= Net.POLLIN;
        }
        if ((n & 4) != 0) {
            n2 |= Net.POLLOUT;
        }
        selectionKeyImpl.selector.putEventOps(selectionKeyImpl, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == ChannelState.KILLED) {
                return;
            }
            if (this.state == ChannelState.UNINITIALIZED) {
                this.state = ChannelState.KILLED;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.receiverThread == 0L && this.senderThread == 0L) {
                SctpNet.close(this.fdVal);
                this.state = ChannelState.KILLED;
            } else {
                this.state = ChannelState.KILLPENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SctpMultiChannel setOption(SctpSocketOption<T> sctpSocketOption, T t, Association association) throws IOException {
        if (sctpSocketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(sctpSocketOption)) {
            throw new UnsupportedOperationException("'" + sctpSocketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (association != null && (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR))) {
                this.checkAssociation(association);
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int n = association == null ? 0 : association.associationID();
            SctpNet.setSocketOption(this.fdVal, sctpSocketOption, t, n);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SctpSocketOption<T> sctpSocketOption, Association association) throws IOException {
        if (sctpSocketOption == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(sctpSocketOption)) {
            throw new UnsupportedOperationException("'" + sctpSocketOption + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (association != null && (sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR) || sctpSocketOption.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR))) {
                this.checkAssociation(association);
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int n = association == null ? 0 : association.associationID();
            return (T)SctpNet.getSocketOption(this.fdVal, sctpSocketOption, n);
        }
    }

    @Override
    public final Set<SctpSocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> MessageInfo receive(ByteBuffer var1_1, T var2_2, NotificationHandler<T> var3_3) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(int n, ByteBuffer byteBuffer, ResultContainer resultContainer) throws IOException {
        int n2;
        int n3 = byteBuffer.position();
        int n4 = byteBuffer.limit();
        assert (n3 <= n4);
        int n5 = n2 = n3 <= n4 ? n4 - n3 : 0;
        if (byteBuffer instanceof DirectBuffer && n2 > 0) {
            return this.receiveIntoNativeBuffer(n, resultContainer, byteBuffer, n2, n3);
        }
        int n6 = Math.max(n2, 1);
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n6);
        try {
            int n7 = this.receiveIntoNativeBuffer(n, resultContainer, byteBuffer2, n6, 0);
            byteBuffer2.flip();
            if (n7 > 0 && n2 > 0) {
                byteBuffer.put(byteBuffer2);
            }
            int n8 = n7;
            return n8;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int receiveIntoNativeBuffer(int n, ResultContainer resultContainer, ByteBuffer byteBuffer, int n2, int n3) throws IOException {
        int n4 = SctpMultiChannelImpl.receive0(n, resultContainer, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n3, n2);
        if (n4 > 0) {
            byteBuffer.position(n3 + n4);
        }
        return n4;
    }

    private void handleNotificationInternal(ResultContainer resultContainer) {
        this.invokeNotificationHandler(resultContainer, this.internalNotificationHandler, null);
    }

    private <T> HandlerResult invokeNotificationHandler(ResultContainer resultContainer, NotificationHandler<T> notificationHandler, T t) {
        Object object;
        HandlerResult handlerResult;
        SctpNotification sctpNotification = resultContainer.notification();
        sctpNotification.setAssociation(this.lookupAssociation(sctpNotification.assocId()));
        if (!(notificationHandler instanceof AbstractNotificationHandler)) {
            handlerResult = notificationHandler.handleNotification(sctpNotification, t);
        } else {
            object = (AbstractNotificationHandler)notificationHandler;
            switch (resultContainer.type()) {
                case 3: {
                    handlerResult = ((AbstractNotificationHandler)object).handleNotification(resultContainer.getAssociationChanged(), t);
                    break;
                }
                case 4: {
                    handlerResult = ((AbstractNotificationHandler)object).handleNotification(resultContainer.getPeerAddressChanged(), t);
                    break;
                }
                case 2: {
                    handlerResult = ((AbstractNotificationHandler)object).handleNotification(resultContainer.getSendFailed(), t);
                    break;
                }
                case 5: {
                    handlerResult = ((AbstractNotificationHandler)object).handleNotification(resultContainer.getShutdown(), t);
                    break;
                }
                default: {
                    handlerResult = ((AbstractNotificationHandler)object).handleNotification(resultContainer.notification(), t);
                }
            }
        }
        if (!(notificationHandler instanceof InternalNotificationHandler) && (object = this.associationToRemove.get()) != null) {
            this.removeAssociation((Association)object);
            this.associationToRemove.set(null);
        }
        return handlerResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Association lookupAssociation(int n) {
        Object object = this.stateLock;
        synchronized (object) {
            Set<Association> set = this.associationMap.keySet();
            for (Association association : set) {
                if (association.associationID() != n) continue;
                return association;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAssociation(Association association) {
        Object object = this.stateLock;
        synchronized (object) {
            int n = association.associationID();
            Set<SocketAddress> set = null;
            try {
                set = SctpNet.getRemoteAddresses(this.fdVal, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.associationMap.put(association, set);
            if (set != null) {
                for (SocketAddress socketAddress : set) {
                    this.addressMap.put(socketAddress, association);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAssociation(Association association) {
        Object object = this.stateLock;
        synchronized (object) {
            int n = association.associationID();
            Set<SocketAddress> set = null;
            try {
                set = SctpNet.getRemoteAddresses(this.fdVal, n);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Set<Association> set2 = this.associationMap.keySet();
            for (Association object2 : set2) {
                if (object2.associationID() != n) continue;
                this.associationMap.remove(object2);
                break;
            }
            if (set != null) {
                for (SocketAddress socketAddress : set) {
                    this.addressMap.remove(socketAddress);
                }
            } else {
                Set<Map.Entry<SocketAddress, Association>> set3 = this.addressMap.entrySet();
                Iterator iterator = set3.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (!((Association)entry.getValue()).equals(association)) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAssociation(Association association) {
        Object object = this.stateLock;
        synchronized (object) {
            for (Association association2 : this.associationMap.keySet()) {
                if (!association.equals(association2)) continue;
                return true;
            }
        }
        throw new IllegalArgumentException("Given Association is not controlled by this channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStreamNumber(Association association, int n) {
        Object object = this.stateLock;
        synchronized (object) {
            if (n < 0 || n >= association.maxOutboundStreams()) {
                throw new InvalidStreamException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int send(ByteBuffer byteBuffer, MessageInfo messageInfo) throws IOException {
        int n;
        InetSocketAddress inetSocketAddress;
        int n2;
        int n3;
        block21: {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("buffer cannot be null");
            }
            if (messageInfo == null) {
                throw new IllegalArgumentException("messageInfo cannot be null");
            }
            Object object = this.sendLock;
            // MONITORENTER : object
            this.ensureOpen();
            if (!this.isBound()) {
                this.bind(null, 0);
            }
            n3 = 0;
            n2 = -1;
            inetSocketAddress = null;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block21;
            int n4 = 0;
            // MONITOREXIT : object2
            this.senderCleanup();
            this.end(n3 > 0 || n3 == -2);
            assert (IOStatus.check(n3));
            // MONITOREXIT : object
            return n4;
        }
        try {
            this.senderThread = NativeThread.current();
            Association association = messageInfo.association();
            InetSocketAddress inetSocketAddress2 = (InetSocketAddress)messageInfo.address();
            if (association != null) {
                this.checkAssociation(association);
                this.checkStreamNumber(association, messageInfo.streamNumber());
                n2 = association.associationID();
                if (inetSocketAddress2 != null) {
                    if (!association.equals(this.addressMap.get(inetSocketAddress2))) {
                        throw new IllegalArgumentException("given preferred address is not part of this association");
                    }
                    inetSocketAddress = inetSocketAddress2;
                }
            } else {
                if (inetSocketAddress2 == null) throw new AssertionError((Object)"Both association and address cannot be null");
                inetSocketAddress = inetSocketAddress2;
                Association association2 = this.addressMap.get(inetSocketAddress2);
                if (association2 != null) {
                    this.checkStreamNumber(association2, messageInfo.streamNumber());
                    n2 = association2.associationID();
                } else {
                    SecurityManager securityManager = System.getSecurityManager();
                    if (securityManager != null) {
                        securityManager.checkConnect(inetSocketAddress2.getAddress().getHostAddress(), inetSocketAddress2.getPort());
                    }
                }
            }
            // MONITOREXIT : object2
            while ((n3 = this.send(this.fdVal, byteBuffer, n2, inetSocketAddress, messageInfo)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n3);
        }
        catch (Throwable throwable) {
            this.senderCleanup();
            this.end(n3 > 0 || n3 == -2);
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n3)) throw throwable;
            throw new AssertionError();
        }
        this.senderCleanup();
        this.end(n3 > 0 || n3 == -2);
        assert (IOStatus.check(n3));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(int n, ByteBuffer byteBuffer, int n2, SocketAddress socketAddress, MessageInfo messageInfo) throws IOException {
        int n3 = messageInfo.streamNumber();
        boolean bl = messageInfo.isUnordered();
        int n4 = messageInfo.payloadProtocolID();
        if (byteBuffer instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(n, byteBuffer, socketAddress, n2, n3, bl, n4);
        }
        int n5 = byteBuffer.position();
        int n6 = byteBuffer.limit();
        assert (n5 <= n6 && n3 >= 0);
        int n7 = n5 <= n6 ? n6 - n5 : 0;
        ByteBuffer byteBuffer2 = Util.getTemporaryDirectBuffer(n7);
        try {
            byteBuffer2.put(byteBuffer);
            byteBuffer2.flip();
            byteBuffer.position(n5);
            int n8 = this.sendFromNativeBuffer(n, byteBuffer2, socketAddress, n2, n3, bl, n4);
            if (n8 > 0) {
                byteBuffer.position(n5 + n8);
            }
            int n9 = n8;
            return n9;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(byteBuffer2);
        }
    }

    private int sendFromNativeBuffer(int n, ByteBuffer byteBuffer, SocketAddress socketAddress, int n2, int n3, boolean bl, int n4) throws IOException {
        InetAddress inetAddress = null;
        int n5 = 0;
        if (socketAddress != null) {
            InetSocketAddress inetSocketAddress = Net.checkAddress(socketAddress);
            inetAddress = inetSocketAddress.getAddress();
            n5 = inetSocketAddress.getPort();
        }
        int n6 = byteBuffer.position();
        int n7 = byteBuffer.limit();
        assert (n6 <= n7);
        int n8 = n6 <= n7 ? n7 - n6 : 0;
        int n9 = SctpMultiChannelImpl.send0(n, ((DirectBuffer)((Object)byteBuffer)).address() + (long)n6, n8, inetAddress, n5, n2, n3, bl, n4);
        if (n9 > 0) {
            byteBuffer.position(n6 + n9);
        }
        return n9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpMultiChannel shutdown(Association association) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkAssociation(association);
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SctpNet.shutdown(this.fdVal, association.associationID());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getAllLocalAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                return Collections.emptySet();
            }
            return SctpNet.getLocalAddresses(this.fdVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getRemoteAddresses(Association association) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkAssociation(association);
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            try {
                return SctpNet.getRemoteAddresses(this.fdVal, association.associationID());
            }
            catch (SocketException socketException) {
                Set<SocketAddress> set = this.associationMap.get(association);
                return set != null ? set : Collections.emptySet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpChannel branch(Association association) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkAssociation(association);
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            FileDescriptor fileDescriptor = SctpNet.branch(this.fdVal, association.associationID());
            this.removeAssociation(association);
            return new SctpChannelImpl(this.provider(), fileDescriptor, association);
        }
    }

    private static int receive0(int n, ResultContainer resultContainer, long l, int n2) throws IOException {
        return SctpChannelImpl.receive0(n, resultContainer, l, n2, false);
    }

    private static int send0(int n, long l, int n2, InetAddress inetAddress, int n3, int n4, int n5, boolean bl, int n6) throws IOException {
        return SctpChannelImpl.send0(n, l, n2, inetAddress, n3, n4, n5, bl, n6);
    }

    static {
        IOUtil.load();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("sctp");
                return null;
            }
        });
    }

    private static enum ChannelState {
        UNINITIALIZED,
        KILLPENDING,
        KILLED;

    }

    private static class DefaultOptionsHolder {
        static final Set<SctpSocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SctpSocketOption<?>> defaultOptions() {
            HashSet<SctpSocketOption<Object>> hashSet = new HashSet<SctpSocketOption<Object>>(10);
            hashSet.add(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS);
            hashSet.add(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE);
            hashSet.add(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE);
            hashSet.add(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS);
            hashSet.add(SctpStandardSocketOptions.SCTP_NODELAY);
            hashSet.add(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR);
            hashSet.add(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR);
            hashSet.add(SctpStandardSocketOptions.SO_SNDBUF);
            hashSet.add(SctpStandardSocketOptions.SO_RCVBUF);
            hashSet.add(SctpStandardSocketOptions.SO_LINGER);
            return Collections.unmodifiableSet(hashSet);
        }
    }

    private class InternalNotificationHandler
    extends AbstractNotificationHandler<Object> {
        private InternalNotificationHandler() {
        }

        @Override
        public HandlerResult handleNotification(AssociationChangeNotification associationChangeNotification, Object object) {
            AssociationChange associationChange = (AssociationChange)associationChangeNotification;
            switch (associationChangeNotification.event()) {
                case COMM_UP: {
                    AssociationImpl associationImpl = new AssociationImpl(associationChange.assocId(), associationChange.maxInStreams(), associationChange.maxOutStreams());
                    SctpMultiChannelImpl.this.addAssociation(associationImpl);
                    break;
                }
                case SHUTDOWN: 
                case COMM_LOST: {
                    SctpMultiChannelImpl.this.associationToRemove.set(SctpMultiChannelImpl.this.lookupAssociation(associationChange.assocId()));
                }
            }
            return HandlerResult.CONTINUE;
        }
    }
}

