/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.config;

import com.sun.deploy.config.AutoUpdater;
import com.sun.deploy.config.Config;
import com.sun.deploy.config.DefaultConfig;
import com.sun.deploy.config.JREInfo;
import com.sun.deploy.config.OSType;
import com.sun.deploy.config.PlatformFactory;
import com.sun.deploy.nativesandbox.NativeSandboxBroker;
import com.sun.deploy.nativesandbox.NativeSandboxJNLPService;
import com.sun.deploy.nativesandbox.NoSandboxBroker;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.util.IcoEncoder;
import com.sun.deploy.util.IconEncoder;
import com.sun.deploy.util.SecurityBaseline;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Platform {
    protected static final boolean DEBUG = Config.getDeployDebug() || Config.getPluginDebug();
    private static Platform _platform;
    private Collection fx_runtimes = null;
    protected static final String UPGRADE_FILENAME = "CacheUpgrade.properties";
    protected AutoUpdater auInstance;
    protected IconEncoder ieInstance;
    protected NativeSandboxBroker sandboxBroker;

    public static void setInstance(Platform platform) {
        _platform = platform;
    }

    public static Platform get() {
        if (_platform == null) {
            Platform.setInstance(PlatformFactory.newInstance());
        }
        return _platform;
    }

    public abstract void addRemoveProgramsAdd(String var1, String var2, String var3, String var4, String var5, String var6, boolean var7);

    public abstract void cacheSecurityBaseline(String var1, String var2);

    public abstract void addRemoveProgramsRemove(String var1, boolean var2);

    public abstract boolean canAutoDownloadJRE();

    public boolean canUseAlternateJREs() {
        return true;
    }

    public abstract String getBrowserPath();

    public abstract String getBrowserHomePath();

    public abstract String getDefaultSystemCache();

    public abstract String getFireFoxUserProfileDirectory();

    public abstract boolean canBecomeAdmin();

    public abstract boolean hasAdminPrivileges();

    public abstract List<JREInfo> getInstalledJREList();

    public abstract String getLibrarySufix();

    public abstract String getLibraryPrefix();

    public abstract String getMozillaUserProfileDirectory();

    public abstract long getNativePID();

    public abstract String getSessionSpecificString();

    public abstract String getSystemJavawsPath();

    public abstract int[] getIconSizes();

    public abstract int getSystemShortcutIconSize(boolean var1);

    public abstract int installShortcut(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

    public abstract int updateShortcut(String var1, String var2);

    public abstract String getShortcutJnlpName(String var1);

    public abstract boolean isBrowserFireFox();

    public abstract boolean isLocalInstallSupported();

    public abstract boolean isNativeModalDialogUp();

    public abstract boolean isPlatformIconType(String var1);

    public abstract boolean isPlatformWindowsVista();

    public abstract void loadDeployNativeLib();

    public abstract void sendJFXPing(String var1, String var2, String var3, String var4, String var5, int var6, String var7);

    public abstract void setUserHomeOverride(String var1);

    public boolean updateJava(String string) {
        return this.showDocument(string);
    }

    public abstract boolean showDocument(String var1);

    public abstract boolean getJavaPluginSettings();

    public abstract int setJavaPluginSettings(boolean var1);

    public boolean getSponsorOffersDisabledSettings() {
        return false;
    }

    public void enableSponsorOffering(boolean bl) {
    }

    public void enableRoamingProfile(boolean bl) {
    }

    public abstract void initBrowserSettings();

    public abstract int applyBrowserSettings();

    public abstract boolean systemLookAndFeelDefault();

    public abstract String getUserHome();

    public String getLocalStorageDir() {
        return this.getUserHome();
    }

    public abstract String getRoamingUserHome();

    public abstract void cacheCurrentConfig(Properties var1);

    public abstract String getUserHomeOverride();

    public abstract String getOSHome();

    public abstract String getSystemHome();

    public abstract String getPlatformSpecificJavaName();

    public abstract String getPlatformExtension();

    public abstract String getDebugJavaPath(String var1);

    public abstract String getLongPathName(String var1);

    public abstract boolean samePaths(String var1, String var2);

    public abstract int getPlatformMaxCommandLineLength();

    public abstract boolean useAltFileSystemView();

    public abstract String toExecArg(String var1);

    public abstract void onLoad(Object var1);

    public abstract void onSave(Object var1);

    public abstract boolean shouldPromptForAutoCheck();

    public abstract void handleUserResponse(int var1);

    public abstract void resetJavaHome();

    public abstract String findSecureLauncher(File var1);

    void setDefaultConfigProperties(DefaultConfig defaultConfig) {
    }

    public String getJucheckPath() {
        return null;
    }

    public String getPlatformNativeEncoding() {
        return "UTF-8";
    }

    public void storeCacheUpgradeInfo(final Properties properties) {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws IOException {
                    if (properties == null) {
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (file.exists()) {
                            file.delete();
                        }
                        return null;
                    }
                    OutputStream outputStream = null;
                    try {
                        Properties properties2 = Platform.this.getCacheUpgradeProperties();
                        properties2.putAll((Map<?, ?>)properties);
                        File file = new File(Platform.this.getUserHome(), Platform.UPGRADE_FILENAME);
                        if (!file.exists()) {
                            file.createNewFile();
                        }
                        outputStream = new FileOutputStream(file);
                        properties2.store(outputStream, "");
                    }
                    finally {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException, true);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
    }

    public Properties getCacheUpgradeInfo(String[] stringArray) {
        Properties properties = this.getCacheUpgradeProperties();
        Properties properties2 = new Properties();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = properties.getProperty(stringArray[i]);
            if (string == null) continue;
            properties2.put(stringArray[i], string);
        }
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties getCacheUpgradeProperties() {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            final File file = new File(this.getUserHome(), UPGRADE_FILENAME);
            inputStream = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    if (file.isFile()) {
                        return new FileInputStream(file);
                    }
                    return null;
                }
            });
            if (inputStream != null) {
                properties.load(inputStream);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            Trace.ignored(privilegedActionException, true);
        }
        catch (Exception exception) {
            Trace.ignored(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        }
        return properties;
    }

    public abstract String getLoadedNativeLibPath(String var1);

    public synchronized AutoUpdater getAutoUpdater() {
        if (this.auInstance == null) {
            this.auInstance = new AutoUpdater();
        }
        return this.auInstance;
    }

    public synchronized IconEncoder getIconEncoder() {
        if (this.ieInstance == null) {
            this.ieInstance = new IcoEncoder();
        }
        return this.ieInstance;
    }

    public String getPlatformIconType() {
        return "ico";
    }

    public boolean isGTKAvailable(int n, int n2, int n3) {
        return false;
    }

    public String getDefaultIconPath() {
        return null;
    }

    public Properties getPendingConfigProperties() {
        return null;
    }

    public Process startProcessBuilder(ProcessBuilder processBuilder) throws IOException {
        return processBuilder.start();
    }

    public void setRunInNativeSandbox(boolean bl) {
    }

    public boolean getRunInNativeSandbox() {
        return false;
    }

    public void checkAndUpdateSandboxWindow(boolean bl) {
    }

    public boolean isNativeSandbox() {
        return false;
    }

    public boolean getUseNativeSandboxWindow() {
        return false;
    }

    public long createNativeWindowSandboxHandle(long l) {
        return 0L;
    }

    public void setNativeSandboxWindowSize(long l, int n, int n2) {
    }

    private synchronized boolean initNativeSandboxBroker() {
        if (this.sandboxBroker == null) {
            this.sandboxBroker = new NoSandboxBroker();
        }
        return true;
    }

    public NativeSandboxBroker getNativeSandboxBroker() {
        if (this.initNativeSandboxBroker()) {
            return this.sandboxBroker;
        }
        return null;
    }

    public void setNativeSandboxJNLPService(NativeSandboxJNLPService nativeSandboxJNLPService) {
    }

    public void addParentWindow(int n, long l) {
    }

    public void waitForNativeSandboxProcess() {
    }

    public boolean isScreenLocked() {
        return false;
    }

    long getUserDeploymentPropCacheTimestamp() {
        return -1L;
    }

    long getSysDeploymentPropCacheTimestamp() {
        return -1L;
    }

    public abstract WebJavaSwitch getWebJavaSwitch();

    public boolean isCompatibleArch(String string, String string2) {
        return string.equals(string2);
    }

    public static boolean isArgumentOkay(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (' ' >= c || c >= '~') {
                return false;
            }
            if (c != '\\' && c != '\"') continue;
            return false;
        }
        return true;
    }

    public static abstract class WebJavaSwitch {
        protected abstract void setSystemWebJavaEnabled(boolean var1);

        protected abstract boolean isSystemWebJavaEnabled();

        public WebJavaState queryWebJavaState() {
            if (!this.isSystemWebJavaEnabled()) {
                return WebJavaState.DISABLED;
            }
            if (!this.isUserWebJavaEnabled()) {
                return WebJavaState.USER_DISABLED;
            }
            return WebJavaState.ENABLED;
        }

        public void setWebJavaEnabled(boolean bl) {
            try {
                this.setUserWebJavaEnabled(bl);
            }
            finally {
                this.setSystemWebJavaEnabled(bl);
            }
        }

        private void setUserWebJavaEnabled(boolean bl) {
            String string = "undefined";
            if (OSType.isUnix() && !Platform.get().isGTKAvailable(2, 14, 0)) {
                string = bl ? "later" : "block";
            }
            Config.setStringProperty("deployment.expiration.decision." + SecurityBaseline.getDeployNoBuildVersion(), string);
            Config.setBooleanProperty("deployment.webjava.enabled", bl);
            Config.get().storeIfNeeded();
        }

        private boolean isUserWebJavaEnabled() {
            boolean bl;
            String string = "deployment.expiration.decision." + SecurityBaseline.getDeployNoBuildVersion();
            boolean bl2 = "block".equals(Config.getStringProperty(string));
            boolean bl3 = Config.getBooleanProperty("deployment.webjava.enabled");
            if (bl3 != (bl = this.isSystemWebJavaEnabled())) {
                long l = Platform.get().getUserDeploymentPropCacheTimestamp();
                long l2 = Platform.get().getSysDeploymentPropCacheTimestamp();
                if (l != -1L && l2 != -1L && l2 >= l) {
                    this.setUserWebJavaEnabled(bl);
                    bl3 = bl;
                }
            }
            return bl3 && !bl2;
        }

        public boolean isWebJavaEnabled() {
            return this.queryWebJavaState() == WebJavaState.ENABLED;
        }

        public static final class WebJavaState {
            public static final WebJavaState ENABLED = new WebJavaState();
            public static final WebJavaState DISABLED = new WebJavaState();
            public static final WebJavaState USER_DISABLED = new WebJavaState();

            private WebJavaState() {
            }
        }
    }
}

