/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.association.utility;

import com.sun.deploy.association.utility.DesktopEntry;
import com.sun.deploy.association.utility.GnomeVfsWrapper;
import com.sun.deploy.config.Platform;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class DesktopEntryFile {
    private String uri = null;
    private ArrayList desktopEntries = null;

    public DesktopEntryFile(String string) {
        if (null == string) {
            throw new NullPointerException("uri is null!");
        }
        if (string.indexOf("://") == 0) {
            throw new IllegalArgumentException("Invalid URI[" + string + "]!");
        }
        this.uri = string;
        this.desktopEntries = new ArrayList();
        Trace.println("new DesktopEntryFile uri = [" + string + "]", TraceLevel.BASIC);
    }

    public DesktopEntryFile(File file) {
        this(file.toURI().toString());
    }

    public String getParent() {
        int n;
        String string = this.uri.toString();
        int n2 = string.lastIndexOf(File.separator);
        if (n2 < (n = string.indexOf("://") + 3)) {
            if (n > 0 && string.length() > n) {
                return string.substring(0, n);
            }
            return "/";
        }
        return string.substring(0, n2);
    }

    private DesktopEntryFile getParentDesktopEntryFile() {
        String string = this.getParent();
        return string == null ? null : new DesktopEntryFile(string);
    }

    public Collection readEntries() throws IOException {
        this.readEntryInternal();
        return this.desktopEntries;
    }

    public void writeEntry(DesktopEntry desktopEntry) throws IOException {
        ArrayList<DesktopEntry> arrayList = new ArrayList<DesktopEntry>();
        arrayList.add(desktopEntry);
        this.writeEntries(arrayList);
    }

    public void writeEntries(Collection collection) throws IOException {
        this.desktopEntries = new ArrayList(collection);
        this.writeEntryInternal();
    }

    public boolean exists() {
        return GnomeVfsWrapper.gnome_vfs_file_exists(this.uri.toString());
    }

    public boolean delete() {
        return GnomeVfsWrapper.gnome_vfs_delete_file(this.uri.toString());
    }

    public boolean deleteToNonEmptyParent() {
        for (DesktopEntryFile desktopEntryFile = this; null != desktopEntryFile && desktopEntryFile.exists() && !desktopEntryFile.getURI().matches(".*://") && desktopEntryFile.delete(); desktopEntryFile = desktopEntryFile.getParentDesktopEntryFile()) {
            Trace.println("file deleted " + desktopEntryFile.toString(), TraceLevel.BASIC);
        }
        return true;
    }

    public boolean mkdir() throws IOException {
        return GnomeVfsWrapper.gnome_vfs_mkdir(this.uri.toString());
    }

    private void readEntryInternal() throws IOException {
        String string = GnomeVfsWrapper.gnome_vfs_read_file(this.uri.toString());
        if (string == null) {
            throw new IOException("Unable to load file entry.");
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        String string2 = null;
        DesktopEntry desktopEntry = null;
        boolean bl = false;
        while (null != (string2 = bufferedReader.readLine())) {
            if (string2.matches("^\\s*\\[.*\\]\\s*")) {
                if (null != desktopEntry) continue;
                desktopEntry = new DesktopEntry(DesktopEntryFile.trimBracket(string2));
                this.desktopEntries.add(desktopEntry);
                continue;
            }
            if (null == desktopEntry) continue;
            desktopEntry.load(string2);
        }
    }

    private static String trimBracket(String string) {
        if (null == string) {
            return "";
        }
        int n = string.length();
        if (n > 1) {
            return string.trim().substring(1, n - 1);
        }
        return "";
    }

    private void writeEntryInternal() throws IOException {
        DesktopEntryFile desktopEntryFile;
        ArrayList<DesktopEntryFile> arrayList = new ArrayList<DesktopEntryFile>();
        for (desktopEntryFile = this.getParentDesktopEntryFile(); null != desktopEntryFile && !desktopEntryFile.exists(); desktopEntryFile = desktopEntryFile.getParentDesktopEntryFile()) {
            arrayList.add(desktopEntryFile);
        }
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            desktopEntryFile = (DesktopEntryFile)arrayList.get(i);
            Trace.println("writeEntryInternal mkdir " + desktopEntryFile.toString(), TraceLevel.BASIC);
            desktopEntryFile.mkdir();
        }
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.desktopEntries.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append("\n");
        }
        Trace.println("gnome_vfs_write_file [" + this.uri.toString() + "]", TraceLevel.BASIC);
        boolean bl = GnomeVfsWrapper.gnome_vfs_write_file(this.uri.toString(), stringBuffer.toString());
    }

    public String getURI() {
        return this.uri;
    }

    public String toString() {
        return "DesktopEntryFile[" + this.uri + "]";
    }

    static {
        Platform.get().loadDeployNativeLib();
    }
}

