/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.jira.soap;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.jira.JiraTask;
import com.intellij.util.containers.ContainerUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JiraSoapTask
extends JiraTask {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);
    private final String myKey;
    private final String mySummary;
    private final String myDescription;
    private final String myIconUrl;
    private final Date myUpdated;
    private final Date myCreated;
    private final TaskState myState;
    private final TaskType myType;
    private final List<Comment> myComments;

    public JiraSoapTask(@NotNull Element element, @NotNull TaskRepository repository) {
        if (element == null) {
            JiraSoapTask.$$$reportNull$$$0(0);
        }
        if (repository == null) {
            JiraSoapTask.$$$reportNull$$$0(1);
        }
        super(repository);
        this.myKey = element.getChildText("key");
        this.mySummary = element.getChildText("summary");
        this.myDescription = element.getChildText("description");
        this.myIconUrl = JiraSoapTask.getChildAttribute(element, "type", "iconUrl");
        this.myType = this.getTypeByName(element.getChildText("type"));
        String statusIdText = JiraSoapTask.getChildAttribute(element, "status", "id");
        this.myState = this.getStateById(StringUtil.isEmpty((String)statusIdText) ? 0 : Integer.parseInt(statusIdText));
        this.myCreated = JiraSoapTask.parseDate(element.getChildText("created"));
        this.myUpdated = JiraSoapTask.parseDate(element.getChildText("updated"));
        Element comments = element.getChild("comments");
        this.myComments = comments != null ? ContainerUtil.map((Collection)comments.getChildren("comment"), element1 -> new Comment((Element)element1){
            final /* synthetic */ Element val$element1;
            {
                this.val$element1 = element;
            }

            public String getText() {
                return this.val$element1.getText();
            }

            @Nullable
            public String getAuthor() {
                return this.val$element1.getAttributeValue("author");
            }

            @Nullable
            public Date getDate() {
                return JiraSoapTask.parseDate(this.val$element1.getAttributeValue("created"));
            }
        }) : ContainerUtil.emptyList();
    }

    @Override
    @NotNull
    public String getId() {
        String string = this.myKey;
        if (string == null) {
            JiraSoapTask.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public String getSummary() {
        String string = this.mySummary;
        if (string == null) {
            JiraSoapTask.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getDescription() {
        return this.myDescription;
    }

    @Override
    @NotNull
    public Comment[] getComments() {
        Comment[] commentArray = this.myComments.toArray(new Comment[this.myComments.size()]);
        if (commentArray == null) {
            JiraSoapTask.$$$reportNull$$$0(4);
        }
        return commentArray;
    }

    @Override
    @Nullable
    protected String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    @NotNull
    public TaskType getType() {
        TaskType taskType = this.myType;
        if (taskType == null) {
            JiraSoapTask.$$$reportNull$$$0(5);
        }
        return taskType;
    }

    @Override
    public TaskState getState() {
        return this.myState;
    }

    @Override
    @Nullable
    public Date getUpdated() {
        return this.myUpdated;
    }

    @Override
    public Date getCreated() {
        return this.myCreated;
    }

    @Nullable
    private static Date parseDate(@NotNull String date) {
        if (date == null) {
            JiraSoapTask.$$$reportNull$$$0(6);
        }
        try {
            return DATE_FORMAT.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    @Nullable
    private static String getChildAttribute(@NotNull Element parent, @NotNull String childName, @NotNull String attributeName) {
        Element child;
        if (parent == null) {
            JiraSoapTask.$$$reportNull$$$0(7);
        }
        if (childName == null) {
            JiraSoapTask.$$$reportNull$$$0(8);
        }
        if (attributeName == null) {
            JiraSoapTask.$$$reportNull$$$0(9);
        }
        if ((child = parent.getChild(childName)) == null) {
            return null;
        }
        return child.getAttributeValue(attributeName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/jira/soap/JiraSoapTask";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/jira/soap/JiraSoapTask";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSummary";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComments";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildAttribute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

