/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.winp;

import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.winp.Native;
import org.jvnet.winp.NotWindowsException;
import org.jvnet.winp.WinpException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WinProcess {
    private final int pid;
    private String commandline;
    private TreeMap<String, String> envVars;
    private static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return o1.toUpperCase().compareTo(o2.toUpperCase());
        }
    };
    private static final Logger LOGGER = Logger.getLogger(WinProcess.class.getName());

    public WinProcess(int pid) {
        this.pid = pid;
    }

    public WinProcess(Process proc) {
        try {
            Field f = proc.getClass().getDeclaredField("handle");
            f.setAccessible(true);
            int handle = ((Number)f.get(proc)).intValue();
            this.pid = Native.getProcessId(handle);
        }
        catch (NoSuchFieldException e) {
            throw new NotWindowsException(e);
        }
        catch (IllegalAccessException e) {
            throw new NotWindowsException(e);
        }
    }

    public int getPid() {
        return this.pid;
    }

    public void killRecursively() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Attempting to recursively kill pid=%d (%s)", this.pid, this.getCommandLine()));
        }
        Native.kill(this.pid, true);
    }

    public void kill() {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Attempting to kill pid=%d (%s)", this.pid, this.getCommandLine()));
        }
        Native.kill(this.pid, false);
    }

    public boolean isCriticalProcess() {
        return Native.isCriticalProcess(this.pid);
    }

    public void setPriority(int priority) {
        Native.setPriority(this.pid, priority);
    }

    public synchronized String getCommandLine() {
        if (this.commandline == null) {
            this.parseCmdLineAndEnvVars();
        }
        return this.commandline;
    }

    public synchronized TreeMap<String, String> getEnvironmentVariables() {
        if (this.envVars == null) {
            this.parseCmdLineAndEnvVars();
        }
        return this.envVars;
    }

    private void parseCmdLineAndEnvVars() {
        String s = Native.getCmdLineAndEnvVars(this.pid);
        if (s == null) {
            throw new WinpException("Failed to obtain for PID=" + this.pid);
        }
        int sep = s.indexOf(0);
        this.commandline = s.substring(0, sep);
        this.envVars = new TreeMap(CASE_INSENSITIVE_COMPARATOR);
        s = s.substring(sep + 1);
        while (s.length() > 0) {
            String t;
            sep = s.indexOf(0);
            if (sep == 0) {
                return;
            }
            if (sep == -1) {
                t = s;
                s = "";
            } else {
                t = s.substring(0, sep);
                s = s.substring(sep + 1);
            }
            if ((sep = t.indexOf(61)) == -1) continue;
            this.envVars.put(t.substring(0, sep), t.substring(sep + 1));
        }
    }

    public static Iterable<WinProcess> all() {
        return new Iterable<WinProcess>(){

            @Override
            public Iterator<WinProcess> iterator() {
                return new Iterator<WinProcess>(){
                    private int pos = 0;
                    private int[] pids = new int[256];
                    private int total;
                    {
                        while (true) {
                            this.total = Native.enumProcesses(this.pids);
                            if (this.total == 0) {
                                throw new WinpException("Failed to enumerate processes");
                            }
                            if (this.total < this.pids.length) break;
                            this.pids = new int[this.pids.length * 2];
                        }
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pos < this.total;
                    }

                    @Override
                    public WinProcess next() {
                        return new WinProcess(this.pids[this.pos++]);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void enableDebugPrivilege() {
        Native.enableDebugPrivilege();
    }
}

