/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.config;

import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.config.Storage;
import java.util.Iterator;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public interface Externalizer<T> {
    @NonNls
    public static final String VALUE_ATTRIBUTE = "value";
    public static final Externalizer<String> STRING = new BaseExternalizer<String>(){

        @Override
        public String readValue(Element dataElement) {
            return dataElement.getAttributeValue(Externalizer.VALUE_ATTRIBUTE);
        }
    };
    public static final Externalizer<Integer> INTEGER = new BaseExternalizer<Integer>(){

        @Override
        public Integer readValue(Element dataElement) {
            try {
                return new Integer(dataElement.getAttributeValue(Externalizer.VALUE_ATTRIBUTE));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
    };
    public static final Externalizer<Storage> STORAGE = new StorageExternalizer();
    public static final Externalizer<Boolean> BOOLEAN = new BaseExternalizer<Boolean>(){

        @Override
        public Boolean readValue(Element dataElement) {
            return Boolean.valueOf(dataElement.getAttributeValue(Externalizer.VALUE_ATTRIBUTE));
        }
    };

    public T readValue(Element var1);

    public void writeValue(Element var1, T var2);

    public static class StorageExternalizer
    implements Externalizer<Storage> {
        @NonNls
        private static final String ITEM_TAG = "item";
        @NonNls
        private static final String KEY_ATTR = "key";
        @NonNls
        private static final String VALUE_ATTR = "value";

        @Override
        public Storage readValue(Element dataElement) {
            Storage.MapStorage storage = new Storage.MapStorage();
            for (Element element : dataElement.getChildren(ITEM_TAG)) {
                storage.put(element.getAttributeValue(KEY_ATTR), element.getAttributeValue("value"));
            }
            return storage;
        }

        @Override
        public void writeValue(Element dataElement, Storage storage) {
            Iterator<String> keys = ((Storage.MapStorage)storage).getKeys();
            while (keys.hasNext()) {
                String key = keys.next();
                String value = storage.get(key);
                Element element = new Element(ITEM_TAG);
                element.setAttribute(KEY_ATTR, key);
                if (value != null) {
                    element.setAttribute("value", value);
                }
                dataElement.addContent(element);
            }
        }
    }

    public static class FactoryBased<T extends JDOMExternalizable>
    implements Externalizer<T> {
        private final Factory<T> myFactory;

        public FactoryBased(Factory<T> factory) {
            this.myFactory = factory;
        }

        @Override
        public T readValue(Element dataElement) {
            JDOMExternalizable data = (JDOMExternalizable)this.myFactory.create();
            data.readExternal(dataElement);
            return (T)data;
        }

        @Override
        public void writeValue(Element dataElement, T value) {
            try {
                value.writeExternal(dataElement);
            }
            catch (WriteExternalException e) {
                throw new RuntimeException(e);
            }
        }

        public static <T extends JDOMExternalizable> FactoryBased<T> create(Factory<T> factory) {
            return new FactoryBased<T>(factory);
        }
    }

    public static abstract class BaseExternalizer<T>
    implements Externalizer<T> {
        @Override
        public void writeValue(Element dataElement, T value) {
            dataElement.setAttribute(Externalizer.VALUE_ATTRIBUTE, value.toString());
        }
    }
}

