/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.WideSelectionTreeUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class ColoredTreeCellRenderer
extends SimpleColoredComponent
implements TreeCellRenderer {
    private static final Icon LOADING_NODE_ICON = JBUI.scale((JBUI.JBIcon)EmptyIcon.create((int)8, (int)16));
    protected boolean mySelected;
    private boolean myFocused;
    private boolean myFocusedCalculated;
    protected JTree myTree;
    private boolean myOpaque = true;

    @Override
    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myTree = tree;
        this.clear();
        this.mySelected = selected;
        this.myFocusedCalculated = false;
        if (UIUtil.isFullRowSelectionLAF()) {
            this.setBackground(selected ? UIUtil.getTreeSelectionBackground() : null);
        } else if (WideSelectionTreeUI.isWideSelection((JTree)tree)) {
            this.setPaintFocusBorder(false);
            if (selected) {
                this.setBackground(hasFocus ? UIUtil.getTreeSelectionBackground() : UIUtil.getTreeUnfocusedSelectionBackground());
            }
        } else if (selected) {
            this.setPaintFocusBorder(true);
            if (this.isFocused()) {
                this.setBackground(UIUtil.getTreeSelectionBackground());
            } else {
                this.setBackground(null);
            }
        } else {
            this.setBackground(null);
        }
        if (value instanceof LoadingNode) {
            this.setForeground((Color)JBColor.GRAY);
            this.setIcon(LOADING_NODE_ICON);
        } else {
            this.setForeground(tree.getForeground());
            this.setIcon(null);
        }
        if (UIUtil.isUnderGTKLookAndFeel()) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else if (UIUtil.isUnderNimbusLookAndFeel() && selected && hasFocus) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else if (WideSelectionTreeUI.isWideSelection((JTree)tree)) {
            super.setOpaque(false);
            super.setIconOpaque(false);
        } else {
            super.setOpaque(this.myOpaque || selected && hasFocus || selected && this.isFocused());
        }
        this.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
        return this;
    }

    public JTree getTree() {
        return this.myTree;
    }

    protected final boolean isFocused() {
        if (!this.myFocusedCalculated) {
            this.myFocused = this.calcFocusedState();
            this.myFocusedCalculated = true;
        }
        return this.myFocused;
    }

    protected boolean calcFocusedState() {
        return this.myTree.hasFocus();
    }

    @Override
    public void setOpaque(boolean isOpaque) {
        this.myOpaque = isOpaque;
        super.setOpaque(isOpaque);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font != null) {
            return font;
        }
        JTree tree = this.getTree();
        return tree != null ? tree.getFont() : null;
    }

    @Override
    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes, boolean isMainText) {
        if (fragment == null) {
            ColoredTreeCellRenderer.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            ColoredTreeCellRenderer.$$$reportNull$$$0(1);
        }
        if (this.mySelected && this.isFocused()) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTreeSelectionForeground()), isMainText);
        } else if (this.mySelected && UIUtil.isUnderAquaBasedLookAndFeel()) {
            super.append(fragment, new SimpleTextAttributes(attributes.getStyle(), UIUtil.getTreeForeground()), isMainText);
        } else {
            super.append(fragment, attributes, isMainText);
        }
    }

    @Override
    void revalidateAndRepaint() {
    }

    public abstract void customizeCellRenderer(@NotNull JTree var1, Object var2, boolean var3, boolean var4, boolean var5, int var6, boolean var7);

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleColoredTreeCellRenderer();
        }
        return this.accessibleContext;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "fragment";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "attributes";
                break;
            }
        }
        objectArray[1] = "com/intellij/ui/ColoredTreeCellRenderer";
        objectArray[2] = "append";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class AccessibleColoredTreeCellRenderer
    extends SimpleColoredComponent.AccessibleSimpleColoredComponent {
        protected AccessibleColoredTreeCellRenderer() {
            super(ColoredTreeCellRenderer.this);
        }
    }
}

