/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileManager
implements ModificationTracker {
    public static final Topic<BulkFileListener> VFS_CHANGES = new Topic("NewVirtualFileSystem changes", BulkFileListener.class);
    public static final ModificationTracker VFS_STRUCTURE_MODIFICATIONS = new ModificationTracker(){

        @Override
        public long getModificationCount() {
            return VirtualFileManager.getInstance().getStructureModificationCount();
        }
    };
    private static VirtualFileManager ourInstance = CachedSingletonsRegistry.markCachedField(VirtualFileManager.class);

    @NotNull
    public static VirtualFileManager getInstance() {
        VirtualFileManager result = ourInstance;
        if (result == null) {
            ourInstance = result = ApplicationManager.getApplication().getComponent(VirtualFileManager.class);
        }
        VirtualFileManager virtualFileManager = result;
        if (virtualFileManager == null) {
            VirtualFileManager.$$$reportNull$$$0(0);
        }
        return virtualFileManager;
    }

    public abstract VirtualFileSystem getFileSystem(String var1);

    public abstract long syncRefresh();

    public abstract long asyncRefresh(@Nullable Runnable var1);

    public abstract void refreshWithoutFileWatcher(boolean var1);

    @Nullable
    public abstract VirtualFile findFileByUrl(@NonNls @NotNull String var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByUrl(@NotNull String var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1, @NotNull Disposable var2);

    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    @NotNull
    public static String constructUrl(@NotNull String protocol, @NotNull String path2) {
        if (protocol == null) {
            VirtualFileManager.$$$reportNull$$$0(1);
        }
        if (path2 == null) {
            VirtualFileManager.$$$reportNull$$$0(2);
        }
        String string = protocol + "://" + path2;
        if (string == null) {
            VirtualFileManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static String extractProtocol(@NotNull String url) {
        int index;
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(4);
        }
        if ((index = url.indexOf("://")) < 0) {
            return null;
        }
        return url.substring(0, index);
    }

    @NotNull
    public static String extractPath(@NotNull String url) {
        int index;
        if (url == null) {
            VirtualFileManager.$$$reportNull$$$0(5);
        }
        if ((index = url.indexOf("://")) < 0) {
            String string = url;
            if (string == null) {
                VirtualFileManager.$$$reportNull$$$0(6);
            }
            return string;
        }
        String string = url.substring(index + "://".length());
        if (string == null) {
            VirtualFileManager.$$$reportNull$$$0(7);
        }
        return string;
    }

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void addVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1, @NotNull Disposable var2);

    public abstract void removeVirtualFileManagerListener(@NotNull VirtualFileManagerListener var1);

    public abstract void notifyPropertyChanged(@NotNull VirtualFile var1, @NotNull String var2, Object var3, Object var4);

    @Override
    public abstract long getModificationCount();

    public abstract long getStructureModificationCount();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/VirtualFileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/VirtualFileManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "constructUrl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "constructUrl";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "extractProtocol";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

