/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.command.checkout;

import com.intellij.util.Consumer;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.IClientEnvironment;
import org.netbeans.lib.cvsclient.IRequestProcessor;
import org.netbeans.lib.cvsclient.command.AbstractMessageParser;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.CommandException;
import org.netbeans.lib.cvsclient.command.checkout.Module;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IEventSender;
import org.netbeans.lib.cvsclient.file.DirectoryObject;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.sending.DummyRequestsProgressHandler;
import org.netbeans.lib.cvsclient.request.CommandRequest;
import org.netbeans.lib.cvsclient.request.Requests;

public class ListModulesCommand
extends Command {
    private final Set<Module> modules = new HashSet<Module>();
    private Module lastModule;
    private Consumer<Module> myModuleConsumer;

    public ListModulesCommand() {
        this.getGlobalOptions().setDoNoChanges(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(IRequestProcessor requestProcessor, IEventSender eventManager, ICvsListenerRegistry listenerRegistry, IClientEnvironment clientEnvironment, IProgressViewer progressViewer) throws CommandException, AuthenticationException {
        this.modules.clear();
        Requests requests = new Requests(CommandRequest.CHECKOUT, clientEnvironment);
        requests.addArgumentRequest("-N");
        requests.addArgumentRequest("-c");
        requests.addDirectoryRequest(DirectoryObject.createInstance("/"));
        GetModulesParser listener = new GetModulesParser();
        listener.registerListeners(listenerRegistry);
        try {
            boolean bl = requestProcessor.processRequests(requests, new DummyRequestsProgressHandler());
            return bl;
        }
        finally {
            listener.unregisterListeners(listenerRegistry);
        }
    }

    @Override
    public String getCvsCommandLine() {
        return null;
    }

    public Set<Module> getModules() {
        return this.modules;
    }

    @Nullable
    private static String trimMaybeNull(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).isEmpty()) {
            return null;
        }
        return string;
    }

    public void setModuleConsumer(Consumer<Module> moduleConsumer) {
        this.myModuleConsumer = moduleConsumer;
    }

    private final class GetModulesParser
    extends AbstractMessageParser {
        private static final String MUTILINE_MODULE_PREFIX = " ";

        private GetModulesParser() {
        }

        @Override
        public void parseLine(String line, boolean errorMessage) {
            int spaceIndex;
            if (errorMessage) {
                return;
            }
            if (line.startsWith(MUTILINE_MODULE_PREFIX) && ListModulesCommand.this.lastModule != null) {
                ListModulesCommand.this.lastModule.appendOptions(line.trim());
            }
            if ((spaceIndex = (line = line.replace('\t', ' ')).indexOf(32)) < 0) {
                return;
            }
            String moduleName = ListModulesCommand.trimMaybeNull(line.substring(0, spaceIndex));
            if (moduleName == null) {
                return;
            }
            String options = ListModulesCommand.trimMaybeNull(line.substring(spaceIndex));
            if (options != null) {
                this.addNewModule(new Module(moduleName, options));
            } else {
                this.addNewModule(new Module(moduleName));
            }
        }

        private void addNewModule(Module module) {
            if (ListModulesCommand.this.myModuleConsumer != null) {
                ListModulesCommand.this.myModuleConsumer.consume((Object)module);
            }
            ListModulesCommand.this.modules.add(module);
            ListModulesCommand.this.lastModule = module;
        }

        @Override
        public void binaryMessageSent(byte[] bytes) {
        }

        @Override
        public void outputDone() {
        }
    }
}

