/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.model.annotation;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.model.Define;
import org.intellij.plugins.relaxNG.model.Grammar;
import org.intellij.plugins.relaxNG.model.annotation.OverriddenDefineSearcher;
import org.intellij.plugins.relaxNG.model.annotation.OverridingDefineRenderer;
import org.intellij.plugins.relaxNG.model.resolve.GrammarFactory;
import org.intellij.plugins.relaxNG.model.resolve.RelaxIncludeIndex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OverriddenDefineRenderer
extends GutterIconRenderer
implements DumbAware {
    private final Define myDefine;

    public OverriddenDefineRenderer(@NotNull Define define) {
        if (define == null) {
            OverriddenDefineRenderer.$$$reportNull$$$0(0);
        }
        this.myDefine = define;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Gutter.OverridenMethod;
        if (icon == null) {
            OverriddenDefineRenderer.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                Object element = OverriddenDefineRenderer.this.myDefine.getPsiElement();
                if (element == null || !element.isValid()) {
                    return;
                }
                PsiElementProcessor.CollectElements collector = new PsiElementProcessor.CollectElements();
                XmlFile localFile = (XmlFile)element.getContainingFile();
                RelaxIncludeIndex.processBackwardDependencies(localFile, (PsiElementProcessor<XmlFile>)collector);
                Collection files = collector.getCollection();
                SmartList result2 = new SmartList();
                OverriddenDefineSearcher searcher = new OverriddenDefineSearcher(OverriddenDefineRenderer.this.myDefine, localFile, (List<Define>)result2);
                for (XmlFile file2 : files) {
                    Grammar grammar = GrammarFactory.getGrammar(file2);
                    if (grammar == null) continue;
                    grammar.acceptChildren(searcher);
                }
                if (result2.size() > 0) {
                    OverridingDefineRenderer.doClickAction(e, (Collection<Define>)result2, "Go to overriding define(s)");
                }
            }
        };
    }

    public boolean isNavigateAction() {
        return true;
    }

    @Nullable
    public String getTooltipText() {
        return "Is overridden";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OverriddenDefineRenderer that = (OverriddenDefineRenderer)((Object)o);
        return this.myDefine.equals(that.myDefine);
    }

    public int hashCode() {
        return this.myDefine.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "define";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/model/annotation/OverriddenDefineRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

