/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi;

import com.google.common.collect.Iterables;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyIndentUtil {
    @NonNls
    public static final String TWO_SPACES = "  ";
    @NonNls
    public static final String FOUR_SPACES = "    ";

    private PyIndentUtil() {
    }

    public static int getLineIndentSize(@NotNull CharSequence line) {
        char c;
        int stop2;
        if (line == null) {
            PyIndentUtil.$$$reportNull$$$0(0);
        }
        for (stop2 = 0; stop2 < line.length() && ((c = line.charAt(stop2)) == ' ' || c == '\t'); ++stop2) {
        }
        return stop2;
    }

    @NotNull
    public static String getLineIndent(@NotNull String line) {
        if (line == null) {
            PyIndentUtil.$$$reportNull$$$0(1);
        }
        String string = line.substring(0, PyIndentUtil.getLineIndentSize(line));
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static CharSequence getLineIndent(@NotNull CharSequence line) {
        if (line == null) {
            PyIndentUtil.$$$reportNull$$$0(3);
        }
        CharSequence charSequence = line.subSequence(0, PyIndentUtil.getLineIndentSize(line));
        if (charSequence == null) {
            PyIndentUtil.$$$reportNull$$$0(4);
        }
        return charSequence;
    }

    @NotNull
    public static String getElementIndent(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyIndentUtil.$$$reportNull$$$0(5);
        }
        if (anchor instanceof PsiFile) {
            if ("" == null) {
                PyIndentUtil.$$$reportNull$$$0(6);
            }
            return "";
        }
        PyStatementList statementList = PyIndentUtil.getAnchorStatementList(anchor);
        if (statementList == null) {
            if ("" == null) {
                PyIndentUtil.$$$reportNull$$$0(7);
            }
            return "";
        }
        PsiElement prevSibling = statementList.getPrevSibling();
        String whitespace = prevSibling instanceof PsiWhiteSpace ? prevSibling.getText() : "";
        int i = whitespace.lastIndexOf("\n");
        if (i >= 0 && statementList.getStatements().length != 0) {
            String string = whitespace.substring(i + 1);
            if (string == null) {
                PyIndentUtil.$$$reportNull$$$0(8);
            }
            return string;
        }
        String string = PyIndentUtil.getExpectedBlockIndent(statementList);
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    private static String getExpectedBlockIndent(@NotNull PyStatementList anchor) {
        if (anchor == null) {
            PyIndentUtil.$$$reportNull$$$0(10);
        }
        String indentStep = PyIndentUtil.getIndentFromSettings(anchor.getProject());
        PyStatementList parentBlock = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatementList.class, (boolean)true);
        if (parentBlock != null) {
            String string = PyIndentUtil.getElementIndent((PsiElement)parentBlock) + indentStep;
            if (string == null) {
                PyIndentUtil.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = indentStep;
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private static PyStatementList getAnchorStatementList(@NotNull PsiElement element) {
        if (element == null) {
            PyIndentUtil.$$$reportNull$$$0(13);
        }
        PyStatementList statementList = null;
        if (element instanceof PsiWhiteSpace) {
            statementList = PyUtil.as(element.getNextSibling(), PyStatementList.class);
        }
        if (statementList == null) {
            statementList = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)element, PyStatementList.class, (boolean)false);
        }
        return statementList;
    }

    private static int getExpectedElementIndentSize(@NotNull PsiElement anchor) {
        if (anchor == null) {
            PyIndentUtil.$$$reportNull$$$0(14);
        }
        int depth = 0;
        PyStatementList block = PyIndentUtil.getAnchorStatementList(anchor);
        while (block != null) {
            ++depth;
            block = (PyStatementList)PsiTreeUtil.getParentOfType((PsiElement)block, PyStatementList.class);
        }
        return depth * PyIndentUtil.getIndentSizeFromSettings(anchor.getProject());
    }

    public static boolean areTabsUsedForIndentation(@NotNull Project project) {
        if (project == null) {
            PyIndentUtil.$$$reportNull$$$0(15);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        return codeStyleSettings.useTabCharacter((FileType)PythonFileType.INSTANCE);
    }

    public static char getIndentCharacter(@NotNull Project project) {
        if (project == null) {
            PyIndentUtil.$$$reportNull$$$0(16);
        }
        return PyIndentUtil.areTabsUsedForIndentation(project) ? (char)'\t' : ' ';
    }

    public static int getIndentSizeFromSettings(@NotNull Project project) {
        if (project == null) {
            PyIndentUtil.$$$reportNull$$$0(17);
        }
        CodeStyleSettings codeStyleSettings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings();
        CommonCodeStyleSettings.IndentOptions indentOptions = codeStyleSettings.getIndentOptions((FileType)PythonFileType.INSTANCE);
        return indentOptions.INDENT_SIZE;
    }

    @NotNull
    public static String getIndentFromSettings(@NotNull Project project) {
        boolean useTabs;
        if (project == null) {
            PyIndentUtil.$$$reportNull$$$0(18);
        }
        String string = (useTabs = PyIndentUtil.areTabsUsedForIndentation(project)) ? "\t" : StringUtil.repeatSymbol((char)' ', (int)PyIndentUtil.getIndentSizeFromSettings(project));
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static List<String> removeCommonIndent(@NotNull Iterable<String> lines2, boolean ignoreFirstLine) {
        if (lines2 == null) {
            PyIndentUtil.$$$reportNull$$$0(20);
        }
        List<String> list2 = PyIndentUtil.changeIndent(lines2, ignoreFirstLine, "");
        if (list2 == null) {
            PyIndentUtil.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    public static String removeCommonIndent(@NotNull String s, boolean ignoreFirstLine) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(22);
        }
        List<String> trimmed = PyIndentUtil.removeCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine);
        String string = StringUtil.join(trimmed, (String)"\n");
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String changeIndent(@NotNull String s, boolean ignoreFirstLine, String newIndent) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(24);
        }
        List<String> trimmed = PyIndentUtil.changeIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine, newIndent);
        String string = StringUtil.join(trimmed, (String)"\n");
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static List<String> changeIndent(@NotNull Iterable<String> lines2, boolean ignoreFirstLine, String newIndent) {
        if (lines2 == null) {
            PyIndentUtil.$$$reportNull$$$0(26);
        }
        String oldIndent = PyIndentUtil.findCommonIndent(lines2, ignoreFirstLine);
        if (Iterables.isEmpty(lines2)) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                PyIndentUtil.$$$reportNull$$$0(27);
            }
            return list2;
        }
        List result2 = ContainerUtil.map((Iterable)Iterables.skip(lines2, (int)(ignoreFirstLine ? 1 : 0)), line -> {
            if (StringUtil.isEmptyOrSpaces((String)line)) {
                return "";
            }
            return newIndent + line.substring(oldIndent.length());
        });
        if (ignoreFirstLine) {
            List list3 = ContainerUtil.prepend((List)result2, (Object[])new String[]{(String)Iterables.get(lines2, (int)0)});
            if (list3 == null) {
                PyIndentUtil.$$$reportNull$$$0(28);
            }
            return list3;
        }
        List list4 = result2;
        if (list4 == null) {
            PyIndentUtil.$$$reportNull$$$0(29);
        }
        return list4;
    }

    @NotNull
    public static String findCommonIndent(@NotNull String s, boolean ignoreFirstLine) {
        if (s == null) {
            PyIndentUtil.$$$reportNull$$$0(30);
        }
        String string = PyIndentUtil.findCommonIndent(LineTokenizer.tokenizeIntoList((CharSequence)s, (boolean)false, (boolean)false), ignoreFirstLine);
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static String findCommonIndent(@NotNull Iterable<String> lines2, boolean ignoreFirstLine) {
        if (lines2 == null) {
            PyIndentUtil.$$$reportNull$$$0(32);
        }
        String minIndent = null;
        boolean allLinesEmpty = true;
        if (Iterables.isEmpty(lines2)) {
            if ("" == null) {
                PyIndentUtil.$$$reportNull$$$0(33);
            }
            return "";
        }
        boolean hasBadEmptyLineIndent = false;
        for (String line : Iterables.skip(lines2, (int)(ignoreFirstLine ? 1 : 0))) {
            boolean lineEmpty = StringUtil.isEmptyOrSpaces((String)line);
            if (lineEmpty && !allLinesEmpty) continue;
            String indent = PyIndentUtil.getLineIndent(line);
            if (minIndent == null || !lineEmpty && allLinesEmpty || minIndent.startsWith(indent)) {
                minIndent = indent;
            } else if (!indent.startsWith(minIndent)) {
                if (lineEmpty) {
                    hasBadEmptyLineIndent = true;
                } else {
                    if ("" == null) {
                        PyIndentUtil.$$$reportNull$$$0(34);
                    }
                    return "";
                }
            }
            allLinesEmpty &= lineEmpty;
        }
        if (allLinesEmpty && hasBadEmptyLineIndent) {
            if ("" == null) {
                PyIndentUtil.$$$reportNull$$$0(35);
            }
            return "";
        }
        String string = StringUtil.notNullize(minIndent);
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(36);
        }
        return string;
    }

    @NotNull
    public static String getLineIndent(@NotNull Document document, int lineNumber) {
        if (document == null) {
            PyIndentUtil.$$$reportNull$$$0(37);
        }
        TextRange lineRange = TextRange.create((int)document.getLineStartOffset(lineNumber), (int)document.getLineEndOffset(lineNumber));
        String line = document.getText(lineRange);
        String string = PyIndentUtil.getLineIndent(line);
        if (string == null) {
            PyIndentUtil.$$$reportNull$$$0(38);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 20: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 22: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/PyIndentUtil";
                break;
            }
            case 2: 
            case 4: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndent";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementIndent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedBlockIndent";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndentFromSettings";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "removeCommonIndent";
                break;
            }
            case 25: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIndent";
                break;
            }
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "findCommonIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndentSize";
                break;
            }
            case 1: 
            case 3: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementIndent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedBlockIndent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorStatementList";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedElementIndentSize";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "areTabsUsedForIndentation";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getIndentCharacter";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getIndentSizeFromSettings";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getIndentFromSettings";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeCommonIndent";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "changeIndent";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "findCommonIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

