/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.Lists;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.toolbox.Substring;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyStructuredDocstringFormatter {
    private static final Logger LOG = Logger.getInstance(PyStructuredDocstringFormatter.class);
    private static final Charset DEFAULT_CHARSET = CharsetToolkit.UTF8_CHARSET;

    private PyStructuredDocstringFormatter() {
    }

    @Nullable
    public static List<String> formatDocstring(@NotNull PsiElement element, @NotNull String docstring) {
        Module module2;
        if (element == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(0);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(1);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) == null) {
            Module[] modules = ModuleManager.getInstance((Project)element.getProject()).getModules();
            if (modules.length == 0) {
                return Lists.newArrayList();
            }
            module2 = modules[0];
        }
        if (module2 == null) {
            return Lists.newArrayList();
        }
        ArrayList<String> result2 = new ArrayList<String>();
        String preparedDocstring = PyIndentUtil.removeCommonIndent(docstring, true).trim();
        DocStringFormat format = DocStringUtil.guessDocStringFormat(preparedDocstring, element);
        if (format == DocStringFormat.PLAIN) {
            return null;
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocStringContent(format, preparedDocstring);
        String output = PyStructuredDocstringFormatter.runExternalTool(module2, format, preparedDocstring);
        if (output != null) {
            result2.add(output);
        } else {
            result2.add(structuredDocString.getDescription());
        }
        if (format == DocStringFormat.EPYTEXT) {
            result2.add(PyStructuredDocstringFormatter.formatStructuredDocString(structuredDocString));
        }
        return result2;
    }

    @Nullable
    private static String runExternalTool(@NotNull Module module2, @NotNull DocStringFormat format, @NotNull String docstring) {
        String missingInterpreterMessage;
        Sdk sdk;
        if (module2 == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(2);
        }
        if (format == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(3);
        }
        if (docstring == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(4);
        }
        if (format == DocStringFormat.EPYTEXT) {
            sdk = PythonSdkType.findPython2Sdk(module2);
            missingInterpreterMessage = PyBundle.message("QDOC.epydoc.python2.sdk.not.found", new Object[0]);
        } else {
            sdk = PythonSdkType.findLocalCPython(module2);
            missingInterpreterMessage = PyBundle.message("QDOC.sdk.not.found", new Object[0]);
        }
        if (sdk == null) {
            LOG.warn("Python SDK for docstring formatter " + (Object)((Object)format) + " is not found");
            return "<p color=\"red\">" + missingInterpreterMessage + "</p>";
        }
        String sdkHome = sdk.getHomePath();
        if (sdkHome == null) {
            return null;
        }
        ByteBuffer encoded = DEFAULT_CHARSET.encode(docstring);
        byte[] data = new byte[encoded.limit()];
        encoded.get(data);
        ArrayList arguments = Lists.newArrayList((Object[])new String[]{format.getFormatterCommand()});
        GeneralCommandLine commandLine = PythonHelper.DOCSTRING_FORMATTER.newCommandLine(sdk, (List<String>)arguments);
        commandLine.setCharset(DEFAULT_CHARSET);
        LOG.debug("Command for launching docstring formatter: " + commandLine.getCommandLineString());
        ProcessOutput output = PySdkUtil.getProcessOutput(commandLine, new File(sdkHome).getParent(), null, 5000, data, false);
        if (!output.checkSuccess(LOG)) {
            LOG.info("Malformed docstring:\n" + docstring);
            return null;
        }
        return output.getStdout();
    }

    private static String formatStructuredDocString(@NotNull StructuredDocString docString) {
        TagBasedDocString taggedDocString;
        List<String> additionalTags;
        List<String> raisedException;
        if (docString == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(5);
        }
        StringBuilder result2 = new StringBuilder();
        String attributeDescription = docString.getAttributeDescription();
        if (attributeDescription != null) {
            result2.append(attributeDescription);
            String attrType = docString.getParamType(null);
            if (attrType != null) {
                result2.append(" <i>Type: ").append(attrType).append("</i>");
            }
        }
        PyStructuredDocstringFormatter.formatParameterDescriptions(docString, result2, false);
        PyStructuredDocstringFormatter.formatParameterDescriptions(docString, result2, true);
        String returnDescription = docString.getReturnDescription();
        String returnType = docString.getReturnType();
        if (returnDescription != null || returnType != null) {
            result2.append("<br><b>Return value:</b><br>");
            if (returnDescription != null) {
                result2.append(returnDescription);
            }
            if (returnType != null) {
                result2.append(" <i>Type: ").append(returnType).append("</i>");
            }
        }
        if ((raisedException = docString.getRaisedExceptions()).size() > 0) {
            result2.append("<br><b>Raises:</b><br>");
            for (String s : raisedException) {
                result2.append("<b>").append(s).append("</b> - ").append(docString.getRaisedExceptionDescription(s)).append("<br>");
            }
        }
        if (docString instanceof TagBasedDocString && !(additionalTags = (taggedDocString = (TagBasedDocString)docString).getAdditionalTags()).isEmpty()) {
            result2.append("<br/><br/><b>Additional:</b><br/>");
            result2.append("<table>");
            for (String tagName : additionalTags) {
                List<Substring> args = taggedDocString.getTagArguments(tagName);
                for (Substring arg : args) {
                    String s = arg.toString();
                    result2.append("<tr><td align=\"right\"><b>").append(tagName);
                    result2.append(" ").append(s).append(":</b>");
                    result2.append("</td><td>").append(taggedDocString.getTagValue(tagName, s)).append("</td></tr>");
                }
                result2.append("</table>");
            }
        }
        return result2.toString();
    }

    private static void formatParameterDescriptions(@NotNull StructuredDocString docString, @NotNull StringBuilder result2, boolean keyword) {
        List<String> parameters;
        if (docString == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            PyStructuredDocstringFormatter.$$$reportNull$$$0(7);
        }
        List<String> list2 = parameters = keyword ? docString.getKeywordArguments() : docString.getParameters();
        if (parameters.size() > 0) {
            result2.append("<br><b>").append(keyword ? "Keyword arguments:" : "Parameters").append("</b><br>");
            for (String parameter : parameters) {
                String paramType;
                String description = keyword ? docString.getKeywordArgumentDescription(parameter) : docString.getParamDescription(parameter);
                result2.append("<b>");
                result2.append(parameter);
                result2.append("</b>: ");
                if (description != null) {
                    result2.append(description);
                }
                if ((paramType = docString.getParamType(parameter)) != null) {
                    result2.append(" <i>Type: ").append(paramType).append("</i>");
                }
                result2.append("<br>");
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docstring";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyStructuredDocstringFormatter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "formatDocstring";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runExternalTool";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "formatStructuredDocString";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "formatParameterDescriptions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

