/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.containerview;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.util.PlatformUtils;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.containerview.PyDataView;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyViewNumericContainerAction
extends XDebuggerTreeActionBase {
    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        Project p;
        if (nodeName == null) {
            PyViewNumericContainerAction.$$$reportNull$$$0(0);
        }
        if ((p = e.getProject()) != null && node != null && node.getValueContainer() instanceof PyDebugValue && node.isComputed()) {
            PyDebugValue debugValue = (PyDebugValue)node.getValueContainer();
            PyViewNumericContainerAction.showNumericViewer(p, debugValue);
        }
    }

    public static void showNumericViewer(Project project, PyDebugValue debugValue) {
        PyDataView.getInstance(project).show(debugValue, PlatformUtils.isPyCharmPro());
    }

    @Nullable
    private static TreePath[] getSelectedPaths(DataContext dataContext) {
        XDebuggerTree tree = XDebuggerTree.getTree(dataContext);
        return tree == null ? null : tree.getSelectionPaths();
    }

    @Override
    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(false);
        TreePath[] paths = PyViewNumericContainerAction.getSelectedPaths(e.getDataContext());
        if (paths != null) {
            if (paths.length > 1) {
                e.getPresentation().setVisible(false);
                return;
            }
            XValueNodeImpl node = PyViewNumericContainerAction.getSelectedNode(e.getDataContext());
            if (node != null && node.getValueContainer() instanceof PyDebugValue && node.isComputed()) {
                PyDebugValue debugValue = (PyDebugValue)node.getValueContainer();
                String nodeType = debugValue.getType();
                if ("ndarray".equals(nodeType)) {
                    e.getPresentation().setText("View as Array");
                    e.getPresentation().setVisible(true);
                } else if ("DataFrame".equals(nodeType)) {
                    e.getPresentation().setText("View as DataFrame");
                    e.getPresentation().setVisible(true);
                } else {
                    e.getPresentation().setVisible(false);
                }
            } else {
                e.getPresentation().setVisible(false);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/jetbrains/python/debugger/containerview/PyViewNumericContainerAction", "perform"));
    }
}

