/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.stdlib;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableParameterImpl;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyNamedTupleType
extends PyTupleType
implements PyCallableType {
    @NotNull
    private final PsiElement myDeclaration;
    @NotNull
    private final String myName;
    @NotNull
    private final Map<String, FieldTypeAndDefaultValue> myFields;
    @NotNull
    private final DefinitionLevel myDefinitionLevel;

    public PyNamedTupleType(@NotNull PyClass tupleClass, @NotNull PsiElement declaration, @NotNull String name, @NotNull Map<String, FieldTypeAndDefaultValue> fields, @NotNull DefinitionLevel definitionLevel) {
        if (tupleClass == null) {
            PyNamedTupleType.$$$reportNull$$$0(0);
        }
        if (declaration == null) {
            PyNamedTupleType.$$$reportNull$$$0(1);
        }
        if (name == null) {
            PyNamedTupleType.$$$reportNull$$$0(2);
        }
        if (fields == null) {
            PyNamedTupleType.$$$reportNull$$$0(3);
        }
        if (definitionLevel == null) {
            PyNamedTupleType.$$$reportNull$$$0(4);
        }
        super(tupleClass, Collections.unmodifiableList(ContainerUtil.map(fields.values(), typeAndValue -> typeAndValue.getType())), false, definitionLevel != DefinitionLevel.INSTANCE);
        this.myDeclaration = declaration;
        this.myFields = Collections.unmodifiableMap(fields);
        this.myName = name;
        this.myDefinitionLevel = definitionLevel;
    }

    @Override
    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        ArrayList<LookupElementBuilder> result2 = new ArrayList<LookupElementBuilder>();
        Collections.addAll(result2, super.getCompletionVariants(completionPrefix, location, context));
        for (String field : this.myFields.keySet()) {
            result2.add(LookupElementBuilder.create((String)field));
        }
        return ArrayUtil.toObjectArray(result2);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PyNamedTupleType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    public boolean isBuiltin() {
        return false;
    }

    @Override
    @Nullable
    public PyType getCallType(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(6);
        }
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(7);
        }
        if (this.myDefinitionLevel == DefinitionLevel.NT_FUNCTION) {
            return new PyNamedTupleType(this.myClass, this.myDeclaration, this.myName, this.myFields, DefinitionLevel.NEW_TYPE);
        }
        if (this.myDefinitionLevel == DefinitionLevel.NEW_TYPE) {
            Map<String, FieldTypeAndDefaultValue> fields = this.takeFieldsTypesFromCallSiteIfNeeded(context, callSite);
            return new PyNamedTupleType(this.myClass, this.myDeclaration, this.myName, fields, DefinitionLevel.INSTANCE);
        }
        return null;
    }

    @Override
    @NotNull
    public PyClassType toInstance() {
        PyNamedTupleType pyNamedTupleType = this.myDefinitionLevel == DefinitionLevel.NEW_TYPE ? new PyNamedTupleType(this.myClass, this.myDeclaration, this.myName, this.myFields, DefinitionLevel.INSTANCE) : this;
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(8);
        }
        return pyNamedTupleType;
    }

    @Override
    @NotNull
    public PyClassLikeType toClass() {
        PyNamedTupleType pyNamedTupleType = this.myDefinitionLevel == DefinitionLevel.INSTANCE ? this : new PyNamedTupleType(this.myClass, this.myDeclaration, this.myName, this.myFields, DefinitionLevel.NEW_TYPE);
        if (pyNamedTupleType == null) {
            PyNamedTupleType.$$$reportNull$$$0(9);
        }
        return pyNamedTupleType;
    }

    @Override
    public String toString() {
        return "PyNamedTupleType: " + this.myName;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PyNamedTupleType type = (PyNamedTupleType)o;
        return Objects.equals(this.myName, type.myName) && Objects.equals(this.myFields.keySet(), type.myFields.keySet()) && this.myDefinitionLevel == type.myDefinitionLevel;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.myName, this.myFields.keySet(), this.myDefinitionLevel});
    }

    @Override
    @NotNull
    public Set<String> getMemberNames(boolean inherited, @NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(10);
        }
        Set<String> result2 = super.getMemberNames(inherited, context);
        result2.addAll(this.myFields.keySet());
        Set<String> set2 = result2;
        if (set2 == null) {
            PyNamedTupleType.$$$reportNull$$$0(11);
        }
        return set2;
    }

    @NotNull
    public Map<String, FieldTypeAndDefaultValue> getFields() {
        Map<String, FieldTypeAndDefaultValue> map2 = this.myFields;
        if (map2 == null) {
            PyNamedTupleType.$$$reportNull$$$0(12);
        }
        return map2;
    }

    @Override
    public boolean isCallable() {
        return this.myDefinitionLevel != DefinitionLevel.INSTANCE;
    }

    @Override
    @Nullable
    public List<PyCallableParameter> getParameters(@NotNull TypeEvalContext context) {
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(13);
        }
        return this.isCallable() ? ContainerUtil.map(this.myFields.entrySet(), field -> PyNamedTupleType.fieldToCallableParameter((String)field.getKey(), (FieldTypeAndDefaultValue)field.getValue())) : null;
    }

    @NotNull
    private Map<String, FieldTypeAndDefaultValue> takeFieldsTypesFromCallSiteIfNeeded(@NotNull TypeEvalContext context, @NotNull PyCallSiteExpression callSite) {
        List<PyExpression> arguments;
        if (context == null) {
            PyNamedTupleType.$$$reportNull$$$0(14);
        }
        if (callSite == null) {
            PyNamedTupleType.$$$reportNull$$$0(15);
        }
        if (StreamEx.of(this.getElementTypes()).allMatch(Objects::isNull) && (arguments = callSite.getArguments(null)).size() == this.myFields.size()) {
            HashMap<String, FieldTypeAndDefaultValue> result2 = new HashMap<String, FieldTypeAndDefaultValue>();
            for (Map.Entry entry : StreamEx.ofKeys(this.myFields).zipWith((Stream)StreamEx.of(arguments))) {
                String name = (String)entry.getKey();
                PyType type = context.getType((PyTypedElement)entry.getValue());
                PyExpression value = this.myFields.get(name).getDefaultValue();
                result2.put(name, new FieldTypeAndDefaultValue(type, value));
            }
            HashMap<String, FieldTypeAndDefaultValue> hashMap = result2;
            if (hashMap == null) {
                PyNamedTupleType.$$$reportNull$$$0(16);
            }
            return hashMap;
        }
        Map<String, FieldTypeAndDefaultValue> map2 = this.myFields;
        if (map2 == null) {
            PyNamedTupleType.$$$reportNull$$$0(17);
        }
        return map2;
    }

    @NotNull
    private static PyCallableParameter fieldToCallableParameter(@NotNull String name, @NotNull FieldTypeAndDefaultValue typeAndDefaultValue) {
        if (name == null) {
            PyNamedTupleType.$$$reportNull$$$0(18);
        }
        if (typeAndDefaultValue == null) {
            PyNamedTupleType.$$$reportNull$$$0(19);
        }
        PyCallableParameter pyCallableParameter = PyCallableParameterImpl.nonPsi(name, typeAndDefaultValue.getType(), typeAndDefaultValue.getDefaultValue());
        if (pyCallableParameter == null) {
            PyNamedTupleType.$$$reportNull$$$0(20);
        }
        return pyCallableParameter;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 2: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionLevel";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callSite";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeAndDefaultValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/stdlib/PyNamedTupleType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "toInstance";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toClass";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberNames";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFields";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "takeFieldsTypesFromCallSiteIfNeeded";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "fieldToCallableParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCallType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getMemberNames";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getParameters";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "takeFieldsTypesFromCallSiteIfNeeded";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fieldToCallableParameter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FieldTypeAndDefaultValue {
        @Nullable
        private final PyType myType;
        @Nullable
        private final PyExpression myDefaultValue;

        public FieldTypeAndDefaultValue(@Nullable PyType type, @Nullable PyExpression defaultValue) {
            this.myType = type;
            this.myDefaultValue = defaultValue;
        }

        @Nullable
        public PyType getType() {
            return this.myType;
        }

        @Nullable
        public PyExpression getDefaultValue() {
            return this.myDefaultValue;
        }
    }

    public static enum DefinitionLevel {
        NT_FUNCTION,
        NEW_TYPE,
        INSTANCE;

    }
}

