/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomApplicationComponent;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DomFileIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> NAME = ID.create((String)"DomFileIndex");
    private final DataIndexer<String, Void, FileContent> myDataIndexer = new DataIndexer<String, Void, FileContent>(){

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            THashSet namespaces = new THashSet();
            XmlFileHeader header = NanoXmlUtil.parseHeader((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
            ContainerUtil.addIfNotNull((Collection)namespaces, (Object)header.getPublicId());
            ContainerUtil.addIfNotNull((Collection)namespaces, (Object)header.getSystemId());
            ContainerUtil.addIfNotNull((Collection)namespaces, (Object)header.getRootTagNamespace());
            String tagName = header.getRootTagLocalName();
            if (StringUtil.isNotEmpty((String)tagName)) {
                String[] strings;
                THashMap result2 = new THashMap();
                DomApplicationComponent component = DomApplicationComponent.getInstance();
                for (DomFileDescription description : component.getFileDescriptions(tagName)) {
                    strings = description.getAllPossibleRootTagNamespaces();
                    if (strings.length != 0 && !ContainerUtil.intersects(Arrays.asList(strings), (Collection)namespaces)) continue;
                    result2.put((Object)description.getRootElementClass().getName(), null);
                }
                for (DomFileDescription description : component.getAcceptingOtherRootTagNameDescriptions()) {
                    strings = description.getAllPossibleRootTagNamespaces();
                    if (strings.length != 0 && !ContainerUtil.intersects(Arrays.asList(strings), (Collection)namespaces)) continue;
                    result2.put((Object)description.getRootElementClass().getName(), null);
                }
                THashMap tHashMap = result2;
                if (tHashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return tHashMap;
            }
            Map<String, Void> map2 = Collections.emptyMap();
            if (map2 == null) {
                1.$$$reportNull$$$0(2);
            }
            return map2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/util/xml/DomFileIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/util/xml/DomFileIndex$1";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    };

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = NAME;
        if (iD == null) {
            DomFileIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            DomFileIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            DomFileIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{StdFileTypes.XML});
        if (defaultFileTypeSpecificInputFilter == null) {
            DomFileIndex.$$$reportNull$$$0(3);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return DomApplicationComponent.getInstance().getCumulativeVersion(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/util/xml/DomFileIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

