/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ChangeTrackingValueContainer;
import com.intellij.util.indexing.impl.DebugAssertions;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.UpdatableValueContainer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class MemoryIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private final Map<Key, ChangeTrackingValueContainer<Value>> myMap;
    @NotNull
    private final IndexStorage<Key, Value> myBackendStorage;
    private final List<BufferingStateListener> myListeners;
    private final ID<?, ?> myIndexId;
    private boolean myBufferingEnabled;

    public MemoryIndexStorage(@NotNull IndexStorage<Key, Value> backend) {
        if (backend == null) {
            MemoryIndexStorage.$$$reportNull$$$0(0);
        }
        this(backend, null);
    }

    public MemoryIndexStorage(@NotNull IndexStorage<Key, Value> backend, ID<?, ?> indexId) {
        if (backend == null) {
            MemoryIndexStorage.$$$reportNull$$$0(1);
        }
        this.myMap = new HashMap<Key, ChangeTrackingValueContainer<Value>>();
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myBackendStorage = backend;
        this.myIndexId = indexId;
    }

    @NotNull
    public IndexStorage<Key, Value> getBackendStorage() {
        IndexStorage<Key, Value> indexStorage = this.myBackendStorage;
        if (indexStorage == null) {
            MemoryIndexStorage.$$$reportNull$$$0(2);
        }
        return indexStorage;
    }

    public void addBufferingStateListener(@NotNull BufferingStateListener listener2) {
        if (listener2 == null) {
            MemoryIndexStorage.$$$reportNull$$$0(3);
        }
        this.myListeners.add(listener2);
    }

    public void removeBufferingStateListener(@NotNull BufferingStateListener listener2) {
        if (listener2 == null) {
            MemoryIndexStorage.$$$reportNull$$$0(4);
        }
        this.myListeners.remove(listener2);
    }

    public void setBufferingEnabled(boolean enabled) {
        boolean wasEnabled = this.myBufferingEnabled;
        assert (wasEnabled != enabled);
        this.myBufferingEnabled = enabled;
        for (BufferingStateListener listener2 : this.myListeners) {
            listener2.bufferingStateChanged(enabled);
        }
    }

    public boolean isBufferingEnabled() {
        return this.myBufferingEnabled;
    }

    public void clearMemoryMap() {
        this.myMap.clear();
    }

    public void fireMemoryStorageCleared() {
        for (BufferingStateListener listener2 : this.myListeners) {
            listener2.memoryStorageCleared();
        }
    }

    public void clearCaches() {
        try {
            if (this.myMap.size() == 0) {
                return;
            }
            if (DebugAssertions.DEBUG) {
                String message = "Dropping caches for " + (this.myIndexId != null ? this.myIndexId : this) + ", number of items:" + this.myMap.size();
                FileBasedIndexImpl.LOG.info(message);
            }
            for (ChangeTrackingValueContainer<Value> v : this.myMap.values()) {
                v.dropMergedData();
            }
        }
        finally {
            this.myBackendStorage.clearCaches();
        }
    }

    public void close() throws StorageException {
        this.myBackendStorage.close();
    }

    public void clear() throws StorageException {
        this.clearMemoryMap();
        this.myBackendStorage.clear();
    }

    public void flush() throws IOException {
        this.myBackendStorage.flush();
    }

    @Override
    public boolean processKeys(@NotNull Processor<Key> processor2, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        if (processor2 == null) {
            MemoryIndexStorage.$$$reportNull$$$0(5);
        }
        HashSet<Key> stopList = new HashSet<Key>();
        Processor<Key> decoratingProcessor = key -> {
            if (processor2 == null) {
                MemoryIndexStorage.$$$reportNull$$$0(9);
            }
            if (stopList.contains(key)) {
                return true;
            }
            UpdatableValueContainer container = (UpdatableValueContainer)this.myMap.get(key);
            if (container != null && container.size() == 0) {
                return true;
            }
            return processor2.process(key);
        };
        for (Key key2 : this.myMap.keySet()) {
            if (!decoratingProcessor.process(key2)) {
                return false;
            }
            stopList.add(key2);
        }
        return ((VfsAwareIndexStorage)this.myBackendStorage).processKeys(stopList.isEmpty() && this.myMap.isEmpty() ? processor2 : decoratingProcessor, scope, idFilter);
    }

    public void addValue(Key key, int inputId, Value value) throws StorageException {
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key).addValue(inputId, value);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.addValue(key, inputId, value);
    }

    public void removeAllValues(@NotNull Key key, int inputId) throws StorageException {
        if (key == null) {
            MemoryIndexStorage.$$$reportNull$$$0(6);
        }
        if (this.myBufferingEnabled) {
            this.getMemValueContainer(key).removeAssociatedValue(inputId);
            return;
        }
        ChangeTrackingValueContainer<Value> valueContainer = this.myMap.get(key);
        if (valueContainer != null) {
            valueContainer.dropMergedData();
        }
        this.myBackendStorage.removeAllValues(key, inputId);
    }

    private UpdatableValueContainer<Value> getMemValueContainer(final Key key) {
        ChangeTrackingValueContainer valueContainer = this.myMap.get(key);
        if (valueContainer == null) {
            valueContainer = new ChangeTrackingValueContainer(new ChangeTrackingValueContainer.Initializer<Value>(){

                public Object getLock() {
                    return this;
                }

                public ValueContainer<Value> compute() {
                    try {
                        return MemoryIndexStorage.this.myBackendStorage.read(key);
                    }
                    catch (StorageException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.myMap.put(key, valueContainer);
        }
        return valueContainer;
    }

    @NotNull
    public ValueContainer<Value> read(Key key) throws StorageException {
        ValueContainer valueContainer = (ValueContainer)this.myMap.get(key);
        if (valueContainer != null) {
            ValueContainer valueContainer2 = valueContainer;
            if (valueContainer2 == null) {
                MemoryIndexStorage.$$$reportNull$$$0(7);
            }
            return valueContainer2;
        }
        ValueContainer valueContainer3 = this.myBackendStorage.read(key);
        if (valueContainer3 == null) {
            MemoryIndexStorage.$$$reportNull$$$0(8);
        }
        return valueContainer3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/MemoryIndexStorage";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/MemoryIndexStorage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackendStorage";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "read";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addBufferingStateListener";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeBufferingStateListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processKeys";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeAllValues";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processKeys$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BufferingStateListener {
        public void bufferingStateChanged(boolean var1);

        public void memoryStorageCleared();
    }
}

