/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import gnu.trove.THashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RecentsManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class RecentsManager
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String KEY_ELEMENT_NAME = "key";
    @NonNls
    private static final String RECENT_ELEMENT_NAME = "recent";
    @NonNls
    protected static final String NAME_ATTR = "name";
    private final Map<String, LinkedList<String>> myMap = new THashMap();
    private int myRecentsNumberToKeep = 5;

    @NotNull
    public static RecentsManager getInstance(@NotNull Project project) {
        if (project == null) {
            RecentsManager.$$$reportNull$$$0(0);
        }
        RecentsManager recentsManager = (RecentsManager)ServiceManager.getService((Project)project, RecentsManager.class);
        if (recentsManager == null) {
            RecentsManager.$$$reportNull$$$0(1);
        }
        return recentsManager;
    }

    @Nullable
    public List<String> getRecentEntries(@NotNull String key) {
        if (key == null) {
            RecentsManager.$$$reportNull$$$0(2);
        }
        return this.myMap.get(key);
    }

    public void registerRecentEntry(@NotNull String key, String recentEntry) {
        LinkedList<String> recents;
        if (key == null) {
            RecentsManager.$$$reportNull$$$0(3);
        }
        if ((recents = this.myMap.get(key)) == null) {
            recents = new LinkedList();
            this.myMap.put(key, recents);
        }
        this.add(recents, recentEntry);
    }

    private void add(LinkedList<String> recentEntries, String newEntry) {
        int oldIndex = recentEntries.indexOf(newEntry);
        if (oldIndex >= 0) {
            recentEntries.remove(oldIndex);
        } else if (recentEntries.size() == this.myRecentsNumberToKeep) {
            recentEntries.removeLast();
        }
        recentEntries.addFirst(newEntry);
    }

    public void loadState(Element element) {
        this.myMap.clear();
        for (Element keyElement : element.getChildren(KEY_ELEMENT_NAME)) {
            LinkedList<String> recents = new LinkedList<String>();
            for (Element aChildren : keyElement.getChildren(RECENT_ELEMENT_NAME)) {
                recents.addLast(aChildren.getAttributeValue(NAME_ATTR));
            }
            this.myMap.put(keyElement.getAttributeValue(NAME_ATTR), recents);
        }
    }

    public Element getState() {
        Element element = new Element("state");
        for (Map.Entry<String, LinkedList<String>> entry : this.myMap.entrySet()) {
            Element keyElement = new Element(KEY_ELEMENT_NAME);
            keyElement.setAttribute(NAME_ATTR, entry.getKey());
            for (String recent : entry.getValue()) {
                keyElement.addContent(new Element(RECENT_ELEMENT_NAME).setAttribute(NAME_ATTR, recent));
            }
            element.addContent(keyElement);
        }
        return element;
    }

    public void setRecentsNumberToKeep(int recentsNumberToKeep) {
        this.myRecentsNumberToKeep = recentsNumberToKeep;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/RecentsManager";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = KEY_ELEMENT_NAME;
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/RecentsManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getRecentEntries";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerRecentEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

