/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiModificationTrackerImpl
implements PsiModificationTracker,
PsiTreeChangePreprocessor {
    private static final RegistryValue ourEnableCodeBlockTracker = Registry.get((String)"psi.modification.tracker.code-block");
    private static final RegistryValue ourEnableJavaStructureTracker = Registry.get((String)"psi.modification.tracker.java-structure");
    private static final RegistryValue ourEnableLanguageTracker = Registry.get((String)"psi.modification.tracker.per-language");
    private final boolean myTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private final SimpleModificationTracker myModificationCount = new SimpleModificationTracker();
    private final SimpleModificationTracker myOutOfCodeBlockModificationTracker = PsiModificationTrackerImpl.wrapped(ourEnableCodeBlockTracker, this.myModificationCount, this.myTestMode);
    private final SimpleModificationTracker myJavaStructureModificationTracker = PsiModificationTrackerImpl.wrapped(ourEnableJavaStructureTracker, this.myModificationCount, this.myTestMode);
    private final Map<Language, ModificationTracker> myLanguageTrackers = ConcurrentFactoryMap.createMap(language -> new SimpleModificationTracker());
    private final PsiModificationTracker.Listener myPublisher;

    public PsiModificationTrackerImpl(Project project) {
        MessageBus bus = project.getMessageBus();
        this.myPublisher = (PsiModificationTracker.Listener)bus.syncPublisher(TOPIC);
        bus.connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            private void doIncCounter() {
                ApplicationManager.getApplication().runWriteAction(() -> PsiModificationTrackerImpl.this.incCounter());
            }

            public void enteredDumbMode() {
                this.doIncCounter();
            }

            public void exitDumbMode() {
                this.doIncCounter();
            }
        });
    }

    public void incCounter() {
        this.incCountersInner(7);
    }

    public void incOutOfCodeBlockModificationCounter() {
        this.incCountersInner(3);
    }

    private void fireEvent() {
        ((TransactionGuardImpl)TransactionGuard.getInstance()).assertWriteActionAllowed();
        this.myPublisher.modificationCountChanged();
    }

    private void incCountersInner(int bits) {
        if ((bits & 1) != 0) {
            this.myModificationCount.incModificationCount();
        }
        if ((bits & 2) != 0) {
            this.myOutOfCodeBlockModificationTracker.incModificationCount();
        }
        if ((bits & 4) != 0) {
            this.myJavaStructureModificationTracker.incModificationCount();
        }
        this.fireEvent();
    }

    @Override
    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(0);
        }
        if (!PsiModificationTrackerImpl.canAffectPsi(event)) {
            return;
        }
        this.incLanguageTrackers(event);
        PsiTreeChangeEventImpl.PsiEventType code2 = event.getCode();
        boolean outOfCodeBlock = code2 == PsiTreeChangeEventImpl.PsiEventType.PROPERTY_CHANGED ? event.getPropertyName() == "propUnloadedPsi" : (code2 == PsiTreeChangeEventImpl.PsiEventType.CHILD_MOVED ? event.getOldParent() instanceof PsiDirectory || event.getNewParent() instanceof PsiDirectory : event.getParent() instanceof PsiDirectory);
        this.incCountersInner(outOfCodeBlock ? 7 : 1);
    }

    public static boolean canAffectPsi(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(1);
        }
        return !"writable".equals(event.getPropertyName());
    }

    protected void incLanguageTrackers(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(2);
        }
        if (!ourEnableLanguageTracker.asBoolean()) {
            return;
        }
        this.incLanguageModificationCount(Language.ANY);
        for (PsiElement o : new PsiElement[]{event.getFile(), event.getParent(), event.getOldParent(), event.getNewParent(), event.getElement(), event.getChild(), event.getOldChild(), event.getNewChild()}) {
            PsiFile file2;
            PsiFile psiFile = file2 = o instanceof PsiFile ? (PsiFile)o : null;
            if (file2 == null) {
                try {
                    IElementType type = PsiUtilCore.getElementType((PsiElement)o);
                    Language language = type != null ? type.getLanguage() : (o != null ? o.getLanguage() : null);
                    this.incLanguageModificationCount(language);
                }
                catch (PsiInvalidElementAccessException e) {
                    PsiDocumentManagerBase.LOG.warn((Throwable)e);
                }
                continue;
            }
            for (Language language : file2.getViewProvider().getLanguages()) {
                this.incLanguageModificationCount(language);
            }
        }
    }

    public long getModificationCount() {
        return this.myModificationCount.getModificationCount();
    }

    public long getOutOfCodeBlockModificationCount() {
        return this.myOutOfCodeBlockModificationTracker.getModificationCount();
    }

    public long getJavaStructureModificationCount() {
        return this.myJavaStructureModificationTracker.getModificationCount();
    }

    @NotNull
    public ModificationTracker getOutOfCodeBlockModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myOutOfCodeBlockModificationTracker;
        if (simpleModificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(3);
        }
        return simpleModificationTracker;
    }

    @NotNull
    public ModificationTracker getJavaStructureModificationTracker() {
        SimpleModificationTracker simpleModificationTracker = this.myJavaStructureModificationTracker;
        if (simpleModificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(4);
        }
        return simpleModificationTracker;
    }

    @ApiStatus.Experimental
    public boolean isEnableCodeBlockTracker() {
        if (this.myTestMode) {
            return true;
        }
        return ourEnableCodeBlockTracker.asBoolean();
    }

    @ApiStatus.Experimental
    public boolean isEnableLanguageTracker() {
        return ourEnableLanguageTracker.asBoolean();
    }

    @ApiStatus.Experimental
    public void incLanguageModificationCount(@Nullable Language language) {
        if (language == null) {
            return;
        }
        ((SimpleModificationTracker)this.myLanguageTrackers.get(language)).incModificationCount();
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguage(@NotNull Language language) {
        if (language == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(5);
        }
        if (!ourEnableLanguageTracker.asBoolean()) {
            PsiModificationTrackerImpl psiModificationTrackerImpl = this;
            if (psiModificationTrackerImpl == null) {
                PsiModificationTrackerImpl.$$$reportNull$$$0(6);
            }
            return psiModificationTrackerImpl;
        }
        ModificationTracker modificationTracker = this.myLanguageTrackers.get(language);
        if (modificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(7);
        }
        return modificationTracker;
    }

    @ApiStatus.Experimental
    @NotNull
    public ModificationTracker forLanguages(@NotNull Condition<Language> condition) {
        if (condition == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(8);
        }
        if (!ourEnableLanguageTracker.asBoolean()) {
            PsiModificationTrackerImpl psiModificationTrackerImpl = this;
            if (psiModificationTrackerImpl == null) {
                PsiModificationTrackerImpl.$$$reportNull$$$0(9);
            }
            return psiModificationTrackerImpl;
        }
        ModificationTracker modificationTracker = () -> {
            if (condition == null) {
                PsiModificationTrackerImpl.$$$reportNull$$$0(13);
            }
            long result2 = 0L;
            for (Language l : this.myLanguageTrackers.keySet()) {
                if (condition.value((Object)l)) continue;
                result2 += this.myLanguageTrackers.get(l).getModificationCount();
            }
            return result2;
        };
        if (modificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(10);
        }
        return modificationTracker;
    }

    @NotNull
    private static SimpleModificationTracker wrapped(final RegistryValue value, final SimpleModificationTracker fallback, boolean testMode) {
        if (testMode) {
            SimpleModificationTracker simpleModificationTracker = new SimpleModificationTracker();
            if (simpleModificationTracker == null) {
                PsiModificationTrackerImpl.$$$reportNull$$$0(11);
            }
            return simpleModificationTracker;
        }
        SimpleModificationTracker simpleModificationTracker = new SimpleModificationTracker(){

            public long getModificationCount() {
                return value.asBoolean() ? super.getModificationCount() : fallback.getModificationCount();
            }

            public void incModificationCount() {
                if (value.asBoolean()) {
                    super.incModificationCount();
                }
            }
        };
        if (simpleModificationTracker == null) {
            PsiModificationTrackerImpl.$$$reportNull$$$0(12);
        }
        return simpleModificationTracker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiModificationTrackerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutOfCodeBlockModificationTracker";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaStructureModificationTracker";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguages";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "treeChanged";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "canAffectPsi";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "incLanguageTrackers";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "forLanguages";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$forLanguages$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

