/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BackwardParagraphAction
extends EditorAction {
    public BackwardParagraphAction() {
        super((EditorActionHandler)new MyHandler());
    }

    private static class MyHandler
    extends EditorActionHandler {
        private MyHandler() {
            super(true);
        }

        protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
            boolean atLineStart;
            if (editor == null) {
                MyHandler.$$$reportNull$$$0(0);
            }
            assert (caret != null);
            Document document = editor.getDocument();
            int currentLine = caret.getLogicalPosition().line;
            boolean bl = atLineStart = caret.getLogicalPosition().column == 0;
            if (MyHandler.isLineEmpty(document, currentLine) || atLineStart) {
                while (--currentLine >= 0 && MyHandler.isLineEmpty(document, currentLine)) {
                }
            }
            while (--currentLine >= 0 && !MyHandler.isLineEmpty(document, currentLine)) {
            }
            int targetOffset = 0;
            if (currentLine >= 0) {
                int targetLineEnd;
                int targetLineStart = document.getLineStartOffset(currentLine);
                targetOffset = targetLineStart == (targetLineEnd = document.getLineEndOffset(currentLine)) ? targetLineStart : document.getLineStartOffset(currentLine + 1);
            }
            caret.removeSelection();
            caret.moveToOffset(targetOffset);
            EditorModificationUtil.scrollToCaret((Editor)editor);
        }

        private static boolean isLineEmpty(Document document, int line) {
            return StringUtil.equalsIgnoreWhitespaces((CharSequence)document.getImmutableCharSequence().subSequence(document.getLineStartOffset(line), document.getLineEndOffset(line)), (CharSequence)"");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/BackwardParagraphAction$MyHandler", "doExecute"));
        }
    }
}

