/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateInstaller;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BuildNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UpdatePluginsApp
extends ApplicationStarterEx {
    public boolean isHeadless() {
        return true;
    }

    public String getCommandName() {
        return "update";
    }

    public void premain(String[] args) {
    }

    public void main(String[] args) {
        List<String> pluginsToUpdate = UpdatePluginsApp.getPluginsToUpdate(args);
        ActionCallback callback = new ActionCallback().doWhenDone(() -> System.exit(0)).doWhenRejected(() -> System.exit(1));
        Runnable update = () -> UpdatePluginsApp.updateAllPlugins(callback, pluginsToUpdate);
        ApplicationManager.getApplication().executeOnPooledThread(update);
    }

    @Nullable
    private static List<String> getPluginsToUpdate(String[] args) {
        if (args.length < 2) {
            return null;
        }
        ArrayList<String> pluginIds = new ArrayList<String>(args.length - 1);
        for (int i = 1; i < args.length; ++i) {
            pluginIds.add(i - 1, args[i]);
        }
        return pluginIds;
    }

    private static void updateAllPlugins(ActionCallback callback, @Nullable List<String> plugins2) {
        Collection availableUpdates = UpdateChecker.checkPluginsUpdate(UpdateSettings.getInstance(), (ProgressIndicator)new EmptyProgressIndicator(), new HashSet<IdeaPluginDescriptor>(), BuildNumber.currentVersion());
        if (availableUpdates == null) {
            UpdatePluginsApp.log("All plugins up to date.");
            callback.setDone();
            return;
        }
        Collection pluginsToUpdate = plugins2 == null || plugins2.isEmpty() ? availableUpdates : (Collection)availableUpdates.stream().filter(downloader -> plugins2.contains(downloader.getPluginId())).collect(Collectors.toList());
        UpdatePluginsApp.log("Plugins to update:");
        pluginsToUpdate.forEach(d -> UpdatePluginsApp.log("\t" + d.getPluginName()));
        if (UpdateInstaller.installPluginUpdates(pluginsToUpdate, (ProgressIndicator)new EmptyProgressIndicator())) {
            callback.setDone();
        } else {
            UpdatePluginsApp.log("Update failed");
            callback.setRejected();
        }
    }

    private static void log(String msg) {
        System.out.println(msg);
    }
}

