/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditorHelper {
    public static <T extends PsiElement> void openFilesInEditor(@NotNull T[] elements) {
        if (elements == null) {
            EditorHelper.$$$reportNull$$$0(0);
        }
        int limit = UISettings.getInstance().getEditorTabLimit();
        int max = Math.min(limit, elements.length);
        for (int i = 0; i < max; ++i) {
            EditorHelper.openInEditor(elements[i], true);
        }
    }

    public static Editor openInEditor(@NotNull PsiElement element) {
        FileEditor editor;
        if (element == null) {
            EditorHelper.$$$reportNull$$$0(1);
        }
        return (editor = EditorHelper.openInEditor(element, true)) instanceof TextEditor ? ((TextEditor)editor).getEditor() : null;
    }

    @Nullable
    public static FileEditor openInEditor(@NotNull PsiElement element, boolean switchToText) {
        int offset;
        PsiFile file2;
        if (element == null) {
            EditorHelper.$$$reportNull$$$0(2);
        }
        if (element instanceof PsiFile) {
            file2 = (PsiFile)element;
            offset = -1;
        } else {
            file2 = element.getContainingFile();
            offset = element.getTextOffset();
        }
        if (file2 == null) {
            return null;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        OpenFileDescriptor descriptor2 = new OpenFileDescriptor(element.getProject(), virtualFile, offset);
        Project project = element.getProject();
        if (offset == -1 && !switchToText) {
            FileEditorManager.getInstance((Project)project).openEditor(descriptor2, false);
        } else {
            FileEditorManager.getInstance((Project)project).openTextEditor(descriptor2, false);
        }
        return FileEditorManager.getInstance((Project)project).getSelectedEditor(virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/util/EditorHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "openFilesInEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "openInEditor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

