/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LibraryGroupNode
extends ProjectViewNode<LibraryGroupElement> {
    public LibraryGroupNode(Project project, LibraryGroupElement value, ViewSettings viewSettings) {
        super(project, (Object)value, viewSettings);
    }

    public LibraryGroupNode(Project project, Object value, ViewSettings viewSettings) {
        this(project, (LibraryGroupElement)value, viewSettings);
    }

    @NotNull
    public Collection<AbstractTreeNode> getChildren() {
        OrderEntry[] orderEntries;
        Module module2 = ((LibraryGroupElement)this.getValue()).getModule();
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
            JdkOrderEntry jdkOrderEntry;
            Sdk jdk;
            if (orderEntry instanceof LibraryOrderEntry) {
                LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                Library library = libraryOrderEntry.getLibrary();
                if (library == null) continue;
                String libraryName = library.getName();
                if (libraryName == null || libraryName.length() == 0) {
                    LibraryGroupNode.addLibraryChildren((LibraryOrSdkOrderEntry)libraryOrderEntry, children2, this.getProject(), this);
                    continue;
                }
                children2.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module2, (LibraryOrSdkOrderEntry)libraryOrderEntry), this.getSettings()));
                continue;
            }
            if (!(orderEntry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) == null) continue;
            children2.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(module2, (LibraryOrSdkOrderEntry)jdkOrderEntry), this.getSettings()));
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            LibraryGroupNode.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    public static void addLibraryChildren(LibraryOrSdkOrderEntry entry, List<AbstractTreeNode> children2, Project project, ProjectViewNode node) {
        VirtualFile[] files;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        for (VirtualFile file2 : files = entry instanceof LibraryOrderEntry ? LibraryGroupNode.getLibraryRoots((LibraryOrderEntry)entry) : entry.getRootFiles(OrderRootType.CLASSES)) {
            if (!file2.isValid()) continue;
            if (file2.isDirectory()) {
                PsiDirectory psiDir = psiManager.findDirectory(file2);
                if (psiDir == null) continue;
                children2.add((AbstractTreeNode)new PsiDirectoryNode(project, psiDir, node.getSettings()));
                continue;
            }
            PsiFile psiFile = psiManager.findFile(file2);
            if (psiFile == null) continue;
            children2.add((AbstractTreeNode)new PsiFileNode(project, psiFile, node.getSettings()));
        }
    }

    public String getTestPresentation() {
        return "Libraries";
    }

    public boolean contains(@NotNull VirtualFile file2) {
        ProjectFileIndex index;
        if (file2 == null) {
            LibraryGroupNode.$$$reportNull$$$0(1);
        }
        if (!(index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex()).isInLibrarySource(file2) && !index.isInLibraryClasses(file2)) {
            return false;
        }
        return this.someChildContainsFile(file2, false);
    }

    public void update(PresentationData presentation) {
        presentation.setPresentableText(IdeBundle.message((String)"node.projectview.libraries", (Object[])new Object[0]));
        presentation.setIcon(PlatformIcons.LIBRARY_ICON);
    }

    public boolean canNavigate() {
        return ProjectSettingsService.getInstance(this.myProject).canOpenModuleLibrarySettings();
    }

    public void navigate(boolean requestFocus) {
        Module module2 = ((LibraryGroupElement)this.getValue()).getModule();
        ProjectSettingsService.getInstance(this.myProject).openModuleLibrarySettings(module2);
    }

    @NotNull
    public static VirtualFile[] getLibraryRoots(@NotNull LibraryOrderEntry orderEntry) {
        Library library;
        if (orderEntry == null) {
            LibraryGroupNode.$$$reportNull$$$0(2);
        }
        if ((library = orderEntry.getLibrary()) == null) {
            if (VirtualFile.EMPTY_ARRAY == null) {
                LibraryGroupNode.$$$reportNull$$$0(3);
            }
            return VirtualFile.EMPTY_ARRAY;
        }
        OrderRootType[] rootTypes = LibraryType.DEFAULT_EXTERNAL_ROOT_TYPES;
        if (library instanceof LibraryEx) {
            if (((LibraryEx)library).isDisposed()) {
                if (VirtualFile.EMPTY_ARRAY == null) {
                    LibraryGroupNode.$$$reportNull$$$0(4);
                }
                return VirtualFile.EMPTY_ARRAY;
            }
            PersistentLibraryKind libKind = ((LibraryEx)library).getKind();
            if (libKind != null) {
                rootTypes = LibraryType.findByKind((LibraryKind)libKind).getExternalRootTypes();
            }
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (OrderRootType rootType : rootTypes) {
            files.addAll(Arrays.asList(library.getFiles(rootType)));
        }
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(files);
        if (virtualFileArray == null) {
            LibraryGroupNode.$$$reportNull$$$0(5);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/projectView/impl/nodes/LibraryGroupNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderEntry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/projectView/impl/nodes/LibraryGroupNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLibraryRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

